/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.cache.sequence.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

import org.openprivacy.reptile.actions.util.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: MarkAllSubscriptionsRead.java,v 1.2 2002/02/09 05:55:47 burton Exp $
 */
public class MarkAllSubscriptionsRead implements Action {

    public ActionDirective perform( ParameterPasser params,
                                    HttpSession session ) throws Exception {
        
        //execute a DB update so that all 

        ArticlePeer.markAllSubscriptionsRead();

        //we have to flush the sequence cache here.  This isn't very efficient
        //but there really is no great way to handle this.
        SequenceCache.getInstance().flush();

        //go back to subscriptions when done.
        ActionDirective ad = new ActionDirective();
        ad.setRedirect( new LinkProducer( params, session, "urn:subscriptions" ).toString() );
        return ad;

    }
    
}

