/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.util.*;

/**
 * Class whose overall purpose is to login to Repile.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Login.java,v 1.8 2001/09/23 01:06:56 burton Exp $
 */
public class Login implements Action {

    /**
     * <code>perform</code> handles logging into Reptile.
     *
     * @exception Exception if an error occurs
     */
    public ActionDirective perform( ParameterPasser params, 
                                    HttpSession session ) throws Exception {

        Log.message( "Performing action: login" );
            
        String username = params.getString( "username" );

        session.setAttribute( "username", username );

        //create a session nymbuilder for this username.
        setNymBuilder( session, username );

        return null;
        
    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Login.java,v 1.8 2001/09/23 01:06:56 burton Exp $
     */
    private void setNymBuilder( HttpSession session, String username ) {

        Log.debug( "Setting NymBuilder for session: " + username );
        
        try { 
        
            NymBuilder nb = NymBuilderFactory.getInstance( username );

            session.setAttribute( NymBuilder.class.getName(), nb );
            
        } catch ( Throwable t ) {

            Log.error( t );

        }
        
    }
    
}
