/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.util.*;

/**
 * Handles performing the correct action based on the give reptile.action
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ActionManager.java,v 1.17 2001/11/29 05:08:38 burton Exp $
 */
public class ActionManager {

    /**
     * Execute any actions... Return true if we have redirected.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ActionManager.java,v 1.17 2001/11/29 05:08:38 burton Exp $
     */
    public static boolean exec( HttpServletRequest request,
                                HttpServletResponse response ) throws ServletException {

        try {
        
            String action = request.getParameter( ReptileResources.REPTILE_ACTION_KEY );

            if ( action != null ) {

                Log.message( "Executing action: " + action );
                
                Action act = (Action)Class.forName( "org.openprivacy.reptile.actions." + action ).newInstance();

                ParameterPasser params = new ParameterPasser( request, response );

                HttpSession session = request.getSession();
                
                ActionDirective ad = act.perform( params, session );

                //determine if we need to redirect per the action.

                if ( ad != null && ad.getRedirect() != null ) {

                    response.sendRedirect( response.encodeURL( ad.getRedirect() ) );

                    return true;
                    
                } 

                //find out if we need to redirect via 'next' params
                return redirect( params, session, response );
                
            }

        } catch ( Throwable t ) {

            Log.error( t );
            
            throw new ServletException( t.getMessage() );

        }

        return false;
        
    }

    /**
     * Redirect to a new page if necesary.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ActionManager.java,v 1.17 2001/11/29 05:08:38 burton Exp $
     */
    private static boolean redirect( ParameterPasser params,
                                     HttpSession session,
                                     HttpServletResponse response ) throws Exception {

        String nextActionSequence = params.getString( ReptileResources.REPTILE_ACTION_NEXT_SEQUENCE_KEY );

        String nextActionLayer = params.getString( ReptileResources.REPTILE_ACTION_NEXT_LAYER_KEY );

        //always goto a new sequence
        if ( nextActionSequence != null ) {
            
            LinkProducer link = new LinkProducer( params, session, nextActionSequence );

            //FIXME: Need to pass all ADDITOANAL params, just not action or next params.

            link.include( params );
            
            //add the layer if neccesary
            if ( nextActionLayer != null ) {

                link.value( ReptileResources.REPTILE_LAYER_KEY, URLEncoder.encode( nextActionLayer ) );
                
            }

            String encoded = response.encodeURL( link.getLink() );

            Log.message( "ActionManager -> REDIRECTING TO: " + encoded );
            
            response.sendRedirect( encoded );

            return true;

        }

        return false;

    }
        
}
