/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.util.*;

/**
 * Performs some type of web application action.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Action.java,v 1.4 2001/09/23 01:06:56 burton Exp $
 */
public interface Action {

    /**
     * Perform an action.  The ParameterPasser is an abstraction of the HTTP
     * params passed via the POST or GET method.
     *
     * @returns ActionDirective Return an ActionDirective if we have futher work
     *          to perform.  This value will be null for the default.
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Action.java,v 1.4 2001/09/23 01:06:56 burton Exp $
     */
    public ActionDirective perform( ParameterPasser params,
                                    HttpSession session ) throws Exception;

}
