/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.util.*;
import java.io.*;

import org.apache.catalina.startup.Bootstrap;

/**
 * Handles starting up Tomcat and all evil portability issues.
 *
 * This script operates very similar to the catalina.bat script witihin the
 * Tomcat distribution.
 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Startup.java,v 1.3 2002/07/09 18:46:42 burton Exp $
 */
public class Startup {

    /**
     * Java home directory
     */
    private static String java_home = null;

    /**
     * catalina home directory
     */
    private static String catalina_home = null;

    private static boolean debug = false;
    
    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void main( String[] args ) {

        try {

            System.out.println( "Starting reptile..." );

            init();
            
            //ok... startup Tomcat now...
            startup();
            
            System.out.println( "Initializing java environment...done" );

        } catch ( Exception e ) {

            System.out.println( "Reptile initialization FAILED! " );

            e.printStackTrace();
            
        }

    }

    /**
     * Initialize a JVM for use with the startup and shutdown sequences.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void init() throws Exception {

        //find the java home directory
        java_home = System.getProperty( "java.home" );

        // This is stupid!  They give me the JRE home directory anod not the
        // Java home directory

        if ( java_home.endsWith( "/jre" ) ) {

            //jerks!

            String new_java_home = java_home.substring( 0, java_home.length() - "/jre".length() );

            //make sure that the jre, lib, etc directories exist.

            if ( new File( new_java_home + File.separatorChar + "jre" ).exists() &&
                 new File( new_java_home + File.separatorChar + "lib" ).exists() ) {

                //looks good.
                java_home = new_java_home;
                
            } 

        } 

        //NOTE: this requires that we startup Reptile from the directory that
        //Reptile has been downloaded to.. 
        catalina_home = System.getProperty( "user.dir" );

//         if ( args.length > 0 && "--debug".equals( args[0] ) ) {

//             debug = true;
            
//         } 

        System.out.println( "Initializing java environment..." );
        
        System.out.println( "Using JAVA_HOME: " + java_home );
        System.out.println( "Using CATALINA_HOME: " + catalina_home );

        System.setProperty( "CATALINA_HOME", catalina_home );

        if ( debug ) {

            System.getProperties().list( System.out );
            
        } 

        //perform some sanity checks.
        sanity();

        //setup classpath
        classpath();

        System.out.println( "Initializing java environment...done" );

    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void sanity() throws Exception {

        System.out.println( "Performing sanity checks..." );
        
        //make sure that ${catalina_home}/conf

        File confdir = new File( catalina_home + File.separatorChar + "conf" );
        
        if ( confdir.exists() == false || confdir.isDirectory() == false )  {
            
            throw new Exception( "CATALINA_HOME directory not contain 'conf' directory - " +
                                 confdir.getAbsolutePath() );
                
        } 

        System.out.println( "Performing sanity checks...done" );

    }

    /**
     * Setup system classpath...
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void classpath() throws Exception {

        String bootstrap_jar = catalina_home + File.separator + "bin" + File.separator + "bootstrap.jar";
        String jxta_urn_handler_jar = catalina_home + File.separator + "lib" + File.separator + "jxta-urn-handler.jar";

        String tools_jar = null;

        tools_jar = java_home + File.separator + "lib" + File.separator + "tools.jar";

        addClasspathEntry( bootstrap_jar );
        addClasspathEntry( jxta_urn_handler_jar );
        addClasspathEntry( tools_jar );

        System.out.println( "Using classpath: " );
        System.out.println( System.getProperty( "java.class.path" ) );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void addClasspathEntry( String file ) throws Exception {

        if ( new File( file ).exists() == false ) {

            System.out.println( "Classpath entry does not exist: " + file );
            
        } 

        System.out.println( "Adding to classpath: " + file );
        
        String jcp = "java.class.path" ;
        
        System.setProperty( jcp, System.getProperty( jcp ) + File.pathSeparatorChar + file );

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void startup() throws Exception {

        System.out.println( ClassLoader.getSystemClassLoader().getClass().getName() );
        
        Vector v = new Vector();

        v.addElement( "start" );

        String[] args = new String[ v.size() ];
        v.copyInto( args );

        System.out.println( "Starting Tomcat..." );
        Bootstrap.main( args );
        
    }
    
}
