/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.util.*;
import java.io.*;

import org.apache.catalina.startup.Bootstrap;

/**
 * Handles starting up Tomcat and all evil portability issues.
 *
 * This script operates very similar to the catalina.bat script witihin the
 * Tomcat distribution.
 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Shutdown.java,v 1.1 2002/07/06 06:18:13 burton Exp $
 */
public class Shutdown {

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void main( String[] args ) {

        try {

            System.out.println( "Shutting down reptile..." );

            Startup.init();
            
            //ok... shutdown Tomcat now...
            shutdown();

        } catch ( Exception e ) {

            System.out.println( "Reptile initialization FAILED! " );

            e.printStackTrace();
            
        }

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void shutdown() throws Exception {

        Vector v = new Vector();

        v.addElement( "stop" );

        String[] args = new String[ v.size() ];
        v.copyInto( args );

        System.out.println( "Stopping Tomcat..." );
        Bootstrap.main( args );
        
    }
    
}
    
