/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.factories.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.apache.turbine.om.peer.*;

/**
 * Handles providing a URL infrastructure for Reptile.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ReptileServlet.java,v 1.61 2002/07/23 22:17:29 burton Exp $
 */
public class ReptileServlet extends HttpServlet {

    /**
     * Contains all sequences that don't require authentication to view.
     */
    private Hashtable noAuthSequences = new Hashtable();

    private boolean initialized = false;
    
    /**
     * Initialize Talon with a ServletConfig.  Any thing which needs a
     * ServletConfig should be done first and then we should call the
     * ReptileInitializer.
     *
     * @param config The ServletConfig we want to initialize with.
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void init( ServletConfig config ) throws ServletException {

        if ( initialized == false ) {

            System.out.println( "Reptile being initialized..." );

            super.init( config );

            try {

                //Initialize Reptile from the Servlet environment.
                new ServletInitializer( config ).init();
    
            } catch ( Throwable t ) {

                Log.error( t );

            }

            noAuthSequences.put( "urn:weblog-rss", "urn:weblog-rss" );
            noAuthSequences.put( "urn:ocs", "urn:ocs" );
        
            System.out.println( "Reptile being initialized...done" );

            System.setProperty( SystemProperties.REPTILE_SYSTEM_INITIALIZED_KEY, "true" );

            initialized = true;
            
        } 
        
    }
    
    /**
     * Handle HTTP operations...
     *
     * @see HttpServlet#doGet
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void doGet( HttpServletRequest request, HttpServletResponse response )
        throws ServletException, IOException {

        response.setContentType( "text/html" ); //support HTML by default.. 

        boolean auth_disabled = SystemProperties.getBoolean( "reptile.system.auth-disabled" );

        //measure the performance for each HTTP request 
        RuntimeUtil ru = new RuntimeUtil();
        
        HttpSession session = request.getSession();

        //force user to login screen if we have no username... or the session is new 
        if ( session.isNew() ) {

            String session_location = response.encodeURL( ReptileResources.REPTILE_SERVLET_PATH );

            Log.message( "NEW SESSION " + session_location );

            session.setAttribute( "reptile.home.location", session_location );

            if ( auth_disabled == false ) {

                ParameterPasser params = new ParameterPasser( request, response );
                
                String redirect = new LinkProducer( params, session, "urn:login" ).getLink();

                response.sendRedirect( redirect );
            
                return;

            }

        }

        //FIXME: security issue.  Don't allow anyone to execute an action prior
        //to login.
        if ( ActionManager.exec( request, response ) )
            return; //don't continue if we have executed an action and redirected.

        if ( session.getAttribute( "username" ) == null && auth_disabled == false ) {

            SequenceDispatcher.dispatch( request, response, "urn:login" );
            ru.output();
            return;
            
        } 

        String sequence = request.getParameter( "reptile.sequence.name" );

        //display a specific sequence
        if ( sequence != null ) {

            SequenceDispatcher.dispatch( request, response, sequence );
            ru.output();
            return;
            
        } 
        
        PrintWriter out = response.getWriter();

        //else show the user his/her XML

        String defsequence = SystemProperties.getString( SystemProperties.REPTILE_SEQUENCE_DEFAULT_KEY );

        SequenceDispatcher.dispatch( request, response, defsequence );
        ru.output();
                
    }

    /**
     * 
     * @see #doGet
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void doPost( HttpServletRequest request, HttpServletResponse response ) 
        throws ServletException, IOException {

        doGet( request, response );

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void destroy() {

        System.out.println( "ReptileServlet destroyed..." );
        
        System.setProperty( SystemProperties.REPTILE_SYSTEM_RESTARTED_KEY, "true" );

        System.out.println( "Shutting down database..." );

        try { 

            //make sure tasks are shutdown..

            TaskManager.getInstance().destroy();

            System.out.println( "Requesting database shutdown..." );
            BasePeer.executeStatement( "SHUTDOWN COMPACT" );
            System.out.println( "Requesting database shutdown...done" );
            
        } catch ( Throwable t ) {
            
            t.printStackTrace();
            
        }
        
        System.out.println( "Shutting down database...done" );
        
        System.out.println( "ReptileServlet destroyed...done" );

    }
    
}
