/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.apache.regexp.*;

import org.jdom.*;
import org.jdom.output.*;

/*

FIXME:

- only include articles that are present on the current site.

- IE if we are on http://www.cnn.com don't include links to msnbc.

- link to the database and only return URLs that are recent.  IE int the last
  few weeks (this will get smarter over time)

- Support RSS autodiscovery so that I can pull out the latest discrete and then
  uplevel their feed to RSS 1.0 with mod_content
    
*/

/**
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 */
public class RSSChannelSerializer {

    private static final boolean DEBUG = false;

    private RSSContentSerializer rcs = null;

    private String[] links = new String[0];
    
    /**
     * 
     * Create a new <code>RSSChannelSerializer</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public RSSChannelSerializer( String resource ) {

        this.rcs = new RSSContentSerializer();

        this.rcs.setResource( resource );

    }

    /**
     * Parse this channel.  This should be called before any other methods that
     * return any data.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void parse() throws Exception {

        this.rcs.parse();

        //now go through each paragraph finding URLs.

        //now get the content
        String html = this.rcs.getContent();

        //ok... now find links under this channel.

        this.links = getLinks( html );

    }

    /**
     * Get all links for this content.  Links are denoted as all <a href="">
     * links
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String[] getLinks( String html ) throws Exception {

        int index = 0;

        //FIXME: what if href isn't the first attribute.
        RE amatchr = new RE( "<a href=\"([^\"]+)\"" );

        Vector v = new Vector();
        
        while ( amatchr.match( html, index ) ) {

            String link = this.rcs.expand( amatchr.getParen( 1 ) );

            debug( link );
            
            index = amatchr.getParenEnd( 0 );

            v.addElement( link );
            
        } 

        String result[] = new String[v.size()];
        v.copyInto( result );
        
        return result;
        
    }

    /**
     * Get the resource as an RSS stream with mod_content
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getRSS() throws Exception {

        //OK... use JDOM to serialize this to RSS 1.0
        
        Namespace content_ns = Namespace.getNamespace( "content", "http://purl.org/rss/1.0/modules/content/" );
        Namespace rdf_ns = Namespace.getNamespace( "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#" );
        Namespace rss_ns = Namespace.getNamespace( "rss", "http://purl.org/rss/1.0/" );
        
        //FIXME: pull out the site link for the item and use this for the about
        //and link for the channel.

        //root element
        Element rdf = new Element( "RDF", rdf_ns );

        String resource = this.rcs.getResource();
        String title = this.rcs.getTitle();
        String description = this.rcs.getDescription();

        //channel element
        Element channel = new Element( "channel", rss_ns );
        channel.setAttribute( "about", resource, rdf_ns );

        rdf.addContent( channel );

        //add required elements under content
        
        if ( title == null ) {

            channel.addContent( new Element( "title", rss_ns ).setText( "content for: " + resource ) );
            
        } else {

            channel.addContent( new Element( "title", rss_ns ).setText( title ) );             

        }

        channel.addContent( new Element( "link", rss_ns ).setText( resource ) );

        if ( description == null ) {

            channel.addContent( new Element( "description", rss_ns )
                                .setText( "Serialized content for the following URL: " + resource ) );

        } else {
            
            channel.addContent( new Element( "description", rss_ns )
                                .setText( description ) );

        }

        Element itemseq = new Element( "Seq", rdf_ns );
        
        //add the items element
        channel.addContent( new Element( "items" , rss_ns ).addContent( itemseq ) );

        for ( int i = 0; i < this.links.length; ++ i ) {

            String link = this.links[i];

            try {
                
                RSSContentSerializer nrcs = new RSSContentSerializer();
                nrcs.setResource( link );
                nrcs.parse();

                Element iteme = new Element( "item", rss_ns );
                iteme.setAttribute( "about", link, rdf_ns );
                iteme.addContent( new Element( "title", rss_ns ).setText( nrcs.getTitle() ) )
                    .addContent( new Element( "link", rss_ns ).setText( link ) )
                    .addContent( new Element( "description", rss_ns ).setText( nrcs.getDescription() ) )
                    .addContent( new Element( "encoded", content_ns )
                                 .setText( nrcs.getContent() ) );
                
                rdf.addContent( iteme );

                itemseq.addContent( new Element( "li", rdf_ns )
                                    .setAttribute( "resource", link, rdf_ns ) );

            } catch ( Exception e ) {
                //this is acceptable
            }

        } 

        String encoding = "UTF-8";
        
        XMLOutputter outputter = new XMLOutputter( "    ", true, encoding );

        outputter.setEncoding( encoding );
        outputter.setOmitDeclaration( false );
        outputter.setOmitEncoding( false );
        
        return outputter.outputString( rdf );
        
    }

    /**
     * Display syntax.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void syntax() {

        System.out.println( "SYNTAX: " + RSSChannelSerializer.class.getName() + " URL" );

    }

    /**
     * Handle operations from the command line.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void main( String[] args ) {

        if ( args.length != 1 ) {

            syntax();

        } else {

            String resource = args[0];

            //System.out.println( "Working with resource: " + resource );

            RSSChannelSerializer rcs = new RSSChannelSerializer( resource );

            try {

                rcs.parse();
                
                System.out.println( rcs.getRSS() );
                
            } catch ( Exception e ) {

                e.printStackTrace();
                
            }

        }

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void debug( String message ) {

        if ( DEBUG ) {

            System.err.println( message );
            
        } 

    }

}
