/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.apache.regexp.*;

import org.jdom.*;
import org.jdom.output.*;

/**
 * This is a simple servlet that when given the 'resource' param, runs a
 * stylesheet and serializes the output.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: RSS2HTML.java,v 1.2 2002/08/28 05:21:13 burton Exp $
 */
public class RSS2HTML extends HttpServlet {

    /**
     * @param config The ServletConfig we want to initialize with.
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void init( ServletConfig config ) throws ServletException {

        //no init
        
    }
    
    /**
     *
     * @see HttpServlet#doGet
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void doGet( HttpServletRequest request, HttpServletResponse response )
        throws ServletException, IOException {

        response.setContentType( "text/html" );

        String resource = ContentServlet.getResource( request );

        if ( resource == null ) {

            response.sendRedirect( "/reptile/rss2html.html" );
        } 

        System.out.println( "RSS2HTML: " + resource );
        
        //FIXME: assert resource

        StylesheetStack ss = new StylesheetStack();
        ss.addStylesheet( "resource://xsl/rss.xsl" );
        
        SequenceDispatchEntry sde = new SequenceDispatchEntry( "rss" );
        sde.setStylesheetStack( ss );
        sde.setSkeleton( resource );
        sde.setCacheable( false );

        try {
            
            //should be it... just transform
            
            String output = StylesheetEngineFactory.getStylesheetEngine().transform( sde );
            
            response.getWriter().print( output );

        } catch ( Exception e ) {

            e.printStackTrace();
            
            throw new ServletException( e.getMessage() );
            
        }

    }

    /**
     *
     * @see HttpServlet#doGet
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void doPost( HttpServletRequest request, HttpServletResponse response )
        throws ServletException, IOException {

        String resource = ContentServlet.getResource( request );

        if ( resource == null ) {

            response.sendRedirect( "/reptile/rss2html.html" );
        } 

        try {

            RE regexp = new RE( "http://" );

            resource = regexp.subst( resource, "http/" );

            regexp = new RE( "#" );

            resource = regexp.subst( resource, "%23" );

        } catch ( Exception e ) {

            throw new ServletException( e.getMessage() );
            
        }

        response.sendRedirect( "/reptile/servlet/rss2html/" + resource );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void destroy() { }

}
