/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ContentTransformerMap.java,v 1.4 2002/02/27 10:33:04 burton Exp $
 */
public class ContentTransformerMap {
    
    /**
     * Instance member for <code>ContentTransformerMap</code>
     */
    private static ContentTransformerMap instance = null;

    private Vector supportedContentTypes = new Vector();

    /**
     * 
     * Create a new <code>ContentTransformerMap</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformerMap.java,v 1.4 2002/02/27 10:33:04 burton Exp $
     */
    public ContentTransformerMap() {

        //FIXME: get supported content-types from content-tramsformer.xml
        supportedContentTypes.addElement( "http://my.netscape.com/publish/formats/rss-0.91.dtd" );
        supportedContentTypes.addElement( "http://my.netscape.com/rdf/simple/0.9/" );
        supportedContentTypes.addElement( "http://my.netscape.com/publish/formats/rss-0.9.dtd" );
        supportedContentTypes.addElement( "http://purl.org/rss/1.0/" );
        supportedContentTypes.addElement( "http://www.scripting.com/dtd/rss-0.92.dtd" );
        
    }

    /**
     * Return true if this content type is supported.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformerMap.java,v 1.4 2002/02/27 10:33:04 burton Exp $
     */
    public boolean isSupportedContentType( String contentType ) {

        return this.supportedContentTypes.contains( contentType );
        
    }

    /**
     * Return the preferred contentType.  If we have content which provides
     * multiple formats, use this first.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformerMap.java,v 1.4 2002/02/27 10:33:04 burton Exp $
     */
    public boolean isPreferredContentType( String contentType ) {

        //NOTE: we need some way to compare content types to find out which one
        //is preferred over another one. so for example if we are given two
        //namespaces, one for 0.91 and one for 0.90 we should probably prefer
        //the 0.91 version.  Right now though RSS 1.0 is our best candidate so I
        //guess we can go with that.

        return contentType.equals( "http://purl.org/rss/1.0/" );

    }
    
    /**
     * 
     * Get an instance of the <code>ContentTransformerMap</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformerMap.java,v 1.4 2002/02/27 10:33:04 burton Exp $
     */
    public static ContentTransformerMap getInstance() {
        
        if ( instance == null ) {
            
            instance = new ContentTransformerMap();
            
        }
        
        return instance;
        
    }

}
