/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
 */
public class ContentFeed {
    
    private String location = null;
    
    private String contentType = null;
    
    private String description = null;
    
    private String title = null;

    private String source = null;

    /**
     * 
     * Create a new <code>ContentFeed</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public ContentFeed( String location,
                        String contentType,
                        String title,
                        String description,
                        String source ) {

        this.location = location;
        this.contentType = contentType;
        this.title = title;
        this.description = description;
        this.source = source;

    }

    /**
     * 
     * Set the value of <code>title</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public void setTitle( String title ) { 
        
        this.title = title;
        
    }

    /**
     * 
     * Get the value of <code>title</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public String getTitle() { 
        
        return this.title;
        
    }

    /**
     * 
     * Set the value of <code>description</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public void setDescription( String description ) { 
        
        this.description = description;
        
    }

    /**
     * 
     * Get the value of <code>description</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public String getDescription() { 
        
        return this.description;
        
    }

    /**
     * 
     * Set the value of <code>contentType</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public void setContentType( String contentType ) { 
        
        this.contentType = contentType;
        
    }

    /**
     * 
     * Get the value of <code>contentType</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public String getContentType() { 
        
        return this.contentType;
        
    }

    /**
     * 
     * Get the value of <code>location</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public String getLocation() { 
        
        return this.location;
        
    }

    /**
     * 
     * Set the value of <code>location</code>.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeed.java,v 1.5 2001/12/23 08:50:14 burton Exp $
     */
    public void setLocation( String location ) { 

        this.location = location;

    }

    /**
     * 
     * Get the value of <code>source</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getSource() { 
        
        return this.source;
        
    }

    /**
     * 
     * Set the value of <code>source</code>.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void setSource( String source ) { 
        
        this.source = source;
        
    }

}
