/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.apache.regexp.*;

import org.jdom.*;
import org.jdom.output.*;


/**
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ANameChannelServlet.java,v 1.2 2002/09/18 23:57:17 burton Exp $
 */
public class ANameChannelServlet extends HttpServlet {

    /**
     * @param config The ServletConfig we want to initialize with.
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void init( ServletConfig config ) throws ServletException {

        //no init
        
    }
    
    /**
     * Handle HTTP operations...
     *
     * @see HttpServlet#doGet
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void doGet( HttpServletRequest request, HttpServletResponse response )
        throws ServletException, IOException {

        response.setContentType( "application/rss+xml" ); //This is serialization of RSS 1.0

        String resource = ContentServlet.getResource( request );
        
        RSSANameChannelSerializer rcs = new RSSANameChannelSerializer( resource );

        PrintWriter out = response.getWriter();

        try {

            rcs.parse();

            response.setStatus( HttpServletResponse.SC_ACCEPTED );
            String result = rcs.getRSS();
            response.setStatus( HttpServletResponse.SC_OK );

            response.setContentLength( result.length() );
            out.print( result );

        } catch ( Exception e ) {

            e.printStackTrace();
            
            throw new ServletException( e.getMessage() );
            
        }

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void destroy() { }

}
