<?xml version="1.0"?> 

<!--

$Id: mozilla-settings.xsl,v 1.2 2002/02/24 22:45:09 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:settings="http://schemas.openprivacy.org/reptile/settings"
                xmlns:setting-extension="xalan://org.openprivacy.reptile.extensions.om.SettingExtension"
                extension-element-prefixes="setting-extension"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <xsl:template match="/settings:settings">

            <control:content help="user-settings">

                <dc:title><xsl:value-of select="@title"/></dc:title>

                <control:body>

                    <form method="post">
                    
                        <xsl:apply-templates/>

                        <p align="right">
                            <input type="submit" value="Apply Settings"/>
                        </p>

                        <input type="hidden" name="reptile.action" value="ApplySettings"/>
                        
                    </form>
                        
                </control:body>

            </control:content>

    </xsl:template>

    <xsl:template match="/settings:settings/settings:group/settings:description">

        <p>

            <xsl:value-of select="."/>
            
        </p>
        
    </xsl:template>
    
    <xsl:template match="settings:group">

        <fieldset>

            <legend><xsl:value-of select="@name"/></legend>

            <xsl:apply-templates/>
            
        </fieldset>

    </xsl:template>

    <xsl:template match="settings:setting[( @type='string' or @type='integer' ) and @multi = 'true']">

        <p>

            <table width="100%">

                <td width="100%">

                    <b><xsl:value-of select="settings:question"/></b>

                </td>

                <td>
                
                    <select name="{@property}">

                        <xsl:apply-templates/>
                        
                    </select>

                </td>

            </table>
            
        </p>
            
    </xsl:template>

    <xsl:template match="settings:setting[@type = 'string' and @multi = 'false']">

        <table width="100%">

            <td width="100%">

                <b><xsl:value-of select="settings:question"/></b>
                
            </td>
                
            <td>

                <input type="text" name="{@property}" value="{setting-extension:value( @property )}"/>

            </td>

        </table>
            
    </xsl:template>

    <xsl:template match="settings:setting[@type = 'text']">

        <p>
            <b><xsl:value-of select="settings:question"/></b>

        </p>

        <p>
            <textarea name="{@property}" cols="50" rows="5">

                <setting-extension:value name="{@property}"/>
                
            </textarea>
        </p>
            
    </xsl:template>

    <!-- match options on multi elements -->
      
    <xsl:template match="settings:option">

        <option value="{@value}">

            <xsl:if test="@value = setting-extension:value( ../@property )">

                <xsl:attribute name="selected">selected</xsl:attribute>
                                                    
            </xsl:if>

            <xsl:value-of select="."/>

        </option>

    </xsl:template>
    
</xsl:stylesheet>

