/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.crypto.DHPublicKey;
import COM.claymoresystems.ptls.LoadProviders;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLDHParams;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLRSAParams;
import COM.claymoresystems.ptls.SSLopaque;
import cryptix.provider.rsa.RawRSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

class SSLServerKeyExchange
extends SSLPDU {
    SSLDHParams dh_params;
    SSLRSAParams rsa_params;
    SSLopaque signature = new SSLopaque(-65535);
    SSLPDU par;
    int wb = 0;
    String algorithm;

    SSLServerKeyExchange() {
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (sSLConn.hs.cipher_suite.getKeyExchangeAlg()) {
            case 1: {
                sSLConn.hs.dhEphemeral = sSLConn.ctx.getEphemeralDHPrivateKey(sSLConn.policy.dhAlwaysEphemeralP());
                this.dh_params = new SSLDHParams(sSLConn.hs.dhEphemeral);
                this.par = this.dh_params;
                break;
            }
            case 2: {
                sSLConn.hs.rsaEphemeral = sSLConn.ctx.getEphemeralRSAPrivateKey();
                this.rsa_params = new SSLRSAParams(sSLConn.ctx.getEphemeralRSAPublicKey());
                this.par = this.rsa_params;
                break;
            }
            default: {
                throw new Error("Unknown key exchange algorithm");
            }
        }
        this.par.encode(sSLConn, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            Signature signature;
            PrivateKey privateKey = sSLConn.ctx.getPrivateKey();
            String string = sSLConn.hs.cipher_suite.getSignatureAlgCV();
            if (string.equals("RawDSA")) {
                signature = Signature.getInstance(string, LoadProviders.getDSAProvider());
                signature.setParameter("SecureRandom", sSLConn.hs.rng);
            } else if (string.equals("RawRSA")) {
                signature = Signature.getInstance(string);
            } else {
                throw new Exception("Unknown key type");
            }
            signature.initSign(privateKey);
            byte[] byArray2 = this.getToBeSigned(sSLConn, string, byArray);
            signature.update(byArray2);
            byte[] byArray3 = signature.sign();
            SSLDebug.debug(8, "Signed Data", byArray);
            SSLDebug.debug(8, "Signature Data", byArray3);
            this.signature.value = byArray3;
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        this.wb = this.par.encode(sSLConn, outputStream);
        this.wb += this.signature.encode(sSLConn, outputStream);
        return this.wb;
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws Error, IOException {
        int n;
        DHPublicKey dHPublicKey = null;
        PublicKey publicKey = sSLConn.hs.peerSignatureKey;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (sSLConn.hs.cipher_suite.getKeyExchangeAlg()) {
            case 1: {
                this.dh_params = new SSLDHParams();
                n = this.dh_params.decode(sSLConn, inputStream);
                this.dh_params.encode(sSLConn, byteArrayOutputStream);
                dHPublicKey = new DHPublicKey(new BigInteger(1, this.dh_params.DH_g.value), new BigInteger(1, this.dh_params.DH_p.value), new BigInteger(1, this.dh_params.DH_Ys.value));
                break;
            }
            case 2: {
                this.rsa_params = new SSLRSAParams();
                n = this.rsa_params.decode(sSLConn, inputStream);
                this.rsa_params.encode(sSLConn, byteArrayOutputStream);
                BigInteger bigInteger = new BigInteger(1, this.rsa_params.RSA_modulus.value);
                BigInteger bigInteger2 = new BigInteger(1, this.rsa_params.RSA_exponent.value);
                if (bigInteger.bitLength() > 512) {
                    sSLConn.alert(SSLAlertX.TLS_ALERT_ILLEGAL_PARAMETER);
                }
                dHPublicKey = new RawRSAPublicKey(bigInteger, bigInteger2);
                break;
            }
            default: {
                throw new Error("Unknown key exchange algorithm");
            }
        }
        n += this.signature.decode(sSLConn, inputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            String string = sSLConn.hs.cipher_suite.getSignatureAlgCV();
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            byte[] byArray2 = this.getToBeSigned(sSLConn, string, byArray);
            signature.update(byArray2);
            SSLDebug.debug(8, "Signed Data", byArray);
            SSLDebug.debug(8, "Signature Data", this.signature.value);
            if (!signature.verify(this.signature.value)) {
                sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
        }
        catch (SignatureException signatureException) {
            sSLConn.alert(SSLAlertX.TLS_ALERT_DECRYPT_ERROR);
        }
        sSLConn.hs.peerEncryptionKey = dHPublicKey;
        return n;
    }

    private byte[] getToBeSigned(SSLConn sSLConn, String string, byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(sSLConn.hs.client_random);
        messageDigest.update(sSLConn.hs.server_random);
        messageDigest.update(byArray);
        if (string.equals("RawRSA")) {
            MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
            messageDigest2.update(sSLConn.hs.client_random);
            messageDigest2.update(sSLConn.hs.server_random);
            messageDigest2.update(byArray);
            byte[] byArray3 = messageDigest2.digest();
            byte[] byArray4 = messageDigest.digest();
            byArray2 = new byte[36];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, 16, byArray4.length);
        } else {
            byArray2 = messageDigest.digest();
        }
        return byArray2;
    }
}

