/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.CertificateDecodeException;
import COM.claymoresystems.cert.CertificateException;
import COM.claymoresystems.cert.CertificateVerifyException;
import COM.claymoresystems.cert.X509Ext;
import COM.claymoresystems.cert.X509Name;
import COM.claymoresystems.cert.X509SubjectPublicKeyInfo;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.sslg.Certificate;
import COM.claymoresystems.sslg.DistinguishedName;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParserVisitor;
import cryptix.util.core.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class X509Cert
implements Certificate {
    ASNObject signedCert;
    ASNObject unsignedCert;
    ASNObject issuer;
    ASNObject subject;
    ASNObject sigAlg;
    ASNObject sig;
    byte[] DER;
    byte[] unsignedCertDER;
    byte[] subjectDER;
    byte[] issuerDER;
    byte[] signature;
    String signatureAlgorithm;
    PublicKey pubKey;
    X509Name subjectName;
    X509Name issuerName;
    BigInteger serialNumber;
    Date notBefore;
    Date notAfter;
    Vector extensions = null;
    private static Hashtable oid2NameMap = new Hashtable();

    public X509Cert(byte[] byArray) throws CertificateException {
        this.DER = byArray;
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            ASNObject aSNObject = CertContext.getSpec().getComponent("UsefulCertificate");
            CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init((InputStream)byteArrayInputStream);
            try {
                aSNObject.accept((ParserVisitor)coderOperations, null);
                this.signedCert = aSNObject;
                ASNObject aSNObject2 = aSNObject.getComponent("UsefulCertificate.tbsCertificate");
                this.unsignedCertDER = (byte[])aSNObject2.getValue();
                this.sigAlg = aSNObject.getComponent("UsefulCertificate.signatureAlgorithm");
                Vector vector = (Vector)this.sigAlg.getValue();
                Vector vector2 = (Vector)vector.elementAt(0);
                this.signatureAlgorithm = (String)vector2.elementAt(0);
                SSLDebug.debug(32, "Signed by " + this.signatureAlgorithm);
                this.sig = aSNObject.getComponent("UsefulCertificate.signature");
                byte[] byArray2 = (byte[])this.sig.getValue();
                if (byArray2[0] != 0) {
                    throw new IOException();
                }
                this.signature = new byte[byArray2.length - 1];
                System.arraycopy(byArray2, 1, this.signature, 0, this.signature.length);
                SSLDebug.debug(32, "Signature ", this.signature);
                this.unsignedCert = CertContext.getSpec().getComponent("UsefulTBSCertificate");
                SSLDebug.debug(32, "Unsigned cert DER", this.unsignedCertDER);
                byteArrayInputStream = new ByteArrayInputStream(this.unsignedCertDER);
                coderOperations.init((InputStream)byteArrayInputStream);
                this.unsignedCert.accept((ParserVisitor)coderOperations, null);
                this.issuer = this.unsignedCert.getComponent("UsefulTBSCertificate.issuer");
                this.issuerDER = (byte[])this.issuer.getValue();
                this.issuerName = new X509Name(this.issuerDER);
                SSLDebug.debug(32, "Issuer DER", this.issuerDER);
                this.subject = this.unsignedCert.getComponent("UsefulTBSCertificate.subject");
                this.subjectDER = (byte[])this.subject.getValue();
                this.subjectName = new X509Name(this.subjectDER);
                SSLDebug.debug(32, "Subject DER", this.subjectDER);
                ASNObject aSNObject3 = this.unsignedCert.getComponent("UsefulTBSCertificate.subjectPublicKeyInfo");
                byte[] byArray3 = (byte[])aSNObject3.getValue();
                this.pubKey = X509SubjectPublicKeyInfo.createPublicKey(byArray3);
                aSNObject2 = this.unsignedCert.getComponent("UsefulTBSCertificate.serialNumber");
                this.serialNumber = (BigInteger)aSNObject2.getValue();
                ASNObject aSNObject4 = this.unsignedCert.getComponent("UsefulTBSCertificate.validity");
                aSNObject2 = aSNObject4.getComponent("Validity.notBefore");
                this.notBefore = (Date)aSNObject2.getValue();
                aSNObject2 = aSNObject4.getComponent("Validity.notAfter");
                this.notAfter = (Date)aSNObject2.getValue();
                ASNObject aSNObject5 = this.unsignedCert.getComponent("UsefulTBSCertificate.extensions");
                vector = (Vector)aSNObject5.getValue();
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        if (n == 0) {
                            this.extensions = new Vector();
                        }
                        vector2 = (Vector)vector.elementAt(n);
                        byte[] byArray4 = (byte[])vector2.elementAt(0);
                        this.extensions.addElement(new X509Ext(byArray4));
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                throw new CertificateDecodeException(iOException.toString());
            }
        }
    }

    public String getSignatureAlgorithm() {
        return (String)oid2NameMap.get(this.signatureAlgorithm);
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public byte[] getDER() {
        return this.DER;
    }

    public byte[] getIssuerDER() {
        return this.issuerDER;
    }

    public byte[] getSubjectDER() {
        return this.subjectDER;
    }

    public DistinguishedName getSubjectName() {
        return this.subjectName;
    }

    public DistinguishedName getIssuerName() {
        return this.issuerName;
    }

    public Date getValidityNotBefore() {
        return this.notBefore;
    }

    public Date getValidityNotAfter() {
        return this.notAfter;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public BigInteger getSerial() {
        return this.serialNumber;
    }

    void checkSignatureKey(PublicKey publicKey, String string) throws CertificateVerifyException {
        if (string.equals("MD2/RSA") || string.equals("MD4/RSA") || string.equals("MD5/RSA") || string.equals("SHA-1/RSA/PKCS#1")) {
            if (!(publicKey instanceof CryptixRSAPublicKey)) {
                throw new CertificateVerifyException("Public key doesn't match algorithm " + string);
            }
        } else if (string.equals("DSA")) {
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertificateVerifyException("Public key doesn't match algorithm " + string);
            }
        } else {
            throw new CertificateVerifyException("Unknown algorithm " + string);
        }
    }

    public boolean verify(PublicKey publicKey) throws CertificateException {
        try {
            String string = (String)oid2NameMap.get(this.signatureAlgorithm);
            if (string != null) {
                SSLDebug.debug(32, "OID " + this.signatureAlgorithm + "mapped to " + string);
            }
            this.checkSignatureKey(publicKey, string);
            Signature signature = Signature.getInstance(string != null ? string : this.signatureAlgorithm);
            signature.initVerify(publicKey);
            signature.update(this.unsignedCertDER);
            return signature.verify(this.signature);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (SSLDebug.getDebug(32)) {
                noSuchAlgorithmException.printStackTrace();
            }
            throw new CertificateVerifyException(noSuchAlgorithmException.toString());
        }
        catch (SignatureException signatureException) {
            if (SSLDebug.getDebug(32)) {
                signatureException.printStackTrace();
            }
            throw new CertificateVerifyException(signatureException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            if (SSLDebug.getDebug(32)) {
                invalidKeyException.printStackTrace();
            }
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Vector verifyCertChain(CertContext var0, Vector var1_1, boolean var2_2) throws CertificateException {
        var4_3 = var1_1.size();
        var5_4 = new Vector<X509Cert>();
        var7_5 = null;
        var8_6 = false;
        var3_7 = 0;
        while (var3_7 < var4_3) {
            var6_8 = (X509Cert)var1_1.elementAt(var3_7);
            SSLDebug.debug(32, "Trying to verify", var6_8.getDER());
            if (var8_6) ** GOTO lbl24
            if (var0.isRoot(var6_8.getDER())) {
                SSLDebug.debug(32, "Is root");
                var7_5 = var6_8;
                var5_4.addElement(var7_5);
                var8_6 = true;
            } else {
                SSLDebug.debug(32, "Trying to find root with DN", var6_8.getIssuerDER());
                var7_5 = var0.signedByRoot(var6_8.getIssuerDER());
                if (var7_5 == null) {
                    SSLDebug.debug(32, "Nope");
                } else {
                    SSLDebug.debug(32, "Found one");
                    var5_4.addElement(var7_5);
                    var8_6 = true;
lbl24:
                    // 2 sources

                    if (!var6_8.verify(var7_5.getPublicKey())) {
                        throw new CertificateVerifyException("Certificate signature doesn't match");
                    }
                    if (!ArrayUtil.areEqual((byte[])var7_5.getSubjectDER(), (byte[])var6_8.getIssuerDER())) {
                        throw new CertificateVerifyException("Subject and issuer name don't match");
                    }
                    if (var2_2) {
                        X509Cert.checkExpiry(var6_8, new Date());
                    }
                    var7_5 = var6_8;
                    var5_4.addElement(var6_8);
                }
            }
            ++var3_7;
        }
        if (var7_5 != null) {
            return var5_4;
        }
        return null;
    }

    static void checkExpiry(Certificate certificate, Date date) throws CertificateVerifyException {
        Date date2 = certificate.getValidityNotBefore();
        Date date3 = certificate.getValidityNotAfter();
        if (date.before(date2)) {
            throw new CertificateVerifyException("Certificate not yet valid. Not before date " + date2);
        }
        if (date.after(date3)) {
            throw new CertificateVerifyException("Certificate expired. Not after date " + date3);
        }
    }

    static {
        oid2NameMap.put("1.2.840.10040.4.3", "DSA");
        oid2NameMap.put("1.2.840.113549.1.1.2", "MD2/RSA");
        oid2NameMap.put("1.2.840.113549.1.1.3", "MD4/RSA");
        oid2NameMap.put("1.2.840.113549.1.1.4", "MD5/RSA");
        oid2NameMap.put("1.2.840.113549.1.1.5", "SHA-1/RSA/PKCS#1");
    }
}

