/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.X509NameTokenizer;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
    public static Hashtable OIDLookUp = new Hashtable();
    public static Hashtable SymbolLookUp = new Hashtable();
    private Vector ordering = new Vector();
    private Hashtable attributes = new Hashtable();
    private DERConstructedSequence seq = null;

    public X509Name(DERConstructedSequence dERConstructedSequence) {
        this.seq = dERConstructedSequence;
        Enumeration enumeration = dERConstructedSequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERSet dERSet = (DERSet)enumeration.nextElement();
            DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)dERSet.getSequence();
            this.ordering.addElement(dERConstructedSequence2.getObjectAt(0));
            this.attributes.put(dERConstructedSequence2.getObjectAt(0), ((DERString)dERConstructedSequence2.getObjectAt(1)).getString());
        }
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        if (vector != null) {
            int n = 0;
            while (n != vector.size()) {
                this.ordering.addElement(vector.elementAt(n));
                ++n;
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.ordering.addElement(enumeration.nextElement());
            }
        }
        int n = 0;
        while (n != this.ordering.size()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
            if (OIDLookUp.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("Unknown object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            if (hashtable.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.attributes.put(dERObjectIdentifier, hashtable.get(dERObjectIdentifier));
            ++n;
        }
    }

    public X509Name(String string) {
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            String string2 = x509NameTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)SymbolLookUp.get(string3);
            if (dERObjectIdentifier == null) {
                throw new IllegalArgumentException("Unknown object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.ordering.addElement(dERObjectIdentifier);
            this.attributes.put(dERObjectIdentifier, string4);
        }
    }

    public DERObject getDERObject() {
        if (this.seq == null) {
            this.seq = new DERConstructedSequence();
            int n = 0;
            while (n != this.ordering.size()) {
                DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
                dERConstructedSequence.addObject(dERObjectIdentifier);
                if (dERObjectIdentifier.equals(EmailAddress)) {
                    dERConstructedSequence.addObject(new DERIA5String((String)this.attributes.get(dERObjectIdentifier)));
                } else {
                    dERConstructedSequence.addObject(new DERPrintableString((String)this.attributes.get(dERObjectIdentifier)));
                }
                this.seq.addObject(new DERSet(dERConstructedSequence));
                ++n;
            }
        }
        return this.seq;
    }

    public int hashCode() {
        Enumeration enumeration = this.attributes.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            n ^= k.hashCode();
            n ^= this.attributes.get(k).hashCode();
        }
        int n2 = 0;
        while (n2 != this.ordering.size()) {
            n ^= this.ordering.elementAt(n2).hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        if (this.ordering.size() != x509Name.ordering.size()) {
            return false;
        }
        int n = 0;
        while (n != this.ordering.size()) {
            if (!this.ordering.elementAt(n).equals(x509Name.ordering.elementAt(n))) {
                return false;
            }
            ++n;
        }
        Enumeration enumeration = this.attributes.keys();
        Enumeration enumeration2 = x509Name.attributes.keys();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Object k;
            Object k2 = enumeration.nextElement();
            if (k2.equals(k = enumeration2.nextElement())) continue;
            return false;
        }
        return !enumeration.hasMoreElements() && !enumeration2.hasMoreElements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n != this.ordering.size()) {
            Object e = this.ordering.elementAt(n);
            String string = (String)OIDLookUp.get(e);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append((String)this.attributes.get(e));
            } else {
                stringBuffer.append(((DERObjectIdentifier)e).getId());
                stringBuffer.append("=");
                stringBuffer.append((String)this.attributes.get(e));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        OIDLookUp.put(C, "C");
        OIDLookUp.put(O, "O");
        OIDLookUp.put(OU, "OU");
        OIDLookUp.put(CN, "CN");
        OIDLookUp.put(L, "L");
        OIDLookUp.put(ST, "ST");
        OIDLookUp.put(SN, "SN");
        OIDLookUp.put(EmailAddress, "EmailAddress");
        SymbolLookUp.put("C", C);
        SymbolLookUp.put("O", O);
        SymbolLookUp.put("OU", OU);
        SymbolLookUp.put("CN", CN);
        SymbolLookUp.put("L", L);
        SymbolLookUp.put("ST", ST);
        SymbolLookUp.put("SN", SN);
        SymbolLookUp.put("EmailAddress", EmailAddress);
    }
}

