/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class X509CertificateStructure
implements DEREncodable,
X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    DERConstructedSequence seq;
    TBSCertificateStructure tbsCert;
    AlgorithmIdentifier sigAlgId;
    DERBitString sig;

    public X509CertificateStructure(DERConstructedSequence dERConstructedSequence) {
        this.seq = dERConstructedSequence;
        if (dERConstructedSequence.getSize() == 3) {
            this.tbsCert = dERConstructedSequence.getObjectAt(0) instanceof TBSCertificateStructure ? (TBSCertificateStructure)dERConstructedSequence.getObjectAt(0) : new TBSCertificateStructure((DERConstructedSequence)dERConstructedSequence.getObjectAt(0));
            this.sigAlgId = dERConstructedSequence.getObjectAt(1) instanceof AlgorithmIdentifier ? (AlgorithmIdentifier)dERConstructedSequence.getObjectAt(1) : new AlgorithmIdentifier((DERConstructedSequence)dERConstructedSequence.getObjectAt(1));
            this.sig = (DERBitString)dERConstructedSequence.getObjectAt(2);
        }
    }

    public TBSCertificateStructure getTBSCertificate() {
        return this.tbsCert;
    }

    public int getVersion() {
        return this.tbsCert.getVersion();
    }

    public DERInteger getSerialNumber() {
        return this.tbsCert.getSerialNumber();
    }

    public X509Name getIssuer() {
        return this.tbsCert.getIssuer();
    }

    public DERUTCTime getStartDate() {
        return this.tbsCert.getStartDate();
    }

    public DERUTCTime getEndDate() {
        return this.tbsCert.getEndDate();
    }

    public X509Name getSubject() {
        return this.tbsCert.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.tbsCert.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sig;
    }

    public DERObject getDERObject() {
        return this.seq;
    }
}

