/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class Pfx
implements DEREncodable,
PKCSObjectIdentifiers {
    private ContentInfo contentInfo;
    private MacData macData = null;

    public Pfx(DERConstructedSequence dERConstructedSequence) {
        BigInteger bigInteger = ((DERInteger)dERConstructedSequence.getObjectAt(0)).getValue();
        if (bigInteger.intValue() != 3) {
            throw new IllegalArgumentException("wrong version for PFX PDU");
        }
        this.contentInfo = new ContentInfo((DERConstructedSequence)dERConstructedSequence.getObjectAt(1));
        if (dERConstructedSequence.getSize() == 3) {
            this.macData = new MacData((DERConstructedSequence)dERConstructedSequence.getObjectAt(2));
        }
    }

    public Pfx(ContentInfo contentInfo, MacData macData) {
        this.contentInfo = contentInfo;
        this.macData = macData;
    }

    public ContentInfo getAuthSafe() {
        return this.contentInfo;
    }

    public MacData getMacData() {
        return this.macData;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(new DERInteger(3));
        bERConstructedSequence.addObject(this.contentInfo);
        if (this.macData != null) {
            bERConstructedSequence.addObject(this.macData);
        }
        return bERConstructedSequence;
    }
}

