/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.cipher;

import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;

public final class SecretKey
implements Key {
    private boolean initDone = false;
    private byte keyType;
    private short size;
    private byte[] secret;

    public SecretKey(byte by, short s) {
        this.keyType = by;
        this.size = s;
        this.secret = null;
    }

    public boolean isInitialized() {
        return this.initDone;
    }

    public void clearKey() {
        this.initDone = false;
        this.size = 0;
    }

    public short getSize() {
        return this.size;
    }

    public int getLength() {
        return this.size + 7 >>> 3;
    }

    public byte getType() {
        return this.keyType;
    }

    public byte getKey(byte[] byArray, int n) {
        if (this.keyType != 8) {
            return 0;
        }
        if (byArray.length < this.secret.length + n) {
            return 0;
        }
        System.arraycopy(this.secret, 0, byArray, n, this.secret.length);
        return (byte)this.secret.length;
    }

    public void setKey(byte[] byArray, int n) throws CryptoException {
        if (this.keyType != 8) {
            throw new CryptoException(4);
        }
        int n2 = this.size + 7 >>> 3;
        if (n2 + n > byArray.length) {
            throw new CryptoException(2);
        }
        this.secret = new byte[n2];
        System.arraycopy(byArray, n, this.secret, 0, n2);
    }
}

