/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.impl.xml.BinaryXmlGenerator;
import net.jxta.impl.xml.BinaryXmlParser;
import net.jxta.impl.xml.XmlParser;

public class BinaryXmlTest {
    public static void main(String[] argv) throws IOException, XmlParser.Exception {
        BinaryXmlGenerator generator = new BinaryXmlGenerator();
        BinaryXmlParser parser = new BinaryXmlParser();
        InputStream textIn = System.in;
        ByteArrayOutputStream binOut = new ByteArrayOutputStream(32768);
        byte[] buf = new byte[1024];
        BinaryXmlGenerator.AtomTable outAtomTable = new BinaryXmlGenerator.AtomTable(512, 16384);
        BinaryXmlParser.AtomTable inAtomTable = new BinaryXmlParser.AtomTable(512, 16384);
        generator.generate(textIn, binOut, outAtomTable, buf);
        ByteArrayInputStream binIn = new ByteArrayInputStream(binOut.toByteArray());
        parser.parse(binIn, buf, new XmlParser.ParserCallback(){
            boolean hadChars;

            public void startTag(byte[] chars, int start, int len) throws XmlParser.Exception {
                System.out.println("<" + new String(chars, start, len));
                this.hadChars = false;
            }

            public void attribute(byte[] nameChars, int nameStart, int nameLen, byte[] valueChars, int valueStart, int valueLen) throws XmlParser.Exception {
                String name = new String(nameChars, nameStart, nameLen);
                String value = new String(valueChars, valueStart, valueLen);
                System.out.println(" " + name + "='" + value + "'");
            }

            public void chars(byte[] chars, int start, int len) throws XmlParser.Exception {
                this.hadChars = true;
                System.out.println(">" + new String(chars, start, len));
            }

            public void endTag(byte[] chars, int start, int len) throws XmlParser.Exception {
                if (!this.hadChars) {
                    System.out.println(">");
                }
                System.out.println("</" + new String(chars, start, len) + ">");
            }
        }, inAtomTable);
    }
}

