/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointService;
import net.jxta.impl.endpoint.servlethttp.MessageReceiver;
import net.jxta.impl.relay.RelayLease;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public abstract class AbstractRelayClient
implements MessageReceiver {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$AbstractRelayClient == null ? (class$net$jxta$impl$relay$AbstractRelayClient = AbstractRelayClient.class$("net.jxta.impl.relay.AbstractRelayClient")) : class$net$jxta$impl$relay$AbstractRelayClient).getName());
    protected static Timer timer = new Timer(true);
    private static final int LEASE_RETRY_INTERVAL = 300000;
    private static final int LEASE_RENEWAL_DIV = 5;
    protected RelayLease lease = null;
    private TimerTask leaseRenewalTask = null;
    private boolean noLease = true;
    static /* synthetic */ Class class$net$jxta$impl$relay$AbstractRelayClient;

    public abstract boolean obtainLease();

    public abstract boolean renewLease();

    protected void recordLease(String relayPeerId, String leaseId, int leaseLength) {
        this.lease = new RelayLease(relayPeerId, leaseId, leaseLength);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Recorded lease; relayPeerId, leaseId, leaseLength==" + relayPeerId + "," + leaseId + "," + leaseLength));
        }
        this.leaseMode(leaseLength);
        this.onLeaseObtained();
    }

    public boolean isLeaseValid() {
        RelayLease tmp = this.lease;
        if (tmp == null) {
            return false;
        }
        return tmp.isValid();
    }

    protected String getLeaseId() {
        RelayLease tmp = this.lease;
        if (tmp == null || !tmp.isValid()) {
            return null;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("returning lease id = " + this.lease.getLeaseId()));
        }
        return tmp.getLeaseId();
    }

    protected void nullifyLease() {
        this.lease = null;
    }

    protected abstract void onLeaseObtained();

    public void start() throws IOException {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"start");
        }
        this.noLease = false;
        this.lostLease();
    }

    public void lostLease() {
        if (this.noLease) {
            return;
        }
        this.noLeaseMode(true);
    }

    protected synchronized void noLeaseMode(boolean startNow) {
        if (this.noLease) {
            return;
        }
        if (this.leaseRenewalTask != null) {
            this.leaseRenewalTask.cancel();
        }
        this.leaseRenewalTask = new LeaseRenewalTask();
        this.nullifyLease();
        this.noLease = true;
        timer.schedule(this.leaseRenewalTask, startNow ? 0L : 300000L, 300000L);
    }

    protected synchronized void leaseMode(int leaseLength) {
        this.noLease = false;
        if (this.leaseRenewalTask != null) {
            this.leaseRenewalTask.cancel();
        }
        this.leaseRenewalTask = new LeaseRenewalTask();
        timer.schedule(this.leaseRenewalTask, leaseLength * 4 / 5, (long)(leaseLength / 5 / 2));
    }

    public void stop() throws InterruptedException {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"stop");
        }
        timer.cancel();
        this.nullifyLease();
    }

    public abstract void init(PeerGroup var1, EndpointService var2, TransportAdvertisement var3) throws IOException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LeaseRenewalTask
    extends TimerTask {
        LeaseRenewalTask() {
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("LeaseRenewalTask: trying to renew lease: " + AbstractRelayClient.this.getLeaseId()));
            }
            if (AbstractRelayClient.this.isLeaseValid()) {
                AbstractRelayClient.this.renewLease();
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  Lease is not valid; obtaining new lease");
                }
                AbstractRelayClient.this.noLeaseMode(false);
                AbstractRelayClient.this.obtainLease();
            }
        }
    }
}

