/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.proxy;

import java.io.IOException;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Category;

public class Requestor {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$proxy$Requestor == null ? (class$net$jxta$impl$proxy$Requestor = Requestor.class$("net.jxta.impl.proxy.Requestor")) : class$net$jxta$impl$proxy$Requestor).getName());
    private PeerGroup group;
    private EndpointAddress address;
    private MessageElement requestId;
    private EndpointMessenger messenger;
    static /* synthetic */ Class class$net$jxta$impl$proxy$Requestor;

    public boolean send(Message message) {
        LOG.debug((Object)("send to " + this.address.toString()));
        try {
            this.messenger.sendMessage(message);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not send message to requestor " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean send(Advertisement adv, String resultType) {
        LOG.debug((Object)("send " + adv));
        Message message = this.group.getEndpointService().newMessage();
        if (resultType == null) {
            resultType = "";
        }
        message.setString("proxy:response", resultType);
        if (this.requestId != null) {
            message.addElement(this.requestId);
        }
        if (adv instanceof PeerAdvertisement) {
            PeerAdvertisement peerAdv = (PeerAdvertisement)adv;
            message.setString("proxy:type", "PEER");
            message.setString("proxy:name", peerAdv.getName());
            message.setString("proxy:id", peerAdv.getPeerID().toString());
            LOG.debug((Object)("send PeerAdvertisement name=" + peerAdv.getName() + " id=" + peerAdv.getPeerID().toString()));
        } else if (adv instanceof PeerGroupAdvertisement) {
            PeerGroupAdvertisement groupAdv = (PeerGroupAdvertisement)adv;
            message.setString("proxy:type", "GROUP");
            message.setString("proxy:name", groupAdv.getName());
            message.setString("proxy:id", groupAdv.getPeerGroupID().toString());
            LOG.debug((Object)("send GroupAdvertisement name=" + groupAdv.getName() + " id=" + groupAdv.getPeerGroupID().toString()));
        } else if (adv instanceof PipeAdvertisement) {
            PipeAdvertisement pipeAdv = (PipeAdvertisement)adv;
            message.setString("proxy:type", "PIPE");
            message.setString("proxy:name", pipeAdv.getName());
            message.setString("proxy:id", pipeAdv.getPipeID().toString());
            message.setString("proxy:arg", pipeAdv.getType());
            LOG.debug((Object)("send PipeAdvertisement name=" + pipeAdv.getName() + " id=" + pipeAdv.getPipeID().toString() + " arg=" + pipeAdv.getType()));
        } else {
            return false;
        }
        return this.send(message);
    }

    public boolean notifySuccess() {
        LOG.debug((Object)"notifySuccess");
        Message message = this.group.getEndpointService().newMessage();
        message.setString("proxy:response", "success");
        if (this.requestId != null) {
            message.addElement(this.requestId);
        }
        return this.send(message);
    }

    public boolean notifyError(String errorString) {
        LOG.debug((Object)("notifyError " + errorString));
        Message message = this.group.getEndpointService().newMessage();
        if (this.requestId != null) {
            message.addElement(this.requestId);
        }
        if (errorString != null && errorString.length() > 0) {
            message.setString("proxy:error", errorString);
        }
        return this.send(message);
    }

    public boolean equals(Object obj) {
        LOG.debug((Object)(this + " equals " + obj));
        if (obj instanceof Requestor) {
            Requestor dest = (Requestor)obj;
            if (this.address != null && dest.address != null && dest.address.toString().equals(this.address.toString())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Requestor " + this.address.toString();
    }

    private Requestor(PeerGroup group, EndpointAddress address, MessageElement requestId) throws IOException {
        this.group = group;
        this.address = address;
        this.requestId = requestId;
        this.messenger = group.getEndpointService().getMessenger(address);
    }

    public static Requestor createRequestor(PeerGroup group, Message message) throws IOException {
        Requestor requestor = null;
        EndpointAddress address = message.getSourceAddress();
        LOG.debug((Object)("create new Requestor - " + address.toString()));
        if (address != null) {
            requestor = new Requestor(group, address, message.getElement("proxy:requestId"));
            message.removeElement("proxy:requestId");
        }
        return requestor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

