/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;

public class ModuleImplAdv
extends ModuleImplAdvertisement {
    private static final String msidTag = "MSID";
    private static final String compTag = "Comp";
    private static final String codeTag = "Code";
    private static final String uriTag = "PURI";
    private static final String provTag = "Prov";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ModuleImplAdv() {
    }

    public ModuleImplAdv(Element root) {
        this.initialize(root);
    }

    void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = ModuleImplAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(ModuleImplAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.setModuleSpecID(null);
        this.setCompat(null);
        this.setCode(null);
        this.setUri(null);
        this.setProvider(null);
        this.setDescription(null);
        this.setParam(null);
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            String nm = elem.getName();
            if (nm.equals(msidTag)) {
                try {
                    URL spID = new URL(elem.getTextValue());
                    this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL(spID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (nm.equals(compTag)) {
                this.setCompat(elem);
                continue;
            }
            if (nm.equals(codeTag)) {
                this.setCode(elem.getTextValue());
                continue;
            }
            if (nm.equals(uriTag)) {
                this.setUri(elem.getTextValue());
                continue;
            }
            if (nm.equals(provTag)) {
                this.setProvider(elem.getTextValue());
                continue;
            }
            if (nm.equals(descTag)) {
                this.setDescription(elem.getTextValue());
                continue;
            }
            if (!nm.equals(paramTag)) continue;
            this.setParam(elem);
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument adv = null;
        try {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, ModuleImplAdvertisement.getAdvertisementType());
        }
        catch (Throwable everything) {
            return null;
        }
        TextElement e = adv.createElement(msidTag, this.getModuleSpecID().toString());
        adv.appendChild((Element)e);
        if (this.getCompat() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCompat());
        }
        if (this.getCode() != null) {
            e = adv.createElement(codeTag, this.getCode());
            adv.appendChild((Element)e);
        }
        if (this.getUri() != null) {
            e = adv.createElement(uriTag, this.getUri());
            adv.appendChild((Element)e);
        }
        if (this.getProvider() != null) {
            e = adv.createElement(provTag, this.getProvider());
            adv.appendChild((Element)e);
        }
        if (this.getDescription() != null) {
            e = adv.createElement(descTag, this.getDescription());
            adv.appendChild((Element)e);
        }
        if (this.getParam() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getParam());
        }
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleImplAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleImplAdv();
        }

        public Advertisement newInstance(Element root) {
            return new ModuleImplAdv(root);
        }
    }
}

