/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.pipe.InputPipeImpl;
import net.jxta.impl.pipe.NonBlockingOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.pipe.PipeServiceInterface;
import net.jxta.impl.pipe.SecureInputPipeImpl;
import net.jxta.impl.pipe.SecureOutputPipe;
import net.jxta.impl.pipe.WirePipe;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PipeServiceImpl
implements PipeService {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$PipeServiceImpl == null ? (class$net$jxta$impl$pipe$PipeServiceImpl = PipeServiceImpl.class$("net.jxta.impl.pipe.PipeServiceImpl")) : class$net$jxta$impl$pipe$PipeServiceImpl).getName());
    private static Hashtable queueTable = null;
    private PeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private PipeResolver pipeResolver = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private Hashtable listeners = new Hashtable();
    private Hashtable wirePipes = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$pipe$PipeServiceImpl;

    public Service getInterface() {
        return new PipeServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] arg) {
        this.pipeResolver = new PipeResolver(this.myGroup);
        return 0;
    }

    public void stopApp() {
        if (this.pipeResolver == null) {
            return;
        }
        this.pipeResolver.stop();
        this.pipeResolver = null;
    }

    public void init(PeerGroup pg, ID assignedID, Advertisement impl) {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.myGroup = pg;
        queueTable = new Hashtable();
        this.endpoint = this.myGroup.getEndpointService();
    }

    public InputPipe createInputPipe(PipeAdvertisement adv) throws IOException {
        InputPipe ip = null;
        String type = adv.getType();
        PipeID pipeId = (PipeID)adv.getPipeID().clone();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("createInputPipe: " + pipeId.toString()));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("           type: " + type));
        }
        if (type.equals("JxtaUnicast")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            ip = new InputPipeImpl(this.myGroup, this.pipeResolver, pipeId);
        } else if (type.equals("JxtaUnicastSecure")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            ip = new SecureInputPipeImpl(this.myGroup, this.pipeResolver, pipeId);
        } else if (type.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(adv);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            ip = wirePipe.createInputPipe();
        } else {
            throw new IOException("unknown pipe type");
        }
        return ip;
    }

    public InputPipe createInputPipe(PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        String type = adv.getType();
        PipeID pipeId = (PipeID)adv.getPipeID().clone();
        InputPipe ip = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("createInputPipe: " + pipeId.toString()));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("           type: " + type));
        }
        if (type.equals("JxtaUnicast")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            ip = new InputPipeImpl(this.myGroup, this.pipeResolver, pipeId, listener);
        } else if (type.equals("JxtaUnicastSecure")) {
            if (this.pipeResolver == null) {
                throw new IOException("PipeResolver not ready");
            }
            ip = new SecureInputPipeImpl(this.myGroup, this.pipeResolver, pipeId, listener);
        } else if (type.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(adv);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            ip = wirePipe.createInputPipe(listener);
        } else {
            throw new IOException("unknown pipe type");
        }
        return ip;
    }

    public OutputPipe createOutputPipe(PipeAdvertisement pipeAdv, long timeout) throws IOException {
        if (this.pipeResolver == null) {
            throw new IOException("PipeResolver not ready");
        }
        PipeID pipeId = (PipeID)pipeAdv.getPipeID().clone();
        String type = pipeAdv.getType();
        if (type == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type - use UnicastType as default");
            }
            type = "JxtaUnicast";
        }
        OutputPipe op = null;
        if (type.equals("JxtaUnicast")) {
            op = new NonBlockingOutputPipe(this.myGroup, this.pipeResolver, pipeAdv, null, timeout);
        } else if (type.equals("JxtaUnicastSecure")) {
            op = new SecureOutputPipe(this.myGroup, this.pipeResolver, pipeAdv, null, timeout);
        } else if (type.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(pipeAdv);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            op = wirePipe.createOutputPipe(timeout);
        } else {
            throw new IOException("unknown pipe type");
        }
        return op;
    }

    public OutputPipe createOutputPipe(PipeAdvertisement adv, int type, Enumeration peers, long timeout) throws IOException {
        return this.createOutputPipe(adv, peers, timeout);
    }

    public OutputPipe createOutputPipe(PipeAdvertisement adv, Enumeration peers, long timeout) throws IOException {
        if (this.pipeResolver == null) {
            throw new IOException("PipeResolver not ready");
        }
        PipeID pipeId = (PipeID)adv.getPipeID().clone();
        String type = adv.getType();
        if (type == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type - use UnicastType as default");
            }
            type = "JxtaUnicast";
        }
        OutputPipe op = null;
        String peer = null;
        if (peers == null || !peers.hasMoreElements()) {
            throw new IOException("null peers");
        }
        try {
            peer = ((PeerID)peers.nextElement()).toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (type.equals("JxtaUnicast")) {
            op = new NonBlockingOutputPipe(this.myGroup, this.pipeResolver, adv, peer, timeout);
        } else if (type.equals("JxtaUnicastSecure")) {
            op = new SecureOutputPipe(this.myGroup, this.pipeResolver, adv, peer, timeout);
        } else if (type.equals("JxtaPropagate")) {
            WirePipe wirePipe = this.createWirePipe(adv);
            if (wirePipe == null) {
                throw new IOException("Invalid propagate pipe");
            }
            op = wirePipe.createOutputPipe(peers, timeout);
        } else {
            throw new IOException("unknown pipe type");
        }
        return op;
    }

    public void createOutputPipe(PipeAdvertisement pipeAdv, int type, OutputPipeListener listener) throws IOException {
        this.createOutputPipe(pipeAdv, listener);
    }

    public void createOutputPipe(PipeAdvertisement pipeAdv, OutputPipeListener listener) throws IOException {
        if (this.pipeResolver == null) {
            throw new IOException("PipeResolver not ready");
        }
        PipeID pipeId = (PipeID)pipeAdv.getPipeID().clone();
        String type = pipeAdv.getType();
        if (type == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type - use UnicastType as default");
            }
            type = "JxtaUnicast";
        }
        if (!type.equals("JxtaUnicast") && !type.equals("JxtaUnicastSecure")) {
            if (type.equals("JxtaPropagate")) {
                throw new IOException("Propagated PipeService do not allow OutputPipe listener");
            }
            throw new IOException("unknown pipe type");
        }
        this.listeners.put(pipeId.toString(), listener);
        PipeListener myListener = new PipeListener(pipeAdv, this.myGroup.getPeerID());
        this.pipeResolver.addListener(pipeId.toString(), myListener);
        this.pipeResolver.find(pipeAdv, 0L, false);
    }

    public Message createMessage() {
        return this.endpoint.newMessage();
    }

    public synchronized OutputPipeListener removeOutputPipeListener(String pipeID, OutputPipeListener listener) {
        if (this.pipeResolver == null) {
            return null;
        }
        this.pipeResolver.removeListener(pipeID);
        return (OutputPipeListener)this.listeners.remove(listener);
    }

    private synchronized WirePipe createWirePipe(PipeAdvertisement adv) {
        String pid = adv.getPipeID().toString();
        if (this.wirePipes.containsKey(pid)) {
            return (WirePipe)this.wirePipes.get(pid);
        }
        WirePipe wirePipe = null;
        try {
            wirePipe = new WirePipe(this.myGroup, adv);
        }
        catch (IllegalArgumentException ez1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"wrong pipe advertisement");
            }
            return null;
        }
        this.wirePipes.put(pid, wirePipe);
        return wirePipe;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PipeListener
    implements PipeResolver.Listener {
        protected PipeAdvertisement pAdv = null;
        private PeerID localPeerID = null;
        private Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$PipeServiceImpl == null ? (class$net$jxta$impl$pipe$PipeServiceImpl = PipeServiceImpl.class$("net.jxta.impl.pipe.PipeServiceImpl")) : class$net$jxta$impl$pipe$PipeServiceImpl).getName());

        public PipeListener(PipeAdvertisement pAdv, PeerID localPeerID) {
            this.pAdv = pAdv;
            this.localPeerID = localPeerID;
        }

        public void pipeResolverEvent(PipeResolver.Event e) {
            block10: {
                PipeID pipeId = null;
                try {
                    pipeId = (PipeID)IDFactory.fromURL(new URL(e.getPipeID()));
                }
                catch (Exception ex) {
                    if (this.LOG.isEnabledFor(Priority.DEBUG)) {
                        this.LOG.debug((Object)("Malformed pipe id : \n" + e.getPipeID()), (Throwable)ex);
                    }
                    ex.printStackTrace();
                }
                try {
                    String pstr = e.getPipeID();
                    if (PipeServiceImpl.this.listeners.containsKey(pstr)) {
                        OutputPipe op = null;
                        String type = this.pAdv.getType();
                        boolean isLocal = e.getPeerID().equals(this.localPeerID.toString());
                        if (type.equals("JxtaUnicast") || isLocal) {
                            op = new NonBlockingOutputPipe(PipeServiceImpl.this.myGroup, PipeServiceImpl.this.pipeResolver, this.pAdv, e.getPeerID());
                        } else if (type.equals("JxtaUnicastSecure") || isLocal) {
                            op = new SecureOutputPipe(PipeServiceImpl.this.myGroup, PipeServiceImpl.this.pipeResolver, this.pAdv, e.getPeerID());
                        }
                        if (op != null) {
                            OutputPipeEvent newevent = new OutputPipeEvent(this, op, pipeId.toString(), e.getQueryID());
                            OutputPipeListener pl = (OutputPipeListener)PipeServiceImpl.this.listeners.get(pstr);
                            pl.outputPipeEvent(newevent);
                        }
                    }
                }
                catch (IOException ie) {
                    if (!this.LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    this.LOG.debug((Object)"Error creating output pipe :", (Throwable)ie);
                }
            }
        }
    }
}

