/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.peer.PeerInfoServiceInterface;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.protocol.PeerInfoQueryMsg;
import net.jxta.impl.protocol.PeerInfoResponseMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.util.EndpointServiceStatsFilter;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerInfoEvent;
import net.jxta.peer.PeerInfoListener;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerInfoQueryMessage;
import net.jxta.protocol.PeerInfoResponseMessage;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PeerInfoServiceImpl
implements PeerInfoService,
QueryHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peer$PeerInfoServiceImpl == null ? (class$net$jxta$impl$peer$PeerInfoServiceImpl = PeerInfoServiceImpl.class$("net.jxta.impl.peer.PeerInfoServiceImpl")) : class$net$jxta$impl$peer$PeerInfoServiceImpl).getName());
    private static final String dirname = "PeerInfoService";
    private long startTime = 0L;
    private volatile int qid = 0;
    private Cm cm = null;
    private ResolverService resolver = null;
    private RefPeerGroup pg = null;
    private EndpointService endpoint = null;
    private EndpointServiceStatsFilter incomingStats = null;
    private EndpointServiceStatsFilter outgoingStats = null;
    private ID localPeerId = null;
    private Vector listeners = new Vector();
    private Hashtable listenerTable = new Hashtable();
    private ModuleImplAdvertisement implAdvertisement = null;
    private String handlerName = null;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private MimeMediaType textXml = new MimeMediaType("text/xml");
    static /* synthetic */ Class class$net$jxta$impl$peer$PeerInfoServiceImpl;

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
    }

    public Service getInterface() {
        return new PeerInfoServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.incomingStats = new EndpointServiceStatsFilter();
        this.outgoingStats = new EndpointServiceStatsFilter();
        this.pg = (RefPeerGroup)group;
        this.endpoint = this.pg.getEndpointService();
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = this.pg.getPeerID();
        this.handlerName = assignedID.toString();
        this.startTime = System.currentTimeMillis();
    }

    public PeerInfoResponseMessage getPeerInfoService() {
        int now = (int)(System.currentTimeMillis() / 1000L);
        Hashtable<String, Long> itraffic = new Hashtable<String, Long>();
        Enumeration ik = this.incomingStats.getChannelNames();
        while (ik.hasMoreElements()) {
            String k = (String)ik.nextElement();
            itraffic.put(k, new Long(this.incomingStats.getTrafficOnChannel(k)));
        }
        Hashtable<String, Long> otraffic = new Hashtable<String, Long>();
        Enumeration ok = this.outgoingStats.getChannelNames();
        while (ok.hasMoreElements()) {
            String k = (String)ok.nextElement();
            otraffic.put(k, new Long(this.outgoingStats.getTrafficOnChannel(k)));
        }
        PeerInfoResponseMsg adv = new PeerInfoResponseMsg(this.localPeerId, this.localPeerId, (long)now - this.startTime, now, this.incomingStats.getLastMessageTime(), this.outgoingStats.getLastMessageTime(), itraffic, otraffic);
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemotePeerInfo(ID peer) {
        if (this.resolver == null) {
            return this.qid++;
        }
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(this.textXml, PeerInfoQueryMessage.getMessageType());
        Element e = null;
        e = doc.createElement((Object)"sourcePid", this.localPeerId);
        doc.appendChild(e);
        e = doc.createElement((Object)"targetPid", peer);
        doc.appendChild(e);
        ResolverQuery query = null;
        String ds = this.docToString(doc);
        PeerInfoServiceImpl peerInfoServiceImpl = this;
        synchronized (peerInfoServiceImpl) {
            query = new ResolverQuery(this.handlerName, this.credentialDoc, this.localPeerId.toString(), ds, this.qid++);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sending query " + query.getQueryId() + " from " + Integer.toHexString(this.localPeerId.hashCode()) + " to " + (peer == null ? "null" : Integer.toHexString(peer.hashCode()))));
        }
        this.resolver.sendQuery(peer.toString(), query);
        return query.getQueryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRemotePeerInfo(ID peerid, PeerInfoListener listener) {
        if (this.resolver == null) {
            return;
        }
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(this.textXml, PeerInfoQueryMessage.getMessageType());
        Element e = null;
        e = doc.createElement((Object)"sourcePid", this.localPeerId);
        doc.appendChild(e);
        e = doc.createElement((Object)"targetPid", peerid);
        doc.appendChild(e);
        ResolverQuery query = null;
        String ds = this.docToString(doc);
        PeerInfoServiceImpl peerInfoServiceImpl = this;
        synchronized (peerInfoServiceImpl) {
            query = new ResolverQuery(this.handlerName, this.credentialDoc, this.localPeerId.toString(), ds, this.qid++);
        }
        if (listener != null) {
            this.listenerTable.put(new Integer(query.getQueryId()), listener);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sending query " + query.getQueryId() + " from " + this.localPeerId + " to " + peerid));
        }
        this.resolver.sendQuery(peerid.toString(), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Enumeration getLocalPeerInfo(ID peerid) throws IOException {
        result = new Vector<Object>();
        if (this.cm == null) {
            return result.elements();
        }
        if (peerid == null) {
            fn = this.cm.getFileNames("PeerInfoService");
            i = 0;
            while (i < fn.length) {
                block19: {
                    is = null;
                    adv = null;
                    try {
                        is = this.cm.getInputStream("PeerInfoService", fn[i]);
                        adv = AdvertisementFactory.newAdvertisement(this.textXml, is);
                        result.addElement(adv);
                        var9_12 = null;
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var8_14) {
                        var9_12 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var8_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block19;
                        catch (Exception e) {
                            if (PeerInfoServiceImpl.LOG.isEnabledFor(Priority.DEBUG)) {
                                PeerInfoServiceImpl.LOG.debug((Object)e);
                            }
                            var9_12 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
                ++i;
            }
        } else {
            try {
                fn = peerid.getUniqueValue().toString();
                if (PeerInfoServiceImpl.LOG.isEnabledFor(Priority.DEBUG)) {
                    PeerInfoServiceImpl.LOG.debug((Object)("restoring " + fn + " from " + "PeerInfoService"));
                }
                doc = null;
                doc = this.cm.restore("PeerInfoService", fn);
                adv = new PeerInfoResponseMsg(doc);
                result.addElement(adv);
            }
            catch (Exception var3_5) {
                // empty catch block
            }
        }
        return result.elements();
    }

    public PeerGroup getGroup() {
        return this.pg;
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg query) throws NoResponseException {
        Object response;
        StructuredTextDocument doc = null;
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(this.textXml, new ByteArrayInputStream(query.getQuery().getBytes()));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"PeerInfoService.processQuery got a bad adv", (Throwable)e);
            }
            return null;
        }
        PeerInfoQueryMsg pipquery = new PeerInfoQueryMsg(doc);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processing query " + query.getQueryId() + " at peer " + this.localPeerId + " from " + pipquery.getSourcePid() + " to " + pipquery.getTargetPid()));
        }
        if (this.localPeerId.equals(pipquery.getTargetPid())) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("responding to query " + query.getQueryId()));
            }
            response = new PeerInfoResponseMsg();
            ((PeerInfoResponseMessage)response).setSourcePid(pipquery.getSourcePid());
            ((PeerInfoResponseMessage)response).setTargetPid(this.localPeerId);
            long now = System.currentTimeMillis();
            ((PeerInfoResponseMessage)response).setUptime(now - this.startTime);
            ((PeerInfoResponseMessage)response).setTimestamp(now);
            ((PeerInfoResponseMessage)response).setLastIncomingMessageTime(this.incomingStats.getLastMessageTime());
            ((PeerInfoResponseMessage)response).setLastOutgoingMessageTime(this.outgoingStats.getLastMessageTime());
            Enumeration ichannels = this.incomingStats.getChannelNames();
            while (ichannels.hasMoreElements()) {
                String ch = (String)ichannels.nextElement();
                long tr = this.incomingStats.getTrafficOnChannel(ch);
                ((PeerInfoResponseMessage)response).setIncomingTrafficElement(ch, tr);
            }
            Enumeration ochannels = this.outgoingStats.getChannelNames();
            while (ochannels.hasMoreElements()) {
                String ch = (String)ochannels.nextElement();
                long tr = this.outgoingStats.getTrafficOnChannel(ch);
                ((PeerInfoResponseMessage)response).setOutgoingTrafficElement(ch, tr);
            }
            doc = (StructuredTextDocument)((PeerInfoResponseMessage)response).getDocument(this.textXml);
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("forwarding query " + query.getQueryId()));
            }
            try {
                doc = (StructuredTextDocument)((PeerInfoQueryMessage)pipquery).getDocument(this.textXml);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Failure in gettting pip query", (Throwable)e);
                }
                return null;
            }
        }
        response = null;
        response = new ResolverResponse(this.handlerName, this.credentialDoc, query.getQueryId(), this.docToString(doc));
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sending response to " + ((ResolverResponseMsg)response).getQueryId()));
        }
        return response;
    }

    public void processResponse(ResolverResponseMsg response) {
        if (this.cm == null) {
            return;
        }
        PeerInfoResponseMsg resp = null;
        try {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(this.textXml, new ByteArrayInputStream(response.getResponse().getBytes()));
            resp = new PeerInfoResponseMsg(doc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"PeerInfoService.processResponse got a bad adv", (Throwable)e);
            }
            return;
        }
        PeerInfoEvent newevent = new PeerInfoEvent(this, resp, response.getQueryId());
        PeerInfoListener listener = (PeerInfoListener)this.listenerTable.get(new Integer(response.getQueryId()));
        if (listener != null) {
            listener.peerInfoResponse(newevent);
        }
        int i = 0;
        while (i < this.listeners.size()) {
            listener = (PeerInfoListener)this.listeners.elementAt(i);
            listener.peerInfoResponse(newevent);
            ++i;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processing response " + response.getQueryId() + " at peer " + Integer.toHexString(this.localPeerId.hashCode()) + " from " + Integer.toHexString(resp.getSourcePid().hashCode()) + " to " + Integer.toHexString(resp.getTargetPid().hashCode())));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("publishing response " + response.getQueryId()));
        }
        try {
            StructuredDocument doc = (StructuredDocument)((PeerInfoResponseMessage)resp).getDocument(this.textXml);
            String fn = resp.getTargetPid().getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("publishing response " + response.getQueryId() + " in " + fn));
            }
            this.cm.save(dirname, fn, doc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)e);
            }
            return;
        }
    }

    public void flushAdvertisements(ID id) throws IOException {
        if (this.cm == null) {
            return;
        }
        if (id != null) {
            String fn = id.getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("flushing advertisements for peer " + Integer.toHexString(id.hashCode()) + " fn " + fn));
            }
            this.cm.remove(dirname, fn);
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"flushing all advertisements");
            }
            String[] fn = this.cm.getFileNames(dirname);
            int i = 0;
            while (i < fn.length) {
                this.cm.remove(dirname, fn[i]);
                ++i;
            }
        }
    }

    public synchronized void addPeerInfoListener(PeerInfoListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized boolean removePeerInfoListener(PeerInfoListener listener) {
        return this.listeners.removeElement(listener);
    }

    private String docToString(StructuredTextDocument doc) {
        StringWriter out = new StringWriter();
        try {
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"docToString failed", (Throwable)e);
            }
            return "";
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dirname = dirname;
    }
}

