/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index.xpath;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.jxta.impl.xml.XmlParser;

public class DocumentParserCallback
implements XmlParser.ParserCallback {
    private static boolean debug = false;
    private TagStack tagStack = new TagStack();
    private StringBuffer path = new StringBuffer();
    private TreeSet paths = new TreeSet();
    private boolean expectEndTag = false;

    public static void main(String[] argv) throws IOException, XmlParser.Exception {
        byte[] buf = new byte[32768];
        DocumentParserCallback cb = new DocumentParserCallback();
        XmlParser.parse(System.in, buf, cb);
    }

    public TreeSet getPaths() {
        return this.paths;
    }

    public void startTag(byte[] chars, int start, int len) throws XmlParser.Exception {
        if (chars[start] != 63 && chars[start] != 33) {
            Tag tag = new Tag(new String(chars, start, len).toUpperCase());
            this.tagStack.push(tag);
            this.path.append('/');
            this.path.append(tag.name);
            this.addPaths(this.path.length());
        }
    }

    public void endTag(byte[] chars, int start, int len) throws XmlParser.Exception {
        Tag top = this.tagStack.top();
        if (top == null) {
            throw new XmlParser.Exception("Unexpected close tag " + new String(chars, start, len));
        }
        byte[] name = top.name.toUpperCase().getBytes();
        if (XmlParser.startsWith(name, chars, start + 1, len - 1) || XmlParser.startsWith(name, chars, start, len)) {
            this.path.setLength(this.path.length() - (top.name.length() + 1));
            this.tagStack.pop();
            if (top.charBuffer != null) {
                this.addText(top);
            }
        } else {
            throw new XmlParser.Exception("Unexpected end tag " + new String(chars, start, len) + ".  Expecting " + top.name);
        }
    }

    public void attribute(byte[] nameChars, int nameStart, int nameLength, byte[] valueChars, int valueStart, int valueLength) throws XmlParser.Exception {
        String name = new String(nameChars, nameStart, nameLength).toUpperCase();
        String value = new String(valueChars, valueStart, valueLength).toUpperCase();
        int savedLength = this.path.length();
        this.path.append('[');
        this.path.append('@');
        this.path.append(name);
        this.path.append('=');
        this.path.append('\'');
        this.path.append(value);
        this.path.append('\'');
        this.path.append(']');
        this.addPaths(savedLength);
        this.path.setLength(savedLength);
    }

    public void chars(byte[] chars, int start, int length) {
        Tag top = this.tagStack.top();
        if (top != null) {
            if (top.charBuffer == null) {
                top.charBuffer = new StringBuffer();
            }
            char[] arr = new char[length];
            int i = 0;
            while (i < length) {
                arr[i] = (char)chars[start + i];
                ++i;
            }
            top.charBuffer.append(arr);
        }
    }

    void addPath(String path) {
        this.paths.add(path);
    }

    StringTokenizer tokenize(String text) {
        return new StringTokenizer(text, " \t\r\n,.:;");
    }

    private void addText(Tag tag) {
        String text = tag.charBuffer.toString().trim().toUpperCase();
        if (text.length() > 0) {
            StringTokenizer e = this.tokenize(text);
            while (e.hasMoreElements()) {
                int savedLength = this.path.length();
                this.path.append('[');
                this.path.append(tag.name);
                this.path.append('=');
                this.path.append('\'');
                this.path.append((String)e.nextElement());
                this.path.append('\'');
                this.path.append(']');
                this.addPaths(savedLength);
                this.addPath("//" + this.path.substring(savedLength));
                this.path.setLength(savedLength);
            }
        }
    }

    private void addPaths(int firstStart) {
        int length = this.path.length();
        int start = firstStart - 1;
        Tag tag = this.tagStack.top;
        while (tag != null) {
            start -= tag.name.length();
            if (tag.next == null) {
                this.addPath(this.path.substring(start, length));
            } else {
                this.addPath("/" + this.path.substring(start, length));
            }
            if (tag != this.tagStack.top && tag != this.tagStack.top.next) {
                this.addPath((tag.next == null ? "/" : "//") + tag.name + "//" + this.tagStack.top.name + (firstStart == length ? "" : this.path.substring(firstStart, length)));
            }
            --start;
            tag = tag.next;
        }
    }

    class TagStack {
        Tag top;

        TagStack() {
        }

        void push(Tag t) {
            if (this.top == null) {
                this.top = t;
            } else {
                t.next = this.top;
                this.top = t;
            }
        }

        Tag pop() {
            Tag t = this.top;
            if (this.top != null) {
                this.top = this.top.next;
            }
            return t;
        }

        Tag top() {
            return this.top;
        }
    }

    class Tag {
        String name;
        StringBuffer charBuffer;
        Tag next;

        Tag(String name) {
            this.name = name.intern();
            this.charBuffer = null;
            this.next = null;
        }
    }
}

