/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLSocket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.tls.JTlsInputStream;
import net.jxta.impl.endpoint.tls.JTlsOutputStream;
import net.jxta.impl.endpoint.tls.JTlsParams;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConfig;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsConn {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsConn == null ? (class$net$jxta$impl$endpoint$tls$TlsConn = TlsConn.class$("net.jxta.impl.endpoint.tls.TlsConn")) : class$net$jxta$impl$endpoint$tls$TlsConn).getName());
    TlsManager manager = null;
    TlsTransport transport = null;
    static final String userPassword = "password";
    SSLSocket ssls = null;
    JTlsOutputStream jout = null;
    JTlsInputStream jin = null;
    JTlsParams params = null;
    String rootdir = null;
    String rootfile = null;
    String keyfile = null;
    String dhfile = null;
    String passphrase = null;
    String suites = null;
    String ppPath = null;
    String rootCertFile = null;
    boolean unverifiedCerts = true;
    boolean checkDates = true;
    boolean clientAuthorization = false;
    ReadPlaintextMessage readerThread = null;
    EndpointAddress destAddr = null;
    int which = 0;
    private boolean handshakeDone = false;
    private boolean inputDead = false;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsConn;

    public boolean getHandshakeDone() {
        return this.handshakeDone;
    }

    public boolean getInputDead() {
        return this.inputDead;
    }

    public TlsConn(TlsManager manager, TlsTransport tp, EndpointAddress destAddr, boolean client, Message msg) throws IOException {
        this.manager = manager;
        this.transport = tp;
        this.destAddr = destAddr;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsConn, contacting: " + destAddr.getProtocolAddress()));
        }
        this.setPathnames();
        String thePassword = new String(TlsConfig.passitOn);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsConn, password = " + thePassword));
        }
        if (thePassword == null) {
            throw new IOException("TlsConn: null password. Cannot proceed.");
        }
        this.passphrase = JTlsUtil.readPassPhrase(this.ppPath, thePassword);
        thePassword = null;
        this.unverifiedCerts = true;
        this.clientAuthorization = false;
        this.rootCertFile = this.getRootCert(destAddr);
        if (this.rootCertFile != null) {
            if (client) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Verifying certs, root = " + this.rootCertFile));
                }
                this.unverifiedCerts = false;
            } else {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Authorizing client, root = " + this.rootCertFile));
                }
                this.clientAuthorization = true;
            }
        } else {
            this.rootCertFile = this.rootfile;
            if (LOG.isEnabledFor(Priority.INFO)) {
                String who = client ? "Server" : "Client";
                LOG.info((Object)("NOT Verifying " + who + " cert, root = " + this.rootCertFile));
            }
        }
        if (client) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TLS Client");
            }
            this.params = new JTlsParams();
            this.params.setClientParameters(this.rootCertFile, this.keyfile, this.passphrase, this.suites, this.unverifiedCerts, this.checkDates);
            this.which = 1;
        } else {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TLS Server");
            }
            this.params = new JTlsParams();
            this.params.setServerParameters(this.rootCertFile, this.keyfile, this.dhfile, this.passphrase, this.clientAuthorization);
            this.which = 2;
        }
        if (!this.unverifiedCerts || this.clientAuthorization) {
            this.removeRootCertFile();
        }
        this.rootCertFile = null;
        this.jin = new JTlsInputStream(this);
        if (msg != null) {
            this.jin.queueIncomingMessage(msg);
        }
        this.jout = new JTlsOutputStream(this, tp, destAddr);
    }

    public void openTLSConnection() throws IOException {
        String shash1 = this.destAddr.getProtocolAddress();
        int shash2 = 1376911;
        boolean client = this.which == 1;
        long startTime = 0L;
        if (LOG.isEnabledFor(Priority.INFO)) {
            startTime = System.currentTimeMillis();
            LOG.info((Object)((client ? "Client:" : "Server:") + " Handshake START"));
        }
        this.handshakeDone = false;
        this.ssls = new SSLSocket(this.params.getContext(), (InputStream)this.jin, (OutputStream)this.jout, shash1, shash2, this.which);
        this.handshakeDone = true;
        if (LOG.isEnabledFor(Priority.INFO)) {
            long hsTime = (System.currentTimeMillis() - startTime) / 1000L;
            LOG.info((Object)((client ? "Client:" : "Server:") + "Handshake DONE in " + hsTime + " secs\n"));
        }
        this.jin.setPlaintextInputStream(this.ssls);
        this.jout.setPlaintextOutputStream(this.ssls);
        this.readerThread = new ReadPlaintextMessage(this.jin, this.transport);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"TLS: Started plaintext reader thread");
        }
    }

    public void sendMessage(Message msg) throws IOException {
        this.jout.writeMessage(msg);
    }

    private void setPathnames() {
        String PCERootPath;
        String PCEPath = JTlsUtil.getPCEPath();
        this.rootdir = PCERootPath = JTlsUtil.getPCERootPath();
        String PCEClientPath = JTlsUtil.getPCEClientPath();
        this.rootfile = PCERootPath + "peer-root.pem";
        this.keyfile = PCEClientPath + "peer-service.pem";
        this.ppPath = PCEClientPath + "peer.phrase";
        this.dhfile = null;
    }

    private String getRootCert(EndpointAddress destAddr) {
        String peerID = "urn:jxta:" + destAddr.getProtocolAddress();
        PeerGroup pg = this.transport.getPeerGroup();
        DiscoveryService discovery = pg.getDiscoveryService();
        Enumeration enumeration = null;
        String rc = null;
        try {
            enumeration = discovery.getLocalAdvertisements(0, "PID", peerID);
            if (!enumeration.hasMoreElements()) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("getRootCert: enum is empty\n  PID = " + peerID));
                }
                return null;
            }
            PeerAdvertisement adv = (PeerAdvertisement)enumeration.nextElement();
            StructuredDocument doc = adv.getServiceParam(PeerGroup.peerGroupClassID);
            Enumeration children = doc.getChildren("RootCert");
            rc = (String)((TextElement)children.nextElement()).getValue();
            rc = rc + "\n";
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("getRootCert, Exception: " + e.getMessage()));
                e.printStackTrace();
            }
            return null;
        }
        String rcfileName = this.rootdir + peerID + ".pem";
        try {
            JTlsUtil.writeRootCert(rc, rcfileName);
        }
        catch (Exception s) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("genRootCert, Exception: " + s.getMessage()));
            }
            return null;
        }
        return rcfileName;
    }

    private void removeRootCertFile() {
        File f = new File(this.rootCertFile);
        try {
            if (!LOG.isEnabledFor(Priority.INFO)) {
                f.delete();
            } else {
                LOG.info((Object)("Removed " + this.rootCertFile));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReadPlaintextMessage
    implements Runnable {
        JTlsInputStream ptin = null;
        TlsTransport tp = null;
        int nErrors = 0;
        Thread th = null;
        private static final long ERRORWAIT = 30000L;

        public ReadPlaintextMessage(JTlsInputStream ptin, TlsTransport tp) {
            this.ptin = ptin;
            this.tp = tp;
            this.th = new Thread((Runnable)this, "jxtatlsInputThread");
            this.th.setDaemon(true);
            this.th.start();
        }

        public void run() {
            while (true) {
                MessageImpl msg;
                int i;
                if ((i = this.ptin.readMessage(msg = new MessageImpl())) == 0) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Dispatching msg to TlsTransport");
                    }
                    this.tp.processReceivedMessage(msg);
                    this.nErrors = 0;
                    continue;
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"I/O error while reading decrypted Message");
                }
                ++this.nErrors;
                if (this.nErrors != 10) continue;
                TlsConn.this.inputDead = true;
                try {
                    Thread.currentThread();
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.nErrors = 0;
            }
        }
    }
}

