/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.PeerCerts;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsConfig {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsConfig == null ? (class$net$jxta$impl$endpoint$tls$TlsConfig = TlsConfig.class$("net.jxta.impl.endpoint.tls.TlsConfig")) : class$net$jxta$impl$endpoint$tls$TlsConfig).getName());
    private static final boolean wantDH = false;
    static String passitOn = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsConfig;

    public static boolean willConfigureTls() {
        try {
            String pce = JTlsUtil.getPCEPath();
            File fpce = new File(pce);
            if (!fpce.exists()) {
                return true;
            }
            if (!TlsConfig.allPCEChildrenExist()) {
                return true;
            }
        }
        catch (Exception s) {
            return true;
        }
        return false;
    }

    public static void init(String principal, String password) {
        if (LOG.getChainedPriority().equals(Priority.INFO)) {
            SSLDebug.setDebug((int)4);
        }
        SSLDebug.debug((int)128, (String)("TlsConfig, peer = " + principal + ", password = " + password + "\n"));
        String pce = JTlsUtil.getPCEPath();
        File fpce = new File(pce);
        boolean createPse = false;
        try {
            if (!fpce.exists()) {
                fpce.mkdir();
                TlsConfig.makeChildren();
                createPse = true;
            } else if (!TlsConfig.allPCEChildrenExist()) {
                TlsConfig.removeAllChildren();
                TlsConfig.makeChildren();
                createPse = true;
            } else {
                boolean principalOK = true;
                if (!principalOK) {
                    TlsConfig.removeAllChildren();
                    TlsConfig.makeChildren();
                    createPse = true;
                }
            }
        }
        catch (Exception s) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)"Cert generation failed", (Throwable)s);
            }
            return;
        }
        if (createPse) {
            try {
                SSLDebug.debug((int)128, (String)"TlsConfig: Generating certs ...");
                System.out.println("\nSecurity initialization in progress.\nThis will take 10 or more seconds ...\n");
                PeerCerts.generateCerts(principal, password, false);
                JTlsUtil.createPasswdFile(password, false);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)"Cert generation failed", (Throwable)e);
                }
                return;
            }
        }
        if (password.compareTo("password") != 0 && JTlsUtil.validPasswd("password")) {
            try {
                JTlsUtil.createPasswdFile(password, true);
                String phraseFile = JTlsUtil.getPCEClientPath() + "peer.phrase";
                String pfstr64 = JTlsUtil.readPassPhrase(phraseFile, "password");
                PeerCerts.writePassphrase(phraseFile, pfstr64, password);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)"Cannot create password file:", (Throwable)e);
                }
                return;
            }
        }
        if (SSLDebug.getDebug((int)128)) {
            if (JTlsUtil.validPasswd(password)) {
                System.out.println(password + " VALID");
            } else {
                System.out.println(password + " NOT VALID");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Cert generation OK");
        }
        SSLDebug.debug((int)128, (String)"Cert generation OK");
        passitOn = new String(password);
    }

    static void makeChildren() throws SecurityException, IOException {
        String client = JTlsUtil.getPCEClientPath();
        String root = JTlsUtil.getPCERootPath();
        String pwd = JTlsUtil.getPCEPasswdPath();
        File fc = new File(client);
        fc.mkdir();
        File fr = new File(root);
        fr.mkdir();
        File fp = new File(pwd);
        fr.mkdir();
    }

    static void removeAllChildren() throws SecurityException {
        String client = JTlsUtil.getPCEClientPath();
        String root = JTlsUtil.getPCERootPath();
        String pwd = JTlsUtil.getPCEPasswdPath();
        File fc = new File(client);
        File fr = new File(root);
        File fp = new File(pwd);
        String[] clientChildren = fc.list();
        String[] rootChildren = fr.list();
        String[] pwdChildren = fp.list();
        SSLDebug.debug((int)128, (String)"Removing child files");
        TlsConfig.removeDir(fc, clientChildren);
        TlsConfig.removeDir(fr, rootChildren);
        TlsConfig.removeDir(fp, pwdChildren);
    }

    static void removeDir(File dir, String[] children) throws SecurityException {
        if (children != null) {
            int n = children.length;
            if (children != null && n > 0) {
                int i = 0;
                while (i < n) {
                    File rm = new File(children[i]);
                    rm.delete();
                    SSLDebug.debug((int)128, (String)(" " + children[i]));
                    ++i;
                }
            }
        }
        if (dir.exists()) {
            dir.delete();
        }
    }

    static boolean allPCEChildrenExist() throws SecurityException {
        String client = JTlsUtil.getPCEClientPath();
        String root = JTlsUtil.getPCERootPath();
        String pwd = JTlsUtil.getPCEPasswdPath();
        File fc = new File(client);
        File fr = new File(root);
        File fp = new File(pwd);
        if (!(fc.exists() && fr.exists() && fp.exists())) {
            return false;
        }
        String rootFile = root + "peer-root.pem";
        String clientFile = client + "peer-service.pem";
        String phraseFile = client + "peer.phrase";
        String pwdFile = pwd + "passwd";
        File f = new File(rootFile);
        File g = new File(clientFile);
        File h = new File(phraseFile);
        File i = new File(pwdFile);
        if (!(f.exists() && g.exists() && h.exists() && i.exists())) {
            SSLDebug.debug((int)128, (String)"Missing certificate, passphrase, or password file.");
            return false;
        }
        return JTlsUtil.verifySignedCert(rootFile, clientFile);
    }

    public static String getRootCert() throws IOException {
        String rootFile = JTlsUtil.getPCERootPath() + "peer-root.pem";
        FileReader fr = new FileReader(rootFile);
        BufferedReader br = new BufferedReader(fr);
        String rc64 = JTlsUtil.loadObject(br, "CERTIFICATE");
        return rc64;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

