/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.IOException;
import net.jxta.impl.endpoint.tls.JTlsUtil;

public class JTlsParams {
    private String keyfile = null;
    private String passphrase = null;
    private String rootfile = null;
    private boolean acceptUnverifiedCerts = false;
    private boolean validateDates = false;
    private short[] cipherSuites = null;
    private SSLContext ctx = new SSLContext();
    private SSLPolicyInt policy = new SSLPolicyInt();

    public JTlsParams() {
        this.ctx.seedJxtaRNG();
        this.cipherSuites = null;
    }

    public SSLContext getContext() {
        return this.ctx;
    }

    public SSLPolicyInt getPolicy() {
        return this.policy;
    }

    private void loadRootCerts(String rootfile) throws IOException {
        this.passphrase = this.passphrase;
        this.rootfile = rootfile;
        this.ctx.loadRootCertificates(rootfile);
    }

    private void loadEAYKeyFile(String keyfile, String passphrase) throws IOException {
        this.keyfile = keyfile;
        this.passphrase = passphrase;
        this.ctx.loadEAYKeyFile(keyfile, passphrase);
    }

    private void setCertPolicies(boolean unverifiedOK, boolean checkDates) {
        this.acceptUnverifiedCerts = unverifiedOK;
        this.validateDates = checkDates;
        this.policy.checkCertificateDates(this.validateDates);
        this.policy.acceptUnverifiableCertificates(this.acceptUnverifiedCerts);
    }

    private void setCipherSuites(String suites) {
        if (suites == null) {
            return;
        }
        this.cipherSuites = JTlsUtil.parseCipherSuites(suites);
        if (this.cipherSuites != null) {
            this.policy.setCipherSuites(this.cipherSuites);
        }
    }

    public void setClientParameters(String rootfile, String keyfile, String passphrase, String suites, boolean unverifiedOK, boolean checkDates) throws IOException, ArrayIndexOutOfBoundsException {
        if (rootfile == null || keyfile == null) {
            throw new IOException("null file name as argument");
        }
        this.loadRootCerts(rootfile);
        this.loadEAYKeyFile(keyfile, passphrase);
        this.setCertPolicies(unverifiedOK, checkDates);
        this.setCipherSuites(suites);
        this.ctx.setPolicy(this.policy);
    }

    public void setServerParameters(String rootfile, String keyfile, String dhfile, String passphrase, boolean clientAuthorization) throws IOException {
        if (rootfile == null || keyfile == null) {
            throw new IOException("null file name as argument");
        }
        if (dhfile != null) {
            this.ctx.loadDHParams(dhfile);
        }
        this.loadRootCerts(rootfile);
        this.loadEAYKeyFile(keyfile, passphrase);
        this.policy.requireClientAuth(clientAuthorization);
        this.ctx.setPolicy(this.policy);
    }
}

