/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.servlethttp.MessageReceiver;
import net.jxta.impl.endpoint.servlethttp.QueryString;
import net.jxta.impl.relay.AbstractRelayClient;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpRelayClientMessageReceiver
extends AbstractRelayClient
implements MessageReceiver {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver = HttpRelayClientMessageReceiver.class$("net.jxta.impl.endpoint.servlethttp.HttpRelayClientMessageReceiver")) : class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver).getName());
    private static Timer pollTimer = null;
    private static final int MODE_POLL = 0;
    private static final int MODE_BLOCK = 1;
    private static final int POLL_INTERVAL = 15000;
    private static final int BLOCK_TIMEOUT = 60000;
    private static final int BLOCK_RETRY_INTERVAL = 15000;
    private static final int COMMAND_TIMEOUT = 20000;
    URL url = null;
    EndpointService endpoint = null;
    PeerGroup group = null;
    private int requestMode = 1;
    private BlockingMessageReceiver blockingReceiver = null;
    private Thread receiverThread = null;
    private PollingMessageReceiverTask pollingTask = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver;

    public HttpRelayClientMessageReceiver(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("HttpRelayClientMessageReceiver cannot be configured with a null url");
        }
        this.url = url;
    }

    public void init(PeerGroup group, EndpointService endpoint, TransportAdvertisement transportAdv) throws IOException {
        this.endpoint = endpoint;
        this.group = group;
    }

    public boolean obtainLease() {
        boolean success;
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to obtain lease to relay: " + this.url));
            }
            String peerId = this.group.getPeerID().getUniqueValue().toString();
            QueryString query = new QueryString();
            query.add("command", "obtainLease");
            query.add("peerId", peerId);
            success = false;
            try {
                HttpURLConnection conn = this.postCommand(query.toString(), 20000);
                success = this.processLeaseResponse(conn);
                conn.disconnect();
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block3;
                LOG.info((Object)("Exception during lease request: " + e));
            }
        }
        return success;
    }

    public boolean renewLease() {
        boolean success;
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to renew lease to relay: " + this.url));
            }
            QueryString query = new QueryString();
            query.add("command", "renewLease");
            query.add("leaseId", this.getLeaseId());
            success = false;
            try {
                HttpURLConnection conn = this.postCommand(query.toString(), 20000);
                success = this.processLeaseResponse(conn);
                conn.disconnect();
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block3;
                LOG.info((Object)("Exception during lease renewal request: " + e));
            }
        }
        return success;
    }

    private boolean processLeaseResponse(HttpURLConnection conn) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processing lease response");
        }
        boolean success = false;
        if (conn.getResponseCode() == 200) {
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String queryString = in.readLine();
            HashMap map = QueryString.parse(queryString);
            String peerId = (String)map.get("peerId");
            String leaseId = (String)map.get("leaseId");
            String mode = (String)map.get("mode");
            Integer leaseLength = this.extractInteger(map, "leaseLength");
            if (peerId != null && leaseId != null && leaseLength != null) {
                this.requestMode = mode != null && mode.equals("poll") ? 0 : 1;
                this.recordLease(peerId, leaseId, leaseLength);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Successfully renewed lease");
                }
                success = true;
            } else if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Could not renew lease; relay server did not return proper information");
            }
        } else if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Could not renew lease; Invalid HTTP response code from relay server: " + this.url));
        }
        return success;
    }

    public void onLeaseObtained() {
        if (this.requestMode == 1) {
            if (this.blockingReceiver == null) {
                if (this.pollingTask != null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"stopping polling task");
                    }
                    this.pollingTask.cancel();
                    this.pollingTask = null;
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"starting blocking receiver");
                }
                this.blockingReceiver = new BlockingMessageReceiver();
                this.receiverThread = new Thread((Runnable)this.blockingReceiver, "BlockingMessageReceiver");
                this.receiverThread.setDaemon(true);
                this.receiverThread.start();
            }
        } else if (this.requestMode == 0 && this.pollingTask == null) {
            if (this.receiverThread != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"stopping blocking receiver");
                }
                this.blockingReceiver.stop();
                this.receiverThread.interrupt();
                this.blockingReceiver = null;
                this.receiverThread = null;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"starting polling task");
            }
            if (pollTimer == null) {
                pollTimer = new Timer(true);
            }
            this.pollingTask = new PollingMessageReceiverTask();
            pollTimer.schedule((TimerTask)this.pollingTask, 0L, 15000L);
        }
    }

    public void stop() throws InterruptedException {
        super.stop();
        AbstractRelayClient.timer.cancel();
        if (this.blockingReceiver != null) {
            this.blockingReceiver.stop();
        }
    }

    public String toString() {
        return "HttpRelayClientMessageReceiver connected to " + this.url;
    }

    private HttpURLConnection postCommand(String queryString, int timeout) throws IOException, InterruptedException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("posting command to relay " + this.url + ": " + queryString));
        }
        HttpURLConnection urlConn = (HttpURLConnection)this.url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setRequestMethod("POST");
        urlConn.setAllowUserInteraction(false);
        urlConn.setRequestProperty("Content-Length", Integer.toString(queryString.length()));
        urlConn.connect();
        BufferedOutputStream out = new BufferedOutputStream(urlConn.getOutputStream());
        out.write(queryString.getBytes(), 0, queryString.length());
        out.flush();
        out.close();
        return urlConn;
    }

    Integer extractInteger(HashMap map, String key) {
        String str = (String)map.get(key);
        if (str == null) {
            return null;
        }
        try {
            Integer retval = new Integer(str);
            return retval;
        }
        catch (NumberFormatException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Relay misbheaving; reported non-integer for: " + key));
            }
            return null;
        }
    }

    private void processRelayedMessage(HttpURLConnection conn) throws IOException {
        int contentLen;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processing relayed message");
        }
        if ((contentLen = conn.getContentLength()) < 0) {
            throw new IOException("Content-length must be specified");
        }
        InputStream in = conn.getInputStream();
        try {
            Message msg = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage(in, msg);
            this.endpoint.demux(msg);
            Thread.yield();
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Error reading message ");
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int read(InputStream in, byte[] buf, int maxLen) throws IOException {
        int n;
        int pos = 0;
        while ((n = in.read(buf, pos, maxLen - pos)) > -1) {
            void var5_5;
            pos += var5_5;
        }
        return pos;
    }

    private QueryString getLeaseIdQueryString() throws RelayLeaseException {
        QueryString query = new QueryString();
        String leaseId = this.getLeaseId();
        if (leaseId != null) {
            query.add("leaseId", this.getLeaseId());
            return query;
        }
        throw new RelayLeaseException("Lease expired");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MODE_POLL = 0;
        MODE_BLOCK = 1;
        POLL_INTERVAL = 15000;
        BLOCK_TIMEOUT = 60000;
        BLOCK_RETRY_INTERVAL = 15000;
        COMMAND_TIMEOUT = 20000;
    }

    private class PollingMessageReceiverTask
    extends TimerTask {
        private PollingMessageReceiverTask() {
        }

        public void run() {
            block7: {
                try {
                    QueryString query = HttpRelayClientMessageReceiver.this.getLeaseIdQueryString();
                    query.add("command", "poll");
                    String command = query.toString();
                    HttpURLConnection conn = HttpRelayClientMessageReceiver.this.postCommand(command, 15000);
                    if (conn.getResponseCode() == 200) {
                        HttpRelayClientMessageReceiver.this.processRelayedMessage(conn);
                    }
                    conn.disconnect();
                }
                catch (RelayLeaseException e) {
                    HttpRelayClientMessageReceiver.this.lostLease();
                }
                catch (FileNotFoundException e) {
                    HttpRelayClientMessageReceiver.this.lostLease();
                }
                catch (IOException e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("IOException during poll request to relay: " + e));
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block7;
                    LOG.debug((Object)"InterruptedException while polling");
                }
            }
        }
    }

    private class BlockingMessageReceiver
    implements Runnable {
        boolean isRunning = true;

        private BlockingMessageReceiver() {
        }

        void stop() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to stop: " + HttpRelayClientMessageReceiver.this.url));
            }
            this.isRunning = false;
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"BlockingMessageReceiver starting");
            }
            while (this.isRunning) {
                try {
                    QueryString query = HttpRelayClientMessageReceiver.this.getLeaseIdQueryString();
                    query.add("command", "block");
                    String command = query.toString();
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("POSTing block command to relay: " + HttpRelayClientMessageReceiver.this.url));
                    }
                    HttpURLConnection conn = HttpRelayClientMessageReceiver.this.postCommand(command, 60000);
                    if (this.isRunning) {
                        int responseCode = conn.getResponseCode();
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("response code == " + responseCode));
                        }
                        if (responseCode == 200) {
                            if (conn.getContentLength() == 0) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)"Relayed sent back no message");
                                }
                            } else {
                                HttpRelayClientMessageReceiver.this.processRelayedMessage(conn);
                            }
                        } else {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Non-OK response code from relay; waiting for interval: 15000");
                            }
                            Thread.sleep(15000L);
                        }
                    }
                    conn.disconnect();
                }
                catch (FileNotFoundException e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Exception during relay request: " + e));
                    }
                    HttpRelayClientMessageReceiver.this.lostLease();
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e2) {}
                }
                catch (IOException ioe) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("IOException during relay request: " + ioe));
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e2) {}
                }
                catch (RelayLeaseException e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Exception: Lease is invalid");
                    }
                    HttpRelayClientMessageReceiver.this.lostLease();
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e2) {}
                }
                catch (Throwable e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Throwable caught during blocking request to relay; waiting for an interval: " + e));
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

