/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.servlethttp.HttpClientConnection;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessenger;
import net.jxta.impl.endpoint.servlethttp.MessageSender;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpClientMessageSender
implements MessageSender {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender = HttpClientMessageSender.class$("net.jxta.impl.endpoint.servlethttp.HttpClientMessageSender")) : class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender).getName());
    private EndpointAddress localAddress = null;
    private static final long HttpClientConnectionGCDelay = 3600000L;
    private Timer HttpClientConnectionGCTimer = new Timer();
    private Hashtable openConnections = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender;

    public HttpClientMessageSender(EndpointAddress localAddress) {
        this.localAddress = localAddress;
        this.HttpClientConnectionGCTimer.scheduleAtFixedRate((TimerTask)new HttpClientConnectionGCTask(this), 3600000L, 3600000L);
    }

    public EndpointMessenger getMessenger(EndpointAddress destAddress) throws IOException {
        String urlString = destAddress.getProtocolName() + "://" + destAddress.getProtocolAddress() + "/";
        return new HttpClientMessenger(this, new URL(urlString), this.localAddress, destAddress);
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
    }

    public boolean ping(EndpointAddress addr) {
        if (addr.getProtocolAddress().indexOf("JxtaHttpClient") != -1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Ping of relay client: always false");
            }
            return false;
        }
        boolean result = false;
        String urlString = null;
        try {
            urlString = "http://" + addr.getProtocolAddress() + "/ping";
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to ping " + urlString));
            }
            URL url = new URL(urlString);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.connect();
            int code = urlConn.getResponseCode();
            if (code == 200) {
                result = true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Ping result to " + urlString + ": " + result));
        }
        return result;
    }

    private synchronized void registerHttpClientConnection(URL url, HttpClientConnection connection) {
        HttpClientConnection old;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Register connection to " + url.toString()));
        }
        if ((old = this.openConnections.put(url.toString(), connection)) != null) {
            old.close();
        }
    }

    private synchronized void unregisterHttpClientConnection(URL url) {
        HttpClientConnection old = (HttpClientConnection)this.openConnections.remove(url.toString());
        if (old != null) {
            old.close();
        }
    }

    public synchronized HttpClientConnection getHttpClientConnection(URL url) {
        HttpClientConnection connection = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Looking connection to " + url.toString()));
        }
        if ((connection = (HttpClientConnection)this.openConnections.get(url.toString())) == null) {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Creating new connection to " + url.toString()));
                }
                connection = new HttpClientConnection(url);
                this.registerHttpClientConnection(url, connection);
            }
            catch (Exception e) {
                return null;
            }
        } else if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Reusing existing connection to " + url.toString()));
        }
        connection.setLastUsed(System.currentTimeMillis());
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void httpConnectionGC() {
        Enumeration enumeration;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"HttpClientConnectionGC starts");
        }
        if ((enumeration = this.openConnections.keys()) == null || !enumeration.hasMoreElements()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"HttpClientConnectionGC: no connection. Nothing to do.");
            }
            return;
        }
        HttpClientConnection connection = null;
        long lastUsed = 0L;
        long currentTime = 0L;
        String destUrl = null;
        while (enumeration.hasMoreElements()) {
            try {
                destUrl = (String)enumeration.nextElement();
                connection = (HttpClientConnection)this.openConnections.get(destUrl);
                HttpClientMessageSender httpClientMessageSender = this;
                synchronized (httpClientMessageSender) {
                    if (connection == null) {
                        continue;
                    }
                    lastUsed = connection.getLastUsed();
                    currentTime = System.currentTimeMillis();
                    if (currentTime - lastUsed >= 3600000L) {
                        connection.close();
                        this.openConnections.remove(destUrl);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("HttpClientConnectionGC removes unused connection to " + destUrl));
                        }
                    }
                }
            }
            catch (Exception ez1) {
                // empty catch block
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"HttpClientConnectionGC completed.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HttpClientConnectionGCDelay = 3600000L;
    }

    public class HttpClientConnectionGCTask
    extends TimerTask {
        HttpClientMessageSender sender = null;

        public HttpClientConnectionGCTask(HttpClientMessageSender sender) {
            this.sender = sender;
        }

        public void run() {
            this.sender.httpConnectionGC();
        }
    }
}

