/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpClientConnection
implements EndpointMessenger,
Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection = HttpClientConnection.class$("net.jxta.impl.endpoint.servlethttp.HttpClientConnection")) : class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection).getName());
    public static final int MaxNbOfMessages = 40;
    private URL url = null;
    private boolean waiting = false;
    private long lastUsed = 0L;
    private Thread thread = null;
    private EndpointReceiveQueue queue = null;
    private long nbOfMessagesSent = 0L;
    private static final MimeMediaType msgType;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection;

    public HttpClientConnection(URL url) {
        this.url = url;
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.thread != null) {
                try {
                    this.thread.setName("HTTP Connection to " + this.url.toString() + " [" + this.queue.getNbOfQueuedMessages() + ", " + this.nbOfMessagesSent + " ]");
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)ez1);
                }
            }
        }
    }

    private void doSendMessage(Message msg) throws IOException {
        HttpURLConnection urlConn = (HttpURLConnection)this.url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setRequestMethod("POST");
        urlConn.connect();
        BufferedOutputStream out = new BufferedOutputStream(urlConn.getOutputStream());
        out.flush();
        MessageWireFormatFactory.newMessageWireFormat(msgType).writeMessage(out, msg);
        out.flush();
        out.close();
        int code = urlConn.getResponseCode();
        if (code != 200) {
            throw new IOException("Message not accepted: HTTP status code=" + code + " reason=" + urlConn.getResponseMessage());
        }
        ++this.nbOfMessagesSent;
        this.setThreadName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message msg) throws IOException {
        this.connect();
        HttpClientConnection httpClientConnection = this;
        synchronized (httpClientConnection) {
            this.queue.push(msg);
        }
        this.setThreadName();
        Thread.yield();
    }

    public void run() {
        Message msg = null;
        while (true) {
            try {
                msg = this.queue.waitForMessage();
                this.setThreadName();
                this.doSendMessage(msg);
            }
            catch (InterruptedException ez1) {
                this.thread = null;
                return;
            }
            catch (IOException ez2) {
                this.notifyFailure();
                this.thread = null;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        HttpClientConnection httpClientConnection = this;
        synchronized (httpClientConnection) {
            if (this.queue == null) {
                this.queue = new EndpointReceiveQueue();
                this.queue.setMaxNbOfMessages(40);
            }
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread((Runnable)this, "HTTP Connection to " + this.url.toString() + " [Unused]");
            this.thread.start();
        }
        Thread.yield();
    }

    private synchronized void notifyFailure() {
        this.close();
    }

    public synchronized void close() {
        block4: {
            if (this.queue != null) {
                this.queue.close();
                this.queue = null;
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread = null;
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot interrupt thread for " + this.url.toString()), (Throwable)ez1);
                }
            }
        }
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized void setLastUsed(long time) {
        this.lastUsed = time;
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MaxNbOfMessages = 40;
        msgType = new MimeMediaType("application/x-jxta-msg");
    }
}

