/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.TextElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class AdvertisementCompactor
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$discovery$AdvertisementCompactor == null ? (class$net$jxta$impl$discovery$AdvertisementCompactor = AdvertisementCompactor.class$("net.jxta.impl.discovery.AdvertisementCompactor")) : class$net$jxta$impl$discovery$AdvertisementCompactor).getName());
    private PeerGroup myGroup;
    private int nap = 600000;
    private DiscoveryService discovery = null;
    private Hashtable table;
    private Thread myThread = null;
    private boolean stopping = false;
    static /* synthetic */ Class class$net$jxta$impl$discovery$AdvertisementCompactor;

    public AdvertisementCompactor(PeerGroup pg) {
        this.myGroup = pg;
    }

    public void init() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Start AdvertisementCompactor");
        }
        this.myThread = new Thread((Runnable)new AdvertisementCompactor(this.myGroup), "DiscoveryServiceImpl:AdvertisementCompactor");
        this.myThread.start();
    }

    public void shutdown() {
        this.stopping = true;
        this.myThread.interrupt();
        this.myThread = null;
    }

    public void run() {
        try {
            while (true) {
                if (this.stopping) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Compactor thread returns.");
                    }
                    return;
                }
                this.discovery = this.myGroup.getDiscoveryService();
                if (this.discovery != null) break;
                this.doze(this.nap);
            }
            while (true) {
                block17: {
                    if (this.stopping) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Compactor thread returns.");
                        }
                        return;
                    }
                    this.table = new Hashtable(128);
                    try {
                        Enumeration peers = this.discovery.getLocalAdvertisements(0, null, null);
                        while (null != peers && peers.hasMoreElements()) {
                            PeerAdvertisement padv = (PeerAdvertisement)peers.nextElement();
                            if (padv.getPeerID().equals(this.myGroup.getPeerID())) continue;
                            TextElement e = (TextElement)((Object)padv.getServiceParam(PeerGroup.endpointClassID));
                            Enumeration addresses = e != null ? e.getChildren("Addr") : new Vector().elements();
                            if (!addresses.hasMoreElements()) {
                                this.discovery.flushAdvertisements(padv.getPeerID().toString(), 0);
                                continue;
                            }
                            String addr = ((TextElement)addresses.nextElement()).getTextValue();
                            if (this.table.get(addr) == null) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)("adding :" + addr));
                                }
                                this.table.put(addr, padv.getPeerID());
                                continue;
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("duplicate found :" + addr));
                            }
                            this.discovery.flushAdvertisements(padv.getPeerID().toString(), 0);
                            if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                            LOG.debug((Object)("ejecting :" + padv.getPeerID()));
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block17;
                        LOG.debug((Object)e);
                    }
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"AdvertisementCompactor Done");
                }
                this.doze(this.nap);
            }
        }
        catch (Throwable all) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
            return;
        }
    }

    private void doze(int period) {
        try {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("AdvertisementCompactor hibernating for:" + period / 1000 / 60 + " min"));
            }
            Thread.sleep(period);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

