/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.config.CodeDescriptor;
import net.jxta.impl.config.ConfigUtil;
import net.jxta.impl.config.ConfigurationException;
import net.jxta.impl.config.HttpConfig;
import net.jxta.impl.config.TcpConfig;
import net.jxta.impl.endpoint.Address;

public class Config {
    private Hashtable mServiceCodeDescriptors = new Hashtable();
    private CodeDescriptor mInitialPlatform;
    private CodeDescriptor mInitialApp;
    private TcpConfig mTcpConfig = null;
    private HttpConfig mHttpConfig = null;
    private Vector mRendezvousPeers = new Vector();
    private boolean mIsRouter;
    private boolean mIsRendezvous;
    private boolean mShouldPropagate;
    public static final String SERVICE_DISCOVERY = "DiscoveryService";
    public static final String SERVICE_MEMBERSHIP = "MembershipService";
    public static final String SERVICE_PIPE = "PipeService";
    public static final String SERVICE_PEERINFO = "PeerInfoService";
    public static final String SERVICE_RESOLVER = "ResolverService";
    private static final String[] SERVICE_KEYS;
    private static final String JXTA_CODEBASE = "http://www.jxta.org/download/jxta.jar";
    public static final String JXTA_HOME;

    public static Config createDefaultConfig() {
        try {
            Config conf = new Config();
            conf.setServiceImplDescriptor(SERVICE_DISCOVERY, new CodeDescriptor("net.jxta.impl.discovery.DiscoveryService", JXTA_CODEBASE));
            conf.setServiceImplDescriptor(SERVICE_PIPE, new CodeDescriptor("net.jxta.impl.pipe.PipeService", JXTA_CODEBASE));
            conf.setServiceImplDescriptor(SERVICE_PEERINFO, new CodeDescriptor("net.jxta.impl.peer.PeerInfoService", JXTA_CODEBASE));
            conf.setServiceImplDescriptor(SERVICE_RESOLVER, new CodeDescriptor("net.jxta.impl.resolver.ResolverService", JXTA_CODEBASE));
            conf.setServiceImplDescriptor(SERVICE_MEMBERSHIP, new CodeDescriptor("net.jxta.impl.membership.NullMembershipService", JXTA_CODEBASE));
            conf.setRendezvous(false);
            conf.addRendezvousPeer(new Address("tcp://129.144.36.190:6001"));
            conf.addRendezvousPeer(new Address("tcp://jxta.dioxine.net:6001"));
            conf.addRendezvousPeer(new Address("http://jxta.dioxine.net:6002"));
            conf.setShouldPropagate(false);
            conf.setTcpConfig(TcpConfig.createDefaultConfig());
            conf.setHttpConfig(HttpConfig.createDefaultConfig());
            conf.setInitialPlatform(new CodeDescriptor("net.jxta.impl.peergroup.StartNetPeerGroup", JXTA_CODEBASE));
            conf.setInitialApp(new CodeDescriptor("net.jxta.impl.shell.bin.Shell.Shell", JXTA_CODEBASE));
            return conf;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Fatal error with default config");
        }
    }

    public CodeDescriptor getServiceImplDescriptor(String aServiceKey) {
        return (CodeDescriptor)this.mServiceCodeDescriptors.get(aServiceKey);
    }

    public void setServiceImplDescriptor(String aServiceKey, CodeDescriptor aDescriptor) throws ConfigurationException {
        try {
            this.mServiceCodeDescriptors.put(aServiceKey, aDescriptor);
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Null service key provided", e);
        }
    }

    public boolean isRendezvous() {
        return this.mIsRendezvous;
    }

    public void setRendezvous(boolean aIsRendezvous) {
        this.mIsRendezvous = aIsRendezvous;
    }

    public boolean isRouter() {
        return this.mIsRouter;
    }

    public void setRouter(boolean aIsRouter) {
        this.mIsRouter = aIsRouter;
    }

    public TcpConfig getTcpConfig() {
        return this.mTcpConfig;
    }

    public void setTcpConfig(TcpConfig aConfig) {
        this.mTcpConfig = aConfig;
    }

    public HttpConfig getHttpConfig() {
        return this.mHttpConfig;
    }

    public void setHttpConfig(HttpConfig aConfig) {
        this.mHttpConfig = aConfig;
    }

    public CodeDescriptor getInitialPlatform() {
        return this.mInitialPlatform;
    }

    public void setInitialPlatform(CodeDescriptor aInitialPlatform) {
        this.mInitialPlatform = aInitialPlatform;
    }

    public CodeDescriptor getInitialApp() {
        return this.mInitialApp;
    }

    public void setInitialApp(CodeDescriptor aInitialApp) {
        this.mInitialApp = aInitialApp;
    }

    public void addRendezvousPeer(EndpointAddress address) {
        this.mRendezvousPeers.addElement(address);
    }

    public Enumeration getRendezvousPeers() {
        return this.mRendezvousPeers.elements();
    }

    public void clearRendezvousPeers() {
        this.mRendezvousPeers = new Vector();
    }

    public boolean getShouldPropagate() {
        return this.mShouldPropagate;
    }

    public void setShouldPropagate(boolean aShouldPropagate) {
        this.mShouldPropagate = aShouldPropagate;
    }

    public static Config read(InputStream aInStream) throws ConfigurationException {
        try {
            Config config = new Config();
            StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), aInStream);
            config.readConfig(doc);
            return config;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Fatal error reading configuration file", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readConfig(StructuredTextDocument doc) throws ConfigurationException {
        elements = doc.getChildren();
        if (elements != null && elements.hasMoreElements()) ** GOTO lbl6
        throw new ConfigurationException("Configuration file is empty or corrupted");
lbl-1000:
        // 1 sources

        {
            element = (TextElement)elements.nextElement();
            this.readElement(element);
lbl6:
            // 2 sources

            ** while (elements.hasMoreElements())
        }
lbl7:
        // 1 sources

    }

    private void readElement(TextElement e) throws ConfigurationException {
        String elname = e.getName();
        if (elname.equals("IsRouter")) {
            this.mIsRouter = new Boolean(e.getTextValue());
        } else if (elname.equals("IsRendezvous")) {
            this.mIsRendezvous = Boolean.valueOf(e.getTextValue());
        } else if (elname.equals("RendezvousPeers")) {
            this.readRendezvousPeers(e);
        } else if (elname.equals("Services")) {
            this.readServices(e);
        } else if (elname.equals("InitialPlatform")) {
            this.readInitPlatform(e);
        } else if (elname.equals("InitialApp")) {
            this.readInitApp(e);
        } else if (elname.equals("TCP")) {
            this.readTcp(e);
        } else if (elname.equals("HTTP")) {
            this.readHttp(e);
        } else if (elname.equals("ShouldPropagate")) {
            this.mShouldPropagate = Boolean.valueOf(e.getTextValue());
        } else {
            System.err.println("Unknown element seen during config read: " + elname);
        }
    }

    private void readServices(TextElement e) throws ConfigurationException {
        Enumeration services = e.getChildren();
        if (services != null) {
            while (services.hasMoreElements()) {
                TextElement service = (TextElement)services.nextElement();
                if (service == null) continue;
                String servicename = service.getName();
                CodeDescriptor cd = CodeDescriptor.newFromXML(service);
                if (cd == null) continue;
                this.setServiceImplDescriptor(servicename, cd);
            }
        }
    }

    private void readRendezvousPeers(TextElement e) throws ConfigurationException {
        Enumeration peers = e.getChildren();
        if (peers != null) {
            while (peers.hasMoreElements()) {
                TextElement peer = (TextElement)peers.nextElement();
                this.addRendezvousPeer(new Address(peer.getTextValue()));
            }
        }
    }

    private void readInitPlatform(TextElement e) {
        this.mInitialPlatform = CodeDescriptor.newFromXML(e);
    }

    private void readInitApp(TextElement e) {
        this.mInitialApp = CodeDescriptor.newFromXML(e);
    }

    private void readHttp(TextElement e) {
        this.mHttpConfig = HttpConfig.newFromXML(e);
    }

    private void readTcp(TextElement e) {
        this.mTcpConfig = TcpConfig.newFromXML(e);
    }

    public void write(Writer aWriter) throws ConfigurationException {
        try {
            StructuredTextDocument doc = null;
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:config");
            this.writeConfig(doc);
            doc.sendToWriter(aWriter);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException("Fatal error during configuration write.", e);
        }
    }

    private void writeConfig(StructuredTextDocument doc) throws ConfigurationException {
        if (this.mHttpConfig != null) {
            this.mHttpConfig.writeToXML(doc);
        }
        if (this.mTcpConfig != null) {
            this.mTcpConfig.writeToXML(doc);
        }
        TextElement e = null;
        e = doc.createElement("IsRouter", new Boolean(this.mIsRouter).toString());
        doc.appendChild((Element)e);
        this.writeRendezvousServer(doc);
        doc.appendChild(doc.createElement("ShouldPropagate", String.valueOf(this.mShouldPropagate)));
        this.writeServices(doc, this.mServiceCodeDescriptors);
        e = doc.createElement("InitialApp");
        doc.appendChild((Element)e);
        this.getInitialApp().writeToXML(doc, e);
        e = doc.createElement("InitialPlatform");
        doc.appendChild((Element)e);
        this.getInitialPlatform().writeToXML(doc, e);
    }

    private void writeRendezvousServer(StructuredTextDocument doc) {
        this.writeRendezvousPeers(doc, this.getRendezvousPeers());
        doc.appendChild(doc.createElement("IsRendezvous", new Boolean(this.isRendezvous()).toString()));
    }

    private void writeRendezvousPeers(StructuredTextDocument doc, Enumeration peers) {
        TextElement peersElement = doc.createElement("RendezvousPeers");
        doc.appendChild((Element)peersElement);
        while (peers.hasMoreElements()) {
            EndpointAddress addr = (EndpointAddress)peers.nextElement();
            ConfigUtil.writeAddress(doc, peersElement, addr, "RendezvousPeer");
        }
    }

    private void writeServices(StructuredTextDocument doc, Hashtable aServiceCodeDescriptors) throws ConfigurationException {
        TextElement services = doc.createElement("Services");
        doc.appendChild((Element)services);
        int i = 0;
        while (i < SERVICE_KEYS.length) {
            CodeDescriptor desc = (CodeDescriptor)aServiceCodeDescriptors.get(SERVICE_KEYS[i]);
            if (desc == null) {
                throw new ConfigurationException("Service " + SERVICE_KEYS[i] + " not configured");
            }
            TextElement service = doc.createElement(SERVICE_KEYS[i]);
            services.appendChild((Element)service);
            desc.writeToXML(doc, service);
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        Config c = Config.createDefaultConfig();
        File firstfile = new File("first.xml");
        File secondfile = new File("second.xml");
        FileWriter firstwriter = new FileWriter(firstfile);
        FileWriter secondwriter = new FileWriter(secondfile);
        try {
            c.write(firstwriter);
            firstwriter.close();
            Config c2 = Config.read(new FileInputStream(firstfile));
            c2.write(secondwriter);
            secondwriter.close();
        }
        catch (ConfigurationException e) {
            System.err.println(e);
            e.getNestedException().printStackTrace();
            e.printStackTrace();
        }
    }

    static {
        SERVICE_DISCOVERY = SERVICE_DISCOVERY;
        SERVICE_MEMBERSHIP = SERVICE_MEMBERSHIP;
        SERVICE_PIPE = SERVICE_PIPE;
        SERVICE_PEERINFO = SERVICE_PEERINFO;
        SERVICE_RESOLVER = SERVICE_RESOLVER;
        SERVICE_KEYS = new String[]{SERVICE_DISCOVERY, SERVICE_MEMBERSHIP, SERVICE_PIPE, SERVICE_PEERINFO, SERVICE_RESOLVER};
        JXTA_CODEBASE = JXTA_CODEBASE;
        JXTA_HOME = System.getProperty("JXTA_HOME", ".jxta/");
    }
}

