/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.cm.CmCache;
import net.jxta.impl.cm.CmIndexerThread;
import net.jxta.impl.cm.FileExpirationService;
import net.jxta.impl.cm.SchedulerService;
import net.jxta.impl.config.Config;
import net.jxta.impl.index.IndexServiceImpl;
import net.jxta.index.IndexService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class Cm {
    public static final String RootDirBase = Config.JXTA_HOME + "cm";
    public static final String PublicDirName = "public";
    public static final String PrivateDirName = "private";
    public static final String TmpDirName = "tmp";
    private static final Category LOG;
    private static final Random random;
    protected static final IndexService indexService;
    protected static final SchedulerService schedulerService;
    protected Hashtable indexes;
    protected Hashtable caches;
    protected File rootDir;
    private FileExpirationService expirer;
    private String INDEXFILENAME;
    private static final int RAW = 0;
    private static final int CACHE = 1;
    private static final int INDEX = 2;
    private int searchMethod;
    private String[] searchType;
    ExpirationListener expireListener;
    static /* synthetic */ Class class$net$jxta$impl$cm$Cm;

    public Cm(String areaName, boolean enableOptimize) {
        this(areaName, new ExpirationListener(){

            public boolean expired(File file) {
                return true;
            }
        }, enableOptimize);
    }

    public Cm(String areaName, ExpirationListener listener, boolean enableOptimize) {
        block26: {
            this.indexes = new Hashtable(4);
            this.caches = new Hashtable(4);
            this.INDEXFILENAME = "cm.idx";
            this.searchMethod = 0;
            this.searchType = new String[]{"RAW", "CACHE", "INDEX"};
            try {
                ResourceBundle cmRsrc = ResourceBundle.getBundle("net.jxta.user");
                String str = cmRsrc.getString("impl.cm.searchMethod").trim();
                if (str.equals("RAW")) {
                    this.searchMethod = 0;
                } else if (str.equals("CACHE")) {
                    this.searchMethod = 1;
                } else if (str.equals("INDEX")) {
                    this.searchMethod = 2;
                }
            }
            catch (MissingResourceException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block26;
                LOG.warn((Object)"cm search method preference resource not found", (Throwable)e);
            }
        }
        if (!enableOptimize) {
            this.searchMethod = 0;
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Forcing search method to : RAW");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Initializaing with search method : " + this.searchType[this.searchMethod]));
        }
        this.expireListener = listener;
        try {
            File base = new File(RootDirBase);
            File[] docDirs = new File[3];
            FileExpirationService.ExpirationListener expiryNotice = null;
            this.rootDir = new File(base, areaName);
            this.rootDir = new File(this.rootDir.getCanonicalPath());
            switch (this.searchMethod) {
                case 2: {
                    try {
                        expiryNotice = new FileExpirationService.ExpirationListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Loose catch block
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public boolean expired(File f) {
                                FileInputStream in;
                                block20: {
                                    boolean needsDelete = Cm.this.expireListener.expired(f);
                                    if (!needsDelete) {
                                        return needsDelete;
                                    }
                                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                                        LOG.debug((Object)(" removing " + f + " from index."));
                                    }
                                    IndexService.Index index = (IndexService.Index)Cm.this.indexes.get(new File(f.getParent()).getName());
                                    in = null;
                                    in = new FileInputStream(f);
                                    if (index == null) break block20;
                                    index.remove(f.getName(), in);
                                }
                                Object var10_5 = null;
                                if (in == null) return true;
                                try {
                                    ((InputStream)in).close();
                                    return true;
                                }
                                catch (IOException e2) {}
                                return true;
                                {
                                    catch (NullPointerException e) {
                                        if (LOG.isEnabledFor(Priority.WARN)) {
                                            LOG.warn((Object)"NPE ", (Throwable)e);
                                        }
                                        Object var10_6 = null;
                                        if (in == null) return true;
                                        try {
                                            ((InputStream)in).close();
                                            return true;
                                        }
                                        catch (IOException e2) {}
                                        return true;
                                    }
                                    catch (IOException e) {
                                        if (LOG.isEnabledFor(Priority.WARN)) {
                                            LOG.warn((Object)"IO Exception ", (Throwable)e);
                                        }
                                        Object var10_7 = null;
                                        if (in == null) return true;
                                        try {
                                            ((InputStream)in).close();
                                            return true;
                                        }
                                        catch (IOException e2) {}
                                        return true;
                                    }
                                    catch (IndexService.BadDocumentException e) {
                                        if (LOG.isEnabledFor(Priority.WARN)) {
                                            LOG.warn((Object)"bad doc ", (Throwable)e);
                                        }
                                        Object var10_8 = null;
                                        if (in == null) return true;
                                        try {
                                            ((InputStream)in).close();
                                            return true;
                                        }
                                        catch (IOException e2) {}
                                        return true;
                                    }
                                    catch (IndexService.IndexException e) {
                                        if (LOG.isEnabledFor(Priority.WARN)) {
                                            LOG.warn((Object)"Index Error ", (Throwable)e);
                                        }
                                        Object var10_9 = null;
                                        if (in == null) return true;
                                        try {
                                            ((InputStream)in).close();
                                            return true;
                                        }
                                        catch (IOException e2) {}
                                        return true;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var10_10 = null;
                                    if (in == null) throw throwable;
                                    try {
                                        ((InputStream)in).close();
                                        throw throwable;
                                    }
                                    catch (IOException e2) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        };
                    }
                    catch (Exception failed) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Initialize of INDEX failed, using RAW");
                        }
                        this.searchMethod = 0;
                        enableOptimize = false;
                    }
                    break;
                }
                case 1: {
                    try {
                        expiryNotice = new FileExpirationService.ExpirationListener(){

                            public boolean expired(File f) {
                                CmCache cmc;
                                boolean needsDelete = Cm.this.expireListener.expired(f);
                                if (!needsDelete) {
                                    return needsDelete;
                                }
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)(" removing " + f + " from cache."));
                                }
                                if (null != (cmc = (CmCache)Cm.this.caches.get(new File(f.getParent()).getName()))) {
                                    cmc.remove(f.getName());
                                }
                                return true;
                            }
                        };
                    }
                    catch (Exception failed) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Initialize of CACHE failed, using RAW");
                        }
                        this.searchMethod = 0;
                        enableOptimize = false;
                    }
                    break;
                }
            }
            if (null == expiryNotice) {
                expiryNotice = new FileExpirationService.ExpirationListener(){

                    public boolean expired(File f) {
                        boolean needsDelete = Cm.this.expireListener.expired(f);
                        return needsDelete;
                    }
                };
            }
            docDirs[0] = this.initDir(TmpDirName);
            docDirs[1] = this.initDir(PrivateDirName);
            docDirs[2] = this.initDir(PublicDirName);
            this.expirer = new FileExpirationService(schedulerService, this.rootDir, expiryNotice);
            if (this.searchMethod == 2) {
                new Thread((Runnable)new CmIndexerThread(docDirs, new IndexService.Index[]{(IndexService.Index)this.indexes.get(TmpDirName), (IndexService.Index)this.indexes.get(PrivateDirName), (IndexService.Index)this.indexes.get(PublicDirName)}), "CmIndexerThread :" + areaName).start();
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Unable to create Cm", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String createTmpName(StructuredDocument doc) {
        int hash = 0;
        try {
            StringWriter out = new StringWriter();
            ((StructuredTextDocument)doc).sendToWriter(out);
            hash = out.toString().hashCode();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "cm" + Integer.toString(hash);
    }

    public long getPublicationLifetime(String dn, String fn) {
        File file = this.getFile(dn, fn);
        return this.expirer.getPublicationLifetime(file);
    }

    public long getCacheLifetime(String dn, String fn) {
        File file = this.getFile(dn, fn);
        return this.expirer.getCacheLifetime(file);
    }

    public String[] getFileNames(String dn) {
        if (dn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"null directory name");
            }
            return null;
        }
        File dir = new File(this.rootDir, dn);
        return dir.list();
    }

    public String getOldestFile(String dn) {
        if (dn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"null directory name");
            }
            return null;
        }
        try {
            File dir = new File(this.rootDir, dn);
            File[] list = dir.listFiles();
            if (list == null || list.length == 0) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"no files in folder");
                }
                return null;
            }
            long oldestTime = list[0].lastModified();
            File oldest = list[0];
            File file = null;
            long time = 0L;
            int i = 1;
            while (i < list.length) {
                file = list[i];
                time = file.lastModified();
                if (time < oldestTime) {
                    oldest = list[i];
                    oldestTime = time;
                }
                ++i;
            }
            return oldest.getName();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.debug((Object)"Failure determining oldest file", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isFolder(String dn) {
        if (dn == null) {
            return false;
        }
        File dir = new File(this.rootDir, dn);
        return dir.exists() && dir.isDirectory();
    }

    public FileInputStream getInputStream(String dn, String fn) throws IOException {
        return new FileInputStream(this.getFile(dn, fn));
    }

    private File initDir(String dirName) throws IOException {
        File dir;
        block5: {
            dir = new File(this.rootDir, dirName);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Cm cannot create directory " + dir);
            }
            if (this.searchMethod == 2 && !this.indexes.containsKey(dirName)) {
                try {
                    File newIndex = new File(dir.getAbsolutePath(), this.INDEXFILENAME);
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Creating index for" + dir.getPath()));
                    }
                    this.expirer.scheduleFileExpiration(newIndex, Long.MAX_VALUE, Long.MAX_VALUE);
                    this.indexes.put(dirName, indexService.getIndex(newIndex));
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block5;
                    LOG.warn((Object)"Failed to create index ", (Throwable)e);
                }
            }
        }
        return dir;
    }

    public void createFolder(String f) throws IOException {
        this.createFolder(f, null);
    }

    public synchronized void createFolder(String f, String[] elements) throws IOException {
        File dir = this.initDir(f);
        switch (this.searchMethod) {
            case 2: {
                if (this.indexes.get(f) != null) break;
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Creating indexer threads with null index");
                }
                new Thread((Runnable)new CmIndexerThread(new File[]{dir}, new IndexService.Index[]{(IndexService.Index)this.indexes.get(f)}), "CmIndexerThread: " + f).start();
                break;
            }
            case 1: {
                if (elements == null || this.caches.get(f) != null) break;
                CmCache cmc = new CmCache(elements, dir);
                this.caches.put(f, cmc);
                new Thread((Runnable)cmc, f + " CmCache ").start();
                break;
            }
        }
    }

    public String createTmpName(String dn) {
        String tryName;
        File dir = new File(this.rootDir, dn);
        while (new File(dir, tryName = "cm" + Integer.toString(random.nextInt())).exists()) {
        }
        return tryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void remove(String dn, String fn) throws IOException {
        file = this.getFile(dn, fn);
        try {
            block22: {
                if (this.searchMethod == 2) {
                    is = null;
                    try {
                        is = new FileInputStream(file);
                        ((IndexService.Index)this.indexes.get(dn)).remove(fn, is);
                        var8_5 = null;
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var7_15) {
                        var8_8 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var7_15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block22;
                        catch (IndexService.BadDocumentException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"bad file ", (Throwable)e);
                            }
                            var8_6 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block22;
                        }
                        catch (IndexService.IndexException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index Exception", (Throwable)e);
                            }
                            var8_7 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block22;
                        }
                    }
                }
                if (this.searchMethod == 1) {
                    ((CmCache)this.caches.get(dn)).remove(fn);
                }
            }
            this.expirer.cancelFileExpiration(file);
            var11_16 = null;
            ** if (!file.exists() || file.delete()) goto lbl-1000
        }
        catch (Throwable var10_18) {
            var11_17 = null;
            if (file.exists() && !file.delete()) {
                throw new IOException("Cm cannot remove the file " + file);
            }
            throw var10_18;
        }
lbl-1000:
        // 1 sources

        {
            throw new IOException("Cm cannot remove the file " + file);
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    public boolean exists(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        return file.exists();
    }

    public StructuredDocument restore(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        return this.restoreFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] restoreBytes(String dn, String fn) throws IOException {
        block9: {
            file = this.getFile(dn, fn);
            ip = null;
            buffer = null;
            try {
                ip = new FileInputStream(file);
                size = (int)file.length();
                buffer = new byte[size];
                got = 0;
                while (true) {
                    if (got >= size) {
                        break block9;
                    }
                    res = ip.read(buffer, got, size - got);
                    if (-1 == res) {
                        ip.close();
                        var9_9 = null;
                        var11_10 = null;
                        if (ip == null) return var9_9;
                        break;
                    }
                    got += res;
                }
            }
            catch (Throwable var10_16) {
                var11_12 = null;
                if (ip == null) throw var10_16;
                try {
                    ip.close();
                    throw var10_16;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw var10_16;
            }
            ** try [egrp 1[TRYBLOCK] [3 : 113->121)] { 
lbl35:
            // 1 sources

            ip.close();
            return var9_9;
lbl37:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var9_9;
        }
        var11_11 = null;
        if (ip == null) return buffer;
        try {}
        catch (IOException ignored) {
            return buffer;
        }
        ip.close();
        return buffer;
    }

    public void save(String dn, String fn, StructuredDocument doc) throws IOException {
        this.save(dn, fn, doc, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void save(String dn, String fn, StructuredDocument doc, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        block38: {
            block36: {
                file = this.getFile(dn, fn);
                if (this.searchMethod == 2 && file.exists()) {
                    in = null;
                    try {
                        in = new FileInputStream(file);
                        ((IndexService.Index)this.indexes.get(dn)).remove(fn, in);
                        var13_8 = null;
                        ** if (in == null) goto lbl-1000
                    }
                    catch (Throwable var12_21) {
                        var13_11 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var12_21;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block36;
                        catch (IndexService.BadDocumentException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : Bad Document", (Throwable)e);
                            }
                            var13_9 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                            break block36;
                        }
                        catch (IndexService.IndexException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : Index Exception", (Throwable)e);
                            }
                            var13_10 = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
            }
            op = null;
            try {
                block37: {
                    this.expirer.scheduleFileExpiration(file, timeoutInMyCache, timeoutForOthers);
                    op = new FileOutputStream(file);
                    doc.sendToStream(op);
                    op.close();
                    op = null;
                    if (this.searchMethod == 2) {
                        try {
                            if (Cm.LOG.isDebugEnabled() && Cm.LOG.isEnabledFor(Priority.DEBUG)) {
                                Cm.LOG.debug((Object)("indexing " + file + ": " + dn + " " + fn));
                            }
                            ((IndexService.Index)this.indexes.get(dn)).add(fn, doc.getStream());
                            break block37;
                        }
                        catch (IOException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : IO Exception", (Throwable)e);
                            }
                            throw e;
                        }
                        catch (IndexService.BadDocumentException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Save failed", (Throwable)e);
                            }
                            break block37;
                        }
                        catch (IndexService.IndexException e) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Save failed", (Throwable)e);
                            }
                            break block37;
                        }
                    }
                    if (this.searchMethod != 1) break block37;
                    ((CmCache)this.caches.get(dn)).add(fn, doc);
                }
                var16_23 = null;
                ** if (op == null) goto lbl-1000
            }
            catch (Throwable var15_27) {
                var16_24 = null;
                if (op != null) {
                    try {
                        op.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var15_27;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    op.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block38;
                catch (IOException e) {
                    if (Cm.LOG.isEnabledFor(Priority.DEBUG)) {
                        Cm.LOG.debug((Object)"Cm cannot write doc", (Throwable)e);
                    }
                    throw e;
                }
            }
        }
    }

    public void saveBytes(String dn, String fn, InputStream source) throws IOException {
        this.saveBytes(dn, fn, source, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    /*
     * Loose catch block
     */
    public void saveBytes(String dn, String fn, InputStream source, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        block26: {
            IOException e32;
            FileOutputStream op;
            block25: {
                block24: {
                    File file = this.getFile(dn, fn);
                    op = null;
                    this.expirer.scheduleFileExpiration(file, timeoutInMyCache, timeoutForOthers);
                    op = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int res;
                        if ((res = source.read(buffer)) == 0) {
                            continue;
                        }
                        if (res == -1) break;
                        op.write(buffer, 0, res);
                    }
                    op.flush();
                    op.close();
                    op = null;
                    source.close();
                    source = new FileInputStream(file);
                    if (this.searchMethod == 2) {
                        try {
                            ((IndexService.Index)this.indexes.get(dn)).add(fn, source);
                        }
                        catch (IOException e2) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : IO Exception", (Throwable)e2);
                            }
                            break block24;
                        }
                        catch (IndexService.BadDocumentException bde) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : Bad Document", (Throwable)bde);
                            }
                            break block24;
                        }
                        catch (IndexService.IndexException ie) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : Index Error", (Throwable)ie);
                            }
                            break block24;
                        }
                    }
                    if (this.searchMethod != 1) break block24;
                    ((CmCache)this.caches.get(dn)).add(fn);
                }
                Object var15_14 = null;
                if (source == null) break block25;
                try {
                    source.close();
                    source = null;
                }
                catch (IOException e32) {
                    // empty catch block
                }
            }
            if (op != null) {
                try {
                    op.close();
                    op = null;
                }
                catch (IOException e32) {}
            }
            break block26;
            {
                catch (IOException e4) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Cm cannot write doc", (Throwable)e4);
                    }
                    throw e4;
                }
            }
            catch (Throwable throwable) {
                IOException e32;
                Object var15_15 = null;
                if (source != null) {
                    try {
                        source.close();
                        source = null;
                    }
                    catch (IOException e32) {
                        // empty catch block
                    }
                }
                if (op != null) {
                    try {
                        op.close();
                        op = null;
                    }
                    catch (IOException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean cleanupFolder(String dn) throws IOException {
        boolean deleted = true;
        if (null == dn) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"cleanupFolder : dir cannot be null");
            }
            throw new IllegalArgumentException("dir cannot be null");
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)(" cleaning up " + dn));
        }
        File dir = new File(this.rootDir, dn);
        String[] files = this.getFileNames(dn);
        int i = 0;
        while (files != null && i < files.length) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                deleted &= this.cleanupFolder(file.getPath());
            } else {
                this.expirer.cancelFileExpiration(file);
            }
            if (file.exists()) {
                deleted &= file.delete();
            }
            ++i;
        }
        if (!deleted && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)("failed removing : " + dir.getCanonicalPath()));
        }
        return deleted;
    }

    public Enumeration search(String dn, String tag, String value) {
        CmCache cmc;
        if (null == tag || tag.length() == 0) {
            throw new IllegalArgumentException("tag must be non-null and non-empty");
        }
        if (null == value || value.length() == 0) {
            throw new IllegalArgumentException("value must be non-null and non-empty");
        }
        Vector<String> res = new Vector<String>();
        if (this.searchMethod == 2 && value.indexOf("*") == -1) {
            String[] files = this.searchIndex(dn, tag, value);
            if (files == null || files.length == 0) {
                return res.elements();
            }
            int i = 0;
            while (i < files.length) {
                if (null != files[i]) {
                    res.addElement(files[i]);
                } else if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"There was a null element in the index results");
                }
                ++i;
            }
            return res.elements();
        }
        if (this.searchMethod == 1 && (cmc = (CmCache)this.caches.get(dn)).containsKey(tag)) {
            return cmc.query(tag, value);
        }
        String[] files = this.getFileNames(dn);
        if (files == null) {
            return res.elements();
        }
        int i = 0;
        while (i < files.length) {
            if (this.searchFile(dn, files[i], tag, value)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found a hit " + files[i]));
                }
                res.addElement(files[i]);
            }
            ++i;
        }
        return res.elements();
    }

    File getFile(String dn, String fn) {
        File d = new File(this.rootDir, dn);
        if (!d.exists()) {
            d.mkdirs();
        }
        return new File(d, fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StructuredDocument restoreFile(File file) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("restore document from " + file));
        }
        FileInputStream ip = null;
        StructuredDocument doc = null;
        try {
            ip = new FileInputStream(file);
            doc = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), ip);
            Object var5_4 = null;
            if (ip == null) return doc;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ip == null) throw throwable;
            try {
                ((InputStream)ip).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)ip).close();
            return doc;
        }
        catch (IOException e) {}
        return doc;
    }

    private String[] searchIndex(String dn, String tag, String value) {
        block6: {
            if (this.searchMethod != 2) {
                return null;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Looking for " + tag + " = " + value + " in " + dn + "Rootdir = " + this.rootDir.toString()));
            }
            String query = "//[" + tag + "='" + value + "']";
            try {
                IndexService.Index index = (IndexService.Index)this.indexes.get(dn);
                String[] results = index.query(query);
                return results;
            }
            catch (IndexService.BadQueryException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"bad query expression ", (Throwable)e);
                }
            }
            catch (IndexService.IndexException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                LOG.warn((Object)"bad index", (Throwable)e);
            }
        }
        return null;
    }

    private synchronized void indexFile(String dirname, String name, StructuredDocument doc) {
        block7: {
            if (this.searchMethod != 2) {
                return;
            }
            try {
                ((IndexService.Index)this.indexes.get(dirname)).add(name, doc.getStream());
            }
            catch (IndexService.BadDocumentException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Index : Bad Document", (Throwable)e);
                }
            }
            catch (IndexService.IndexException e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Index : Index Exception", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block7;
                LOG.warn((Object)"Index : IO Failure", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchFile(String dn, String fn, String tag, String value) {
        if (null == tag) throw new IllegalArgumentException("tag must be non-null and non-empty");
        if (tag.length() == 0) {
            throw new IllegalArgumentException("tag must be non-null and non-empty");
        }
        if (null == value) throw new IllegalArgumentException("value must be non-null and non-empty");
        if (value.length() == 0) {
            throw new IllegalArgumentException("value must be non-null and non-empty");
        }
        value = value.toUpperCase();
        boolean startswith = false;
        boolean endswith = false;
        boolean matchany = false;
        if ("*".equals(value)) {
            matchany = true;
        } else {
            if (value.charAt(0) == '*') {
                endswith = true;
                value = value.substring(1);
            }
            if (value.charAt(value.length() - 1) == '*') {
                startswith = true;
                value = value.substring(0, value.length() - 1);
            }
            if (value.length() == 0) {
                matchany = true;
            }
        }
        StructuredDocument doc = null;
        try {
            doc = this.restore(dn, fn);
        }
        catch (Exception e) {
            if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
            LOG.debug((Object)("searchFile failed restoring doc: " + e));
            return false;
        }
        if (doc == null) {
            if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
            LOG.debug((Object)"searchFile failed restoring doc: doc is null");
            return false;
        }
        try {
            Object val;
            Enumeration enumeration = doc.getChildren();
            if (!enumeration.hasMoreElements()) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
                LOG.debug((Object)"searchFile failed restoring doc: doc has no elements");
                return false;
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return false;
                }
                Element e = (Element)enumeration.nextElement();
                Object etag = e.getKey();
                if (!(etag instanceof String) || !((String)etag).equalsIgnoreCase(tag)) continue;
                if (matchany) {
                    return true;
                }
                val = e.getValue();
                if (value.getClass().isInstance(val)) break;
            }
            String uVal = ((String)val).toUpperCase();
            if (startswith && !endswith) {
                return uVal.startsWith(value);
            }
            if (endswith && !startswith) {
                return uVal.endsWith(value);
            }
            if (!startswith) return uVal.equals(value);
            if (!endswith) return uVal.equals(value);
            if (uVal.indexOf(value) < 0) return false;
            return true;
        }
        catch (Exception e) {
            if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
            LOG.debug((Object)"searchFile has failed: ", (Throwable)e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PublicDirName = PublicDirName;
        PrivateDirName = PrivateDirName;
        TmpDirName = TmpDirName;
        LOG = Category.getInstance((String)(class$net$jxta$impl$cm$Cm == null ? (class$net$jxta$impl$cm$Cm = Cm.class$("net.jxta.impl.cm.Cm")) : class$net$jxta$impl$cm$Cm).getName());
        random = new Random();
        indexService = new IndexServiceImpl();
        schedulerService = new SchedulerService();
        RAW = 0;
        CACHE = 1;
        INDEX = 2;
        new Thread((Runnable)schedulerService, "SchedulerService").start();
    }

    public static interface ExpirationListener {
        public boolean expired(File var1);
    }
}

