/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.id.jxta;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.ProviderException;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;

final class Instantiator
implements IDFactory.Instantiator {
    static final Object[][] wellKnownIDs = new Object[][]{{ID.nullID.getUniqueValue(), ID.nullID}, {PeerGroupID.worldPeerGroupID.getUniqueValue(), PeerGroupID.worldPeerGroupID}, {PeerGroupID.defaultNetPeerGroupID.getUniqueValue(), PeerGroupID.defaultNetPeerGroupID}};

    Instantiator() {
    }

    public String getSupportedIDFormat() {
        return "jxta";
    }

    public ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        int colonAt = encoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(encoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        int dashAt = (encoded = encoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("JXTA ID Format was missing.");
        }
        if (!encoded.substring(0, dashAt).equals(this.getSupportedIDFormat())) {
            throw new UnknownServiceException("JXTA ID Format was not as expected.");
        }
        int eachWellKnown = 0;
        while (eachWellKnown < wellKnownIDs.length) {
            if (encoded.equalsIgnoreCase(wellKnownIDs[eachWellKnown][0].toString())) {
                return (ID)wellKnownIDs[eachWellKnown][1];
            }
            ++eachWellKnown;
        }
        throw new MalformedURLException("unrecognized id");
    }

    public CodatID newCodatID(PeerGroupID groupID) {
        throw new ProviderException("unsupported id type");
    }

    public CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        throw new ProviderException("unsupported id type");
    }

    public PeerID newPeerID(PeerGroupID groupID) {
        throw new ProviderException("unsupported id type");
    }

    public PeerGroupID newPeerGroupID() {
        throw new ProviderException("unsupported id type");
    }

    public PipeID newPipeID(PeerGroupID groupID) {
        throw new ProviderException("unsupported id type");
    }

    public PipeID newPipeID(PeerGroupID groupID, byte[] seed) {
        throw new ProviderException("unsupported id type");
    }

    public ModuleClassID newModuleClassID() {
        throw new ProviderException("unsupported id type");
    }

    public ModuleClassID newModuleClassID(ModuleClassID classID) {
        throw new ProviderException("unsupported id type");
    }

    public ModuleSpecID newModuleSpecID(ModuleClassID classID) {
        throw new ProviderException("unsupported id type");
    }
}

