/*
 * Decompiled with CFR 0.152.
 */
package talon;

import java.io.PrintStream;
import java.io.PrintWriter;

public class TalonException
extends Exception {
    private Throwable reason = null;
    private String message = null;

    public TalonException() {
    }

    public TalonException(String message) {
        this.setMessage(message);
    }

    public TalonException(Throwable reason) {
        this(null, reason);
    }

    public TalonException(String message, Throwable reason) {
        super(message);
        this.reason = reason instanceof TalonException ? ((TalonException)reason).getReason() : reason;
        if (message == null && this.reason != null) {
            message = this.reason.getMessage();
        }
        if (this.reason != null) {
            this.setMessage("See attached nested exeception ( " + this.reason.getClass().getName() + " ):  " + message);
        } else {
            this.setMessage(message);
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.reason != null) {
            this.reason.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.reason != null) {
            this.reason.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.reason != null) {
            this.reason.printStackTrace(s);
        }
    }

    public Throwable getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

