/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.ArrayLoadInstruction;
import com.techtrader.modules.tools.bytecode.ArrayStoreInstruction;
import com.techtrader.modules.tools.bytecode.Attribute;
import com.techtrader.modules.tools.bytecode.BCClass;
import com.techtrader.modules.tools.bytecode.BCEntity;
import com.techtrader.modules.tools.bytecode.BCMethod;
import com.techtrader.modules.tools.bytecode.ClassConstantInstruction;
import com.techtrader.modules.tools.bytecode.ClassInstruction;
import com.techtrader.modules.tools.bytecode.CmpInstruction;
import com.techtrader.modules.tools.bytecode.ConstantInstruction;
import com.techtrader.modules.tools.bytecode.Constants;
import com.techtrader.modules.tools.bytecode.ConvertInstruction;
import com.techtrader.modules.tools.bytecode.ExceptionHandler;
import com.techtrader.modules.tools.bytecode.GetFieldInstruction;
import com.techtrader.modules.tools.bytecode.IIncInstruction;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.InstructionPtr;
import com.techtrader.modules.tools.bytecode.JumpInstruction;
import com.techtrader.modules.tools.bytecode.LoadInstruction;
import com.techtrader.modules.tools.bytecode.LookupSwitchInstruction;
import com.techtrader.modules.tools.bytecode.MathInstruction;
import com.techtrader.modules.tools.bytecode.MethodInstruction;
import com.techtrader.modules.tools.bytecode.MonitorEnterInstruction;
import com.techtrader.modules.tools.bytecode.MonitorExitInstruction;
import com.techtrader.modules.tools.bytecode.MultiANewArrayInstruction;
import com.techtrader.modules.tools.bytecode.NewArrayInstruction;
import com.techtrader.modules.tools.bytecode.PutFieldInstruction;
import com.techtrader.modules.tools.bytecode.RetInstruction;
import com.techtrader.modules.tools.bytecode.ReturnInstruction;
import com.techtrader.modules.tools.bytecode.StackInstruction;
import com.techtrader.modules.tools.bytecode.StoreInstruction;
import com.techtrader.modules.tools.bytecode.TableSwitchInstruction;
import com.techtrader.modules.tools.bytecode.WideInstruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Code
extends Attribute
implements Constants {
    private int _maxStack = 0;
    private int _maxLocals = 0;
    private List _opcodes = new LinkedList();
    private List _handlers = new LinkedList();
    private ListIterator _li = this._opcodes.listIterator();
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public int getMaxStack() {
        return this._maxStack;
    }

    public void setMaxStack(int n) {
        this._maxStack = n;
    }

    public int getMaxLocals() {
        return this._maxLocals;
    }

    public void setMaxLocals(int n) {
        this._maxLocals = n;
    }

    public int getLocalsIndex(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        if (!((BCMethod)this._owner).isStatic()) {
            n2 = 1;
        }
        String[] stringArray = ((BCMethod)this._owner).getParamTypeNames();
        int n3 = 0;
        while (n3 < n) {
            if (stringArray[n3].equals("long") || stringArray[n3].equals("double")) {
                ++n2;
            }
            ++n3;
            ++n2;
        }
        return n2;
    }

    public int getNextLocalsIndex() {
        this.calculateMaxLocals();
        return this.getMaxLocals();
    }

    public void calculateMaxLocals() {
        String[] stringArray = ((BCMethod)this._owner).getParamTypeNames();
        int n = 0;
        if (stringArray.length == 0 && !((BCMethod)this._owner).isStatic()) {
            n = 1;
        } else if (stringArray.length > 0) {
            n = this.getLocalsIndex(stringArray.length - 1) + 1;
            if (stringArray[stringArray.length - 1].equals("long") || stringArray[stringArray.length - 1].equals("double")) {
                ++n;
            }
        }
        Iterator iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            int n2 = 0;
            Instruction instruction = (Instruction)iterator.next();
            if (!(instruction instanceof StoreInstruction)) continue;
            StoreInstruction storeInstruction = (StoreInstruction)instruction;
            n2 = storeInstruction.getIndex() + 1;
            if (storeInstruction.getType().equals(Long.TYPE) || storeInstruction.getType().equals(Double.TYPE)) {
                ++n2;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        this.setMaxLocals(n);
    }

    public void calculateMaxStack() {
        int n = 0;
        int n2 = 0;
        ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers();
        Iterator iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            n += instruction.getStackChange();
            int n3 = 0;
            while (n3 < exceptionHandlerArray.length) {
                if (exceptionHandlerArray[n3].getTryStart() == instruction) {
                    ++n;
                }
                ++n3;
            }
            if (n <= n2) continue;
            n2 = n;
        }
        this.setMaxStack(n2);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this._handlers.toArray(new ExceptionHandler[this._handlers.size()]);
    }

    public ExceptionHandler getExceptionHandler(Class clazz) {
        return this.getExceptionHandler(clazz.getName());
    }

    public ExceptionHandler getExceptionHandler(String string) {
        Iterator iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)iterator.next();
            if (!exceptionHandler.getCatchTypeName().equals(string)) continue;
            return exceptionHandler;
        }
        return null;
    }

    public ExceptionHandler[] getExceptionHandlers(Class clazz) {
        return this.getExceptionHandlers(clazz.getName());
    }

    public ExceptionHandler[] getExceptionHandlers(String string) {
        LinkedList<ExceptionHandler> linkedList = new LinkedList<ExceptionHandler>();
        Iterator iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)iterator.next();
            if (!exceptionHandler.getCatchTypeName().equals(string)) continue;
            linkedList.add(exceptionHandler);
        }
        return linkedList.toArray(new ExceptionHandler[linkedList.size()]);
    }

    public ExceptionHandler addExceptionHandler() {
        ExceptionHandler exceptionHandler = new ExceptionHandler(this);
        this._handlers.add(exceptionHandler);
        return exceptionHandler;
    }

    public ExceptionHandler addExceptionHandler(Instruction instruction, Instruction instruction2, Instruction instruction3, Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.getName();
        }
        return this.addExceptionHandler(instruction, instruction2, instruction3, string);
    }

    public ExceptionHandler addExceptionHandler(Instruction instruction, Instruction instruction2, Instruction instruction3, String string) {
        ExceptionHandler exceptionHandler = this.addExceptionHandler();
        exceptionHandler.setTryStart(instruction);
        exceptionHandler.setTryEnd(instruction2);
        exceptionHandler.setHandlerStart(instruction3);
        exceptionHandler.setCatchTypeName(string);
        return exceptionHandler;
    }

    public void clearExceptionHandlers() {
        this._handlers.clear();
    }

    public boolean removeExceptionHandler(Class clazz) {
        ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers(clazz);
        int n = 0;
        while (n < exceptionHandlerArray.length) {
            this.removeExceptionHandler(exceptionHandlerArray[n]);
            ++n;
        }
        return exceptionHandlerArray.length > 0;
    }

    public boolean removeExceptionHandler(String string) {
        ExceptionHandler[] exceptionHandlerArray = this.getExceptionHandlers(string);
        int n = 0;
        while (n < exceptionHandlerArray.length) {
            this.removeExceptionHandler(exceptionHandlerArray[n]);
            ++n;
        }
        return exceptionHandlerArray.length > 0;
    }

    public boolean removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null || !this._handlers.remove(exceptionHandler)) {
            return false;
        }
        exceptionHandler.invalidate();
        return true;
    }

    public int size() {
        return this._opcodes.size();
    }

    public void beforeFirst() {
        this._li = this._opcodes.listIterator();
    }

    public void afterLast() {
        this._li = this._opcodes.listIterator(this._opcodes.size());
    }

    public void before(Instruction instruction) {
        Iterator iterator = this._opcodes.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (iterator.next() == instruction) break;
            ++n;
        }
        this._li = this._opcodes.listIterator(n);
    }

    public void after(Instruction instruction) {
        this.before(instruction);
        this.next();
    }

    public boolean hasNext() {
        return this._li.hasNext();
    }

    public boolean hasPrevious() {
        return this._li.hasPrevious();
    }

    public Instruction next() {
        return (Instruction)this._li.next();
    }

    public int nextIndex() {
        return this._li.nextIndex();
    }

    public Instruction previous() {
        return (Instruction)this._li.previous();
    }

    public int previousIndex() {
        return this._li.previousIndex();
    }

    public void before(int n) {
        this._li = this._opcodes.listIterator(n);
    }

    public void after(int n) {
        this.before(n);
        this.next();
    }

    /*
     * Unable to fully structure code
     */
    public boolean searchForward(Instruction var1_1) {
        if (var1_1 != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (!var1_1.equals(this.next())) continue;
            return true;
lbl5:
            // 2 sources

            ** while (this.hasNext())
        }
lbl6:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean searchBackward(Instruction var1_1) {
        if (var1_1 != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (!var1_1.equals(this.previous())) continue;
            return true;
lbl5:
            // 2 sources

            ** while (this.hasPrevious())
        }
lbl6:
        // 1 sources

        return false;
    }

    public Instruction replaceNext(Instruction instruction) {
        Instruction instruction2 = (Instruction)this._li.next();
        Instruction instruction3 = null;
        this._li.remove();
        if (instruction != null) {
            instruction3 = this.getInstruction(instruction.getOpCode());
            instruction3.copy(instruction);
            this.updateJumpPoints(instruction2, instruction3);
        }
        return instruction3;
    }

    public Instruction replacePrevious(Instruction instruction) {
        Instruction instruction2 = (Instruction)this._li.previous();
        Instruction instruction3 = null;
        this._li.remove();
        if (instruction != null) {
            instruction3 = this.getInstruction(instruction.getOpCode());
            instruction3.copy(instruction);
            this.updateJumpPoints(instruction2, instruction3);
        }
        return instruction3;
    }

    public int replaceAll(Instruction instruction, Instruction instruction2) {
        int n = this.nextIndex();
        this.beforeFirst();
        int n2 = 0;
        while (this.searchForward(instruction)) {
            this.replacePrevious(instruction2);
            ++n2;
        }
        this.before(n);
        return n2;
    }

    public int replaceAll(Instruction[] instructionArray, Instruction[] instructionArray2) {
        if (instructionArray == null && instructionArray2 == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < instructionArray.length) {
            n = instructionArray2 == null ? (n += this.replaceAll(instructionArray[n2], null)) : (n += this.replaceAll(instructionArray[n2], instructionArray2[n2]));
            ++n2;
        }
        return n;
    }

    private void updateJumpPoints(Instruction instruction, Instruction instruction2) {
        ListIterator listIterator = this._opcodes.listIterator();
        while (listIterator.hasNext()) {
            Instruction instruction3 = (Instruction)listIterator.next();
            if (!(instruction3 instanceof JumpInstruction)) continue;
            if (instruction.equals(((JumpInstruction)instruction3).getTarget())) {
                ((JumpInstruction)instruction3).setTarget(instruction2);
            }
            if (instruction3.getOpCode() == 170) {
                this.updateJumpPoints(instruction, instruction2, (TableSwitchInstruction)instruction3);
                continue;
            }
            if (instruction3.getOpCode() != 171) continue;
            this.updateJumpPoints(instruction, instruction2, (LookupSwitchInstruction)instruction3);
        }
    }

    private void updateJumpPoints(Instruction instruction, Instruction instruction2, TableSwitchInstruction tableSwitchInstruction) {
        Instruction[] instructionArray = tableSwitchInstruction.getTargets();
        int n = 0;
        while (n < instructionArray.length) {
            if (instruction == instructionArray[n]) {
                instructionArray[n] = instruction2;
            }
            ++n;
        }
        tableSwitchInstruction.setTargets(instructionArray);
    }

    private void updateJumpPoints(Instruction instruction, Instruction instruction2, LookupSwitchInstruction lookupSwitchInstruction) {
        Instruction[] instructionArray = lookupSwitchInstruction.getTargets();
        int n = 0;
        while (n < instructionArray.length) {
            if (instruction == instructionArray[n]) {
                instructionArray[n] = instruction2;
            }
            ++n;
        }
        lookupSwitchInstruction.setCases(lookupSwitchInstruction.getMatches(), instructionArray);
    }

    public void remove() {
        this._li.remove();
    }

    public Instruction nop() {
        return this.addInstruction(0);
    }

    public ConstantInstruction constant() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this));
    }

    public ClassConstantInstruction classconstant() {
        return new ClassConstantInstruction(((BCMethod)this._owner).getOwner(), this, this.nop());
    }

    public ConstantInstruction aconst_null() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 1, null));
    }

    public ConstantInstruction iconst_m1() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 2, new Integer(-1)));
    }

    public ConstantInstruction iconst_0() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 3, new Integer(0)));
    }

    public ConstantInstruction iconst_1() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 4, new Integer(1)));
    }

    public ConstantInstruction iconst_2() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 5, new Integer(2)));
    }

    public ConstantInstruction iconst_3() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 6, new Integer(3)));
    }

    public ConstantInstruction iconst_4() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 7, new Integer(4)));
    }

    public ConstantInstruction iconst_5() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 8, new Integer(5)));
    }

    public ConstantInstruction lconst_0() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 9, new Long(0L)));
    }

    public ConstantInstruction lconst_1() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 10, new Long(1L)));
    }

    public ConstantInstruction fconst_0() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 11, new Float(0.0f)));
    }

    public ConstantInstruction fconst_1() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 12, new Float(1.0f)));
    }

    public ConstantInstruction fconst_2() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 13, new Float(2.0f)));
    }

    public ConstantInstruction dconst_0() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 14, new Double(0.0)));
    }

    public ConstantInstruction dconst_1() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 15, new Double(1.0)));
    }

    public ConstantInstruction bipush() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 16, null));
    }

    public ConstantInstruction sipush() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 17, null));
    }

    public ConstantInstruction ldc() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 18, null));
    }

    public ConstantInstruction ldc_w() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 19, null));
    }

    public ConstantInstruction ldc2_w() {
        return (ConstantInstruction)this.addInstruction(new ConstantInstruction(this, 20, null));
    }

    public LoadInstruction load() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this));
    }

    public LoadInstruction iload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 21, Integer.TYPE, -1));
    }

    public LoadInstruction iload_0() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 26, Integer.TYPE, 0));
    }

    public LoadInstruction iload_1() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 27, Integer.TYPE, 1));
    }

    public LoadInstruction iload_2() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 28, Integer.TYPE, 2));
    }

    public LoadInstruction iload_3() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 29, Integer.TYPE, 3));
    }

    public LoadInstruction lload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 22, Long.TYPE, -1));
    }

    public LoadInstruction lload_0() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 30, Long.TYPE, 0));
    }

    public LoadInstruction lload_1() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 31, Long.TYPE, 1));
    }

    public LoadInstruction lload_2() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 32, Long.TYPE, 2));
    }

    public LoadInstruction lload_3() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 33, Long.TYPE, 3));
    }

    public LoadInstruction fload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 23, Float.TYPE, -1));
    }

    public LoadInstruction fload_0() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 34, Float.TYPE, 0));
    }

    public LoadInstruction fload_1() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 35, Float.TYPE, 1));
    }

    public LoadInstruction fload_2() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 36, Float.TYPE, 2));
    }

    public LoadInstruction fload_3() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 37, Float.TYPE, 3));
    }

    public LoadInstruction dload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 24, Double.TYPE, -1));
    }

    public LoadInstruction dload_0() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 38, Double.TYPE, 0));
    }

    public LoadInstruction dload_1() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 39, Double.TYPE, 1));
    }

    public LoadInstruction dload_2() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 40, Double.TYPE, 2));
    }

    public LoadInstruction dload_3() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 41, Double.TYPE, 3));
    }

    public LoadInstruction aload() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 25, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), -1));
    }

    public LoadInstruction aload_0() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 42, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 0));
    }

    public LoadInstruction aload_1() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 43, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 1));
    }

    public LoadInstruction aload_2() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 44, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 2));
    }

    public LoadInstruction aload_3() {
        return (LoadInstruction)this.addInstruction(new LoadInstruction(this, 45, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 3));
    }

    public StoreInstruction store() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this));
    }

    public StoreInstruction istore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 54, Integer.TYPE, -1));
    }

    public StoreInstruction istore_0() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 59, Integer.TYPE, 0));
    }

    public StoreInstruction istore_1() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 60, Integer.TYPE, 1));
    }

    public StoreInstruction istore_2() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 61, Integer.TYPE, 2));
    }

    public StoreInstruction istore_3() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 62, Integer.TYPE, 3));
    }

    public StoreInstruction lstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 55, Long.TYPE, -1));
    }

    public StoreInstruction lstore_0() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 63, Long.TYPE, 0));
    }

    public StoreInstruction lstore_1() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 64, Long.TYPE, 1));
    }

    public StoreInstruction lstore_2() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 65, Long.TYPE, 2));
    }

    public StoreInstruction lstore_3() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 66, Long.TYPE, 3));
    }

    public StoreInstruction fstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 56, Float.TYPE, -1));
    }

    public StoreInstruction fstore_0() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 67, Float.TYPE, 0));
    }

    public StoreInstruction fstore_1() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 68, Float.TYPE, 1));
    }

    public StoreInstruction fstore_2() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 69, Float.TYPE, 2));
    }

    public StoreInstruction fstore_3() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 70, Float.TYPE, 3));
    }

    public StoreInstruction dstore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 57, Double.TYPE, -1));
    }

    public StoreInstruction dstore_0() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 71, Double.TYPE, 0));
    }

    public StoreInstruction dstore_1() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 72, Double.TYPE, 1));
    }

    public StoreInstruction dstore_2() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 73, Double.TYPE, 2));
    }

    public StoreInstruction dstore_3() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 74, Double.TYPE, 3));
    }

    public StoreInstruction astore() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 58, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), -1));
    }

    public StoreInstruction astore_0() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 75, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 0));
    }

    public StoreInstruction astore_1() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 76, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 1));
    }

    public StoreInstruction astore_2() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 77, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 2));
    }

    public StoreInstruction astore_3() {
        return (StoreInstruction)this.addInstruction(new StoreInstruction(this, 78, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object")), 3));
    }

    public RetInstruction ret() {
        return (RetInstruction)this.addInstruction(new RetInstruction(this));
    }

    public IIncInstruction iinc() {
        return (IIncInstruction)this.addInstruction(new IIncInstruction(this));
    }

    public WideInstruction wide() {
        return (WideInstruction)this.addInstruction(new WideInstruction(this));
    }

    public ArrayLoadInstruction arrayload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this));
    }

    public ArrayLoadInstruction iaload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 46, Integer.TYPE));
    }

    public ArrayLoadInstruction laload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 47, Long.TYPE));
    }

    public ArrayLoadInstruction faload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 48, Float.TYPE));
    }

    public ArrayLoadInstruction daload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 49, Double.TYPE));
    }

    public ArrayLoadInstruction aaload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 50, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object"))));
    }

    public ArrayLoadInstruction baload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 51, Byte.TYPE));
    }

    public ArrayLoadInstruction caload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 52, Character.TYPE));
    }

    public ArrayLoadInstruction saload() {
        return (ArrayLoadInstruction)this.addInstruction(new ArrayLoadInstruction(this, 53, Short.TYPE));
    }

    public ArrayStoreInstruction arraystore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this));
    }

    public ArrayStoreInstruction iastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 79, Integer.TYPE));
    }

    public ArrayStoreInstruction lastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 80, Long.TYPE));
    }

    public ArrayStoreInstruction fastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 81, Float.TYPE));
    }

    public ArrayStoreInstruction dastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 82, Double.TYPE));
    }

    public ArrayStoreInstruction aastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 83, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object"))));
    }

    public ArrayStoreInstruction bastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 84, Byte.TYPE));
    }

    public ArrayStoreInstruction castore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 85, Character.TYPE));
    }

    public ArrayStoreInstruction sastore() {
        return (ArrayStoreInstruction)this.addInstruction(new ArrayStoreInstruction(this, 86, Short.TYPE));
    }

    public StackInstruction pop() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 87));
    }

    public StackInstruction pop2() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 88));
    }

    public StackInstruction dup() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 89));
    }

    public StackInstruction dup_x1() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 90));
    }

    public StackInstruction dup_x2() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 91));
    }

    public StackInstruction dup2() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 92));
    }

    public StackInstruction dup2_x1() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 93));
    }

    public StackInstruction dup2_x2() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 94));
    }

    public StackInstruction swap() {
        return (StackInstruction)this.addInstruction(new StackInstruction(this, 95));
    }

    public MathInstruction math() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this));
    }

    public MathInstruction add() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 96, 96, null));
    }

    public MathInstruction iadd() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 96, 96, Integer.TYPE));
    }

    public MathInstruction ladd() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 97, 96, Long.TYPE));
    }

    public MathInstruction fadd() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 98, 96, Float.TYPE));
    }

    public MathInstruction dadd() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 99, 96, Double.TYPE));
    }

    public MathInstruction sub() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 100, 100, null));
    }

    public MathInstruction isub() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 100, 100, Integer.TYPE));
    }

    public MathInstruction lsub() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 101, 100, Long.TYPE));
    }

    public MathInstruction fsub() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 102, 100, Float.TYPE));
    }

    public MathInstruction dsub() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 103, 100, Double.TYPE));
    }

    public MathInstruction mul() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 104, 104, null));
    }

    public MathInstruction imul() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 104, 104, Integer.TYPE));
    }

    public MathInstruction lmul() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 105, 104, Long.TYPE));
    }

    public MathInstruction fmul() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 106, 104, Float.TYPE));
    }

    public MathInstruction dmul() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 107, 104, Double.TYPE));
    }

    public MathInstruction div() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 108, 108, null));
    }

    public MathInstruction idiv() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 108, 108, Integer.TYPE));
    }

    public MathInstruction ldiv() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 109, 108, Long.TYPE));
    }

    public MathInstruction fdiv() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 110, 108, Float.TYPE));
    }

    public MathInstruction ddiv() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 111, 108, Double.TYPE));
    }

    public MathInstruction rem() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 112, 112, null));
    }

    public MathInstruction irem() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 112, 112, Integer.TYPE));
    }

    public MathInstruction lrem() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 113, 112, Long.TYPE));
    }

    public MathInstruction frem() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 114, 112, Float.TYPE));
    }

    public MathInstruction drem() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 115, 112, Double.TYPE));
    }

    public MathInstruction neg() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 116, 116, null));
    }

    public MathInstruction ineg() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 116, 116, Integer.TYPE));
    }

    public MathInstruction lneg() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 117, 116, Long.TYPE));
    }

    public MathInstruction fneg() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 118, 116, Float.TYPE));
    }

    public MathInstruction dneg() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 119, 116, Double.TYPE));
    }

    public MathInstruction shl() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 120, 120, null));
    }

    public MathInstruction ishl() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 120, 120, Integer.TYPE));
    }

    public MathInstruction lshl() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 121, 120, Long.TYPE));
    }

    public MathInstruction shr() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 122, 122, null));
    }

    public MathInstruction ishr() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 122, 122, Integer.TYPE));
    }

    public MathInstruction lshr() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 123, 122, Long.TYPE));
    }

    public MathInstruction ushr() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 124, 124, null));
    }

    public MathInstruction iushr() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 124, 124, Integer.TYPE));
    }

    public MathInstruction lushr() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 125, 124, Long.TYPE));
    }

    public MathInstruction and() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 126, 126, null));
    }

    public MathInstruction iand() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 126, 126, Integer.TYPE));
    }

    public MathInstruction land() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 127, 126, Long.TYPE));
    }

    public MathInstruction or() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 128, 128, null));
    }

    public MathInstruction ior() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 128, 128, Integer.TYPE));
    }

    public MathInstruction lor() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 129, 128, Long.TYPE));
    }

    public MathInstruction xor() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 130, 130, null));
    }

    public MathInstruction ixor() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 130, 130, Integer.TYPE));
    }

    public MathInstruction lxor() {
        return (MathInstruction)this.addInstruction(new MathInstruction(this, 131, 130, Long.TYPE));
    }

    public ConvertInstruction convert() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this));
    }

    public ConvertInstruction i2l() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 133, Integer.TYPE, Long.TYPE));
    }

    public ConvertInstruction i2f() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 134, Integer.TYPE, Float.TYPE));
    }

    public ConvertInstruction i2d() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 135, Integer.TYPE, Double.TYPE));
    }

    public ConvertInstruction i2b() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 145, Integer.TYPE, Byte.TYPE));
    }

    public ConvertInstruction i2c() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 146, Integer.TYPE, Character.TYPE));
    }

    public ConvertInstruction i2s() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 147, Integer.TYPE, Short.TYPE));
    }

    public ConvertInstruction l2i() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 136, Long.TYPE, Integer.TYPE));
    }

    public ConvertInstruction l2f() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 137, Long.TYPE, Float.TYPE));
    }

    public ConvertInstruction l2d() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 138, Long.TYPE, Double.TYPE));
    }

    public ConvertInstruction f2i() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 139, Float.TYPE, Integer.TYPE));
    }

    public ConvertInstruction f2l() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 140, Float.TYPE, Long.TYPE));
    }

    public ConvertInstruction f2d() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 141, Float.TYPE, Double.TYPE));
    }

    public ConvertInstruction d2i() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 142, Double.TYPE, Integer.TYPE));
    }

    public ConvertInstruction d2l() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 143, Double.TYPE, Long.TYPE));
    }

    public ConvertInstruction d2f() {
        return (ConvertInstruction)this.addInstruction(new ConvertInstruction(this, 144, Double.TYPE, Float.TYPE));
    }

    public CmpInstruction cmp() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this));
    }

    public CmpInstruction lcmp() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this, 148, Long.TYPE, -1));
    }

    public CmpInstruction fcmpl() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this, 149, Float.TYPE, -1));
    }

    public CmpInstruction fcmpg() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this, 150, Float.TYPE, 1));
    }

    public CmpInstruction dcmpl() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this, 151, Double.TYPE, -1));
    }

    public CmpInstruction dcmpg() {
        return (CmpInstruction)this.addInstruction(new CmpInstruction(this, 152, Double.TYPE, 1));
    }

    public JumpInstruction if_eq() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 153));
    }

    public JumpInstruction if_ne() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 154));
    }

    public JumpInstruction if_lt() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 155));
    }

    public JumpInstruction if_ge() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 156));
    }

    public JumpInstruction if_gt() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 157));
    }

    public JumpInstruction if_le() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 158));
    }

    public JumpInstruction if_icmpeq() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 159));
    }

    public JumpInstruction if_icmpne() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 160));
    }

    public JumpInstruction if_icmplt() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 161));
    }

    public JumpInstruction if_icmpge() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 162));
    }

    public JumpInstruction if_icmpgt() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 163));
    }

    public JumpInstruction if_icmple() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 164));
    }

    public JumpInstruction if_acmpeq() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 165));
    }

    public JumpInstruction if_acmpne() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 166));
    }

    public JumpInstruction if_null() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 198));
    }

    public JumpInstruction if_nonnull() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 199));
    }

    public JumpInstruction go2() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 167));
    }

    public JumpInstruction jsr() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 168));
    }

    public JumpInstruction go2_w() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 200));
    }

    public JumpInstruction jsr_w() {
        return (JumpInstruction)this.addInstruction(new JumpInstruction(this, 201));
    }

    public TableSwitchInstruction tableswitch() {
        return (TableSwitchInstruction)this.addInstruction(new TableSwitchInstruction(this));
    }

    public LookupSwitchInstruction lookupswitch() {
        return (LookupSwitchInstruction)this.addInstruction(new LookupSwitchInstruction(this));
    }

    public ReturnInstruction returnins() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this));
    }

    public ReturnInstruction vreturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this, 177, Void.TYPE));
    }

    public ReturnInstruction ireturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this, 172, Integer.TYPE));
    }

    public ReturnInstruction lreturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this, 173, Long.TYPE));
    }

    public ReturnInstruction freturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this, 174, Float.TYPE));
    }

    public ReturnInstruction dreturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this, 175, Double.TYPE));
    }

    public ReturnInstruction areturn() {
        return (ReturnInstruction)this.addInstruction(new ReturnInstruction(this, 176, class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = Code.class$("java.lang.Object"))));
    }

    public GetFieldInstruction getfield() {
        return (GetFieldInstruction)this.addInstruction(new GetFieldInstruction(this, 180));
    }

    public GetFieldInstruction getstatic() {
        return (GetFieldInstruction)this.addInstruction(new GetFieldInstruction(this, 178));
    }

    public PutFieldInstruction putfield() {
        return (PutFieldInstruction)this.addInstruction(new PutFieldInstruction(this, 181));
    }

    public PutFieldInstruction putstatic() {
        return (PutFieldInstruction)this.addInstruction(new PutFieldInstruction(this, 179));
    }

    public MethodInstruction invokevirtual() {
        return (MethodInstruction)this.addInstruction(new MethodInstruction(this, 182));
    }

    public MethodInstruction invokespecial() {
        return (MethodInstruction)this.addInstruction(new MethodInstruction(this, 183));
    }

    public MethodInstruction invokeinterface() {
        return (MethodInstruction)this.addInstruction(new MethodInstruction(this, 185));
    }

    public MethodInstruction invokestatic() {
        return (MethodInstruction)this.addInstruction(new MethodInstruction(this, 184));
    }

    public ClassInstruction newins() {
        return (ClassInstruction)this.addInstruction(new ClassInstruction(this, 187));
    }

    public ClassInstruction anewarray() {
        return (ClassInstruction)this.addInstruction(new ClassInstruction(this, 189));
    }

    public ClassInstruction checkcast() {
        return (ClassInstruction)this.addInstruction(new ClassInstruction(this, 192));
    }

    public ClassInstruction instanceofins() {
        return (ClassInstruction)this.addInstruction(new ClassInstruction(this, 193));
    }

    public MultiANewArrayInstruction multianewarray() {
        return (MultiANewArrayInstruction)this.addInstruction(new MultiANewArrayInstruction(this));
    }

    public NewArrayInstruction newarray() {
        return (NewArrayInstruction)this.addInstruction(new NewArrayInstruction(this));
    }

    public Instruction arraylength() {
        return this.addInstruction(190);
    }

    public Instruction athrow() {
        return this.addInstruction(191);
    }

    public MonitorEnterInstruction monitorenter() {
        return (MonitorEnterInstruction)this.addInstruction(new MonitorEnterInstruction(this));
    }

    public MonitorExitInstruction monitorexit() {
        return (MonitorExitInstruction)this.addInstruction(new MonitorExitInstruction(this));
    }

    public Instruction[] getInstructions() {
        return this._opcodes.toArray(new Instruction[this._opcodes.size()]);
    }

    public byte[] getCode() throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.writeCode(dataOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                dataOutputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public void setCode(byte[] byArray) throws IOException {
        if (byArray == null) {
            this._opcodes.clear();
        } else {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                this.readCode(dataInputStream, byArray.length);
            }
            finally {
                Object var4_3 = null;
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getLength() {
        int n = 12;
        try {
            n += this.getCode().length;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        n += 8 * this._handlers.size();
        Attribute[] attributeArray = this.getAttributes();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            n += attributeArray[n2].getLength() + 6;
            ++n2;
        }
        return n;
    }

    protected void copy(Attribute attribute) {
        Instruction instruction;
        Code code = (Code)attribute;
        this.setMaxStack(code.getMaxStack());
        this.setMaxLocals(code.getMaxLocals());
        this._opcodes.clear();
        this._handlers.clear();
        this._li = this._opcodes.listIterator();
        ExceptionHandler[] exceptionHandlerArray = code._opcodes.iterator();
        while (exceptionHandlerArray.hasNext()) {
            Instruction instruction2 = (Instruction)exceptionHandlerArray.next();
            instruction = this.getInstruction(instruction2.getOpCode());
            instruction.copy(instruction2);
        }
        exceptionHandlerArray = code.getExceptionHandlers();
        int n = 0;
        while (n < exceptionHandlerArray.length) {
            ExceptionHandler exceptionHandler = this.addExceptionHandler();
            exceptionHandler.copy(exceptionHandlerArray[n]);
            exceptionHandler.setMarkers(this._opcodes);
            ++n;
        }
        Iterator iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            if (!(instruction instanceof InstructionPtr)) continue;
            ((InstructionPtr)((Object)instruction)).setMarkers(this._opcodes);
        }
        this._li = this._opcodes.listIterator();
        this.importAttributes(code);
    }

    protected void readData(DataInput dataInput, int n) throws IOException {
        this.setMaxStack(dataInput.readUnsignedShort());
        this.setMaxLocals(dataInput.readUnsignedShort());
        this.readCode(dataInput, dataInput.readInt());
        this._handlers.clear();
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            ExceptionHandler exceptionHandler = this.addExceptionHandler();
            exceptionHandler.readData(dataInput);
            exceptionHandler.setMarkers(this._opcodes);
            ++n3;
        }
        this.readAttributes(dataInput);
    }

    protected void writeData(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this.getMaxStack());
        dataOutput.writeShort(this.getMaxLocals());
        byte[] byArray = this.getCode();
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray);
        dataOutput.writeShort(this._handlers.size());
        Iterator iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            ((ExceptionHandler)iterator.next()).writeData(dataOutput);
        }
        this.writeAttributes(dataOutput);
    }

    private void readCode(DataInput dataInput, int n) throws IOException {
        Instruction instruction;
        this._opcodes.clear();
        this._li = this._opcodes.listIterator();
        int n2 = 0;
        while (n2 < n) {
            instruction = this.getInstruction(dataInput.readUnsignedByte());
            instruction.setByteIndex(n2);
            instruction.readData(dataInput);
            n2 += instruction.getLength();
        }
        Iterator iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            if (!(instruction instanceof InstructionPtr)) continue;
            ((InstructionPtr)((Object)instruction)).setMarkers(this._opcodes);
        }
        this.beforeFirst();
    }

    private void writeCode(DataOutput dataOutput) throws IOException {
        Instruction instruction;
        int n = 0;
        Iterator iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            instruction.setByteIndex(n);
            n += instruction.getLength();
        }
        iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            dataOutput.writeByte(instruction.getOpCode());
            instruction.writeData(dataOutput);
        }
    }

    private Instruction addInstruction(Instruction instruction) {
        this._li.add(instruction);
        return instruction;
    }

    private Instruction addInstruction(int n) {
        Instruction instruction = new Instruction(this);
        instruction.setOpCode(n);
        this._li.add(instruction);
        return instruction;
    }

    private Instruction getInstruction(int n) {
        switch (n) {
            case 0: {
                return this.nop();
            }
            case 1: {
                return this.aconst_null();
            }
            case 2: {
                return this.iconst_m1();
            }
            case 3: {
                return this.iconst_0();
            }
            case 4: {
                return this.iconst_1();
            }
            case 5: {
                return this.iconst_2();
            }
            case 6: {
                return this.iconst_3();
            }
            case 7: {
                return this.iconst_4();
            }
            case 8: {
                return this.iconst_5();
            }
            case 9: {
                return this.lconst_0();
            }
            case 10: {
                return this.lconst_1();
            }
            case 11: {
                return this.fconst_0();
            }
            case 12: {
                return this.fconst_1();
            }
            case 13: {
                return this.fconst_2();
            }
            case 14: {
                return this.dconst_0();
            }
            case 15: {
                return this.dconst_1();
            }
            case 16: {
                return this.bipush();
            }
            case 17: {
                return this.sipush();
            }
            case 18: {
                return this.ldc();
            }
            case 19: {
                return this.ldc_w();
            }
            case 20: {
                return this.ldc2_w();
            }
            case 21: {
                return this.iload();
            }
            case 22: {
                return this.lload();
            }
            case 23: {
                return this.fload();
            }
            case 24: {
                return this.dload();
            }
            case 25: {
                return this.aload();
            }
            case 26: {
                return this.iload_0();
            }
            case 27: {
                return this.iload_1();
            }
            case 28: {
                return this.iload_2();
            }
            case 29: {
                return this.iload_3();
            }
            case 30: {
                return this.lload_0();
            }
            case 31: {
                return this.lload_1();
            }
            case 32: {
                return this.lload_2();
            }
            case 33: {
                return this.lload_3();
            }
            case 34: {
                return this.fload_0();
            }
            case 35: {
                return this.fload_1();
            }
            case 36: {
                return this.fload_2();
            }
            case 37: {
                return this.fload_3();
            }
            case 38: {
                return this.dload_0();
            }
            case 39: {
                return this.dload_1();
            }
            case 40: {
                return this.dload_2();
            }
            case 41: {
                return this.dload_3();
            }
            case 42: {
                return this.aload_0();
            }
            case 43: {
                return this.aload_1();
            }
            case 44: {
                return this.aload_2();
            }
            case 45: {
                return this.aload_3();
            }
            case 46: {
                return this.iaload();
            }
            case 47: {
                return this.laload();
            }
            case 48: {
                return this.faload();
            }
            case 49: {
                return this.daload();
            }
            case 50: {
                return this.aaload();
            }
            case 51: {
                return this.baload();
            }
            case 52: {
                return this.caload();
            }
            case 53: {
                return this.saload();
            }
            case 54: {
                return this.istore();
            }
            case 55: {
                return this.lstore();
            }
            case 56: {
                return this.fstore();
            }
            case 57: {
                return this.dstore();
            }
            case 58: {
                return this.astore();
            }
            case 59: {
                return this.istore_0();
            }
            case 60: {
                return this.istore_1();
            }
            case 61: {
                return this.istore_2();
            }
            case 62: {
                return this.istore_3();
            }
            case 63: {
                return this.lstore_0();
            }
            case 64: {
                return this.lstore_1();
            }
            case 65: {
                return this.lstore_2();
            }
            case 66: {
                return this.lstore_3();
            }
            case 67: {
                return this.fstore_0();
            }
            case 68: {
                return this.fstore_1();
            }
            case 69: {
                return this.fstore_2();
            }
            case 70: {
                return this.fstore_3();
            }
            case 71: {
                return this.dstore_0();
            }
            case 72: {
                return this.dstore_1();
            }
            case 73: {
                return this.dstore_2();
            }
            case 74: {
                return this.dstore_3();
            }
            case 75: {
                return this.astore_0();
            }
            case 76: {
                return this.astore_1();
            }
            case 77: {
                return this.astore_2();
            }
            case 78: {
                return this.astore_3();
            }
            case 79: {
                return this.iastore();
            }
            case 80: {
                return this.lastore();
            }
            case 81: {
                return this.fastore();
            }
            case 82: {
                return this.dastore();
            }
            case 83: {
                return this.aastore();
            }
            case 84: {
                return this.bastore();
            }
            case 85: {
                return this.castore();
            }
            case 86: {
                return this.sastore();
            }
            case 87: {
                return this.pop();
            }
            case 88: {
                return this.pop2();
            }
            case 89: {
                return this.dup();
            }
            case 90: {
                return this.dup_x1();
            }
            case 91: {
                return this.dup_x2();
            }
            case 92: {
                return this.dup2();
            }
            case 93: {
                return this.dup2_x1();
            }
            case 94: {
                return this.dup2_x2();
            }
            case 95: {
                return this.swap();
            }
            case 96: {
                return this.iadd();
            }
            case 97: {
                return this.ladd();
            }
            case 98: {
                return this.fadd();
            }
            case 99: {
                return this.dadd();
            }
            case 100: {
                return this.isub();
            }
            case 101: {
                return this.lsub();
            }
            case 102: {
                return this.fsub();
            }
            case 103: {
                return this.dsub();
            }
            case 104: {
                return this.imul();
            }
            case 105: {
                return this.lmul();
            }
            case 106: {
                return this.fmul();
            }
            case 107: {
                return this.dmul();
            }
            case 108: {
                return this.idiv();
            }
            case 109: {
                return this.ldiv();
            }
            case 110: {
                return this.fdiv();
            }
            case 111: {
                return this.ddiv();
            }
            case 112: {
                return this.irem();
            }
            case 113: {
                return this.lrem();
            }
            case 114: {
                return this.frem();
            }
            case 115: {
                return this.drem();
            }
            case 116: {
                return this.ineg();
            }
            case 117: {
                return this.lneg();
            }
            case 118: {
                return this.fneg();
            }
            case 119: {
                return this.dneg();
            }
            case 120: {
                return this.ishl();
            }
            case 121: {
                return this.lshl();
            }
            case 122: {
                return this.ishr();
            }
            case 123: {
                return this.lshr();
            }
            case 124: {
                return this.iushr();
            }
            case 125: {
                return this.lushr();
            }
            case 126: {
                return this.iand();
            }
            case 127: {
                return this.land();
            }
            case 128: {
                return this.ior();
            }
            case 129: {
                return this.lor();
            }
            case 130: {
                return this.ixor();
            }
            case 131: {
                return this.lxor();
            }
            case 132: {
                return this.iinc();
            }
            case 133: {
                return this.i2l();
            }
            case 134: {
                return this.i2f();
            }
            case 135: {
                return this.i2d();
            }
            case 136: {
                return this.l2i();
            }
            case 137: {
                return this.l2f();
            }
            case 138: {
                return this.l2d();
            }
            case 139: {
                return this.f2i();
            }
            case 140: {
                return this.f2l();
            }
            case 141: {
                return this.f2d();
            }
            case 142: {
                return this.d2i();
            }
            case 143: {
                return this.d2l();
            }
            case 144: {
                return this.d2f();
            }
            case 145: {
                return this.i2b();
            }
            case 146: {
                return this.i2c();
            }
            case 147: {
                return this.i2s();
            }
            case 148: {
                return this.lcmp();
            }
            case 149: {
                return this.fcmpl();
            }
            case 150: {
                return this.fcmpg();
            }
            case 151: {
                return this.dcmpl();
            }
            case 152: {
                return this.dcmpg();
            }
            case 153: {
                return this.if_eq();
            }
            case 154: {
                return this.if_ne();
            }
            case 155: {
                return this.if_lt();
            }
            case 156: {
                return this.if_ge();
            }
            case 157: {
                return this.if_gt();
            }
            case 158: {
                return this.if_le();
            }
            case 159: {
                return this.if_icmpeq();
            }
            case 160: {
                return this.if_icmpne();
            }
            case 161: {
                return this.if_icmplt();
            }
            case 162: {
                return this.if_icmpge();
            }
            case 163: {
                return this.if_icmpgt();
            }
            case 164: {
                return this.if_icmple();
            }
            case 165: {
                return this.if_acmpeq();
            }
            case 166: {
                return this.if_acmpne();
            }
            case 167: {
                return this.go2();
            }
            case 168: {
                return this.jsr();
            }
            case 169: {
                return this.ret();
            }
            case 170: {
                return this.tableswitch();
            }
            case 171: {
                return this.lookupswitch();
            }
            case 172: {
                return this.ireturn();
            }
            case 173: {
                return this.lreturn();
            }
            case 174: {
                return this.freturn();
            }
            case 175: {
                return this.dreturn();
            }
            case 176: {
                return this.areturn();
            }
            case 177: {
                return this.vreturn();
            }
            case 178: {
                return this.getstatic();
            }
            case 179: {
                return this.putstatic();
            }
            case 180: {
                return this.getfield();
            }
            case 181: {
                return this.putfield();
            }
            case 182: {
                return this.invokevirtual();
            }
            case 183: {
                return this.invokespecial();
            }
            case 184: {
                return this.invokestatic();
            }
            case 185: {
                return this.invokeinterface();
            }
            case 187: {
                return this.newins();
            }
            case 188: {
                return this.newarray();
            }
            case 189: {
                return this.anewarray();
            }
            case 190: {
                return this.arraylength();
            }
            case 191: {
                return this.athrow();
            }
            case 192: {
                return this.checkcast();
            }
            case 193: {
                return this.instanceofins();
            }
            case 194: {
                return this.monitorenter();
            }
            case 195: {
                return this.monitorexit();
            }
            case 196: {
                return this.wide();
            }
            case 197: {
                return this.multianewarray();
            }
            case 198: {
                return this.if_null();
            }
            case 199: {
                return this.if_nonnull();
            }
            case 200: {
                return this.go2_w();
            }
            case 201: {
                return this.jsr_w();
            }
        }
        return null;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterCode(this);
        Iterator iterator = this._opcodes.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            bCVisitor.enterInstruction(instruction);
            instruction.acceptVisit(bCVisitor);
            bCVisitor.exitInstruction(instruction);
        }
        iterator = this._handlers.iterator();
        while (iterator.hasNext()) {
            ((ExceptionHandler)iterator.next()).acceptVisit(bCVisitor);
        }
        this.visitAttributes(bCVisitor);
        bCVisitor.exitCode(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Code(int n, BCEntity bCEntity) {
        super(n, bCEntity);
    }

    public Code() {
        super(0, new BCClass().addMethod());
        this._nameIndex = this.getPool().setUTF(0, "Code");
    }
}

