/*
 * Decompiled with CFR 0.152.
 */
package org.arrowhead.testlet.engine;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.arrowhead.testlet.DefaultTestletContext;
import org.arrowhead.testlet.TestFailedException;
import org.arrowhead.testlet.TestResultEvent;
import org.arrowhead.testlet.TestResultListener;
import org.arrowhead.testlet.TestSuite;
import org.arrowhead.testlet.Testlet;
import org.arrowhead.testlet.TestletContext;
import org.arrowhead.util.cli.CLArgsParser;
import org.arrowhead.util.cli.CLOption;
import org.arrowhead.util.cli.CLOptionDescriptor;
import org.arrowhead.util.cli.CLUtil;

public abstract class AbstractTestEngine
implements TestResultListener {
    protected static final int HELP_OPT = 104;
    protected static final int CONFIG_OPT = 99;
    protected static final int SUCCESS_OPT = 115;
    protected static final int BANNER_OPT = 98;
    protected static final int TRACE_OPT = 116;
    protected static final int FORCE_TRACE_OPT = 102;
    protected CLOptionDescriptor[] m_options;
    protected String m_config;
    protected Vector m_testlets = new Vector();
    protected int m_messageLevel = 1;
    protected boolean m_showTrace = true;
    protected boolean m_forceShowTrace;
    protected boolean m_showSuccess = true;
    protected boolean m_showBanner = true;
    protected boolean m_isOk = true;
    protected long m_startTime;
    protected int m_currentTestIndex;
    protected int m_currentTestSuiteSize;
    protected Hashtable m_contexts = new Hashtable();

    public void setShowSuccess(boolean bl) {
        this.m_showSuccess = bl;
    }

    public void setShowBanner(boolean bl) {
        this.m_showBanner = bl;
    }

    public void setShowTrace(boolean bl) {
        this.m_showTrace = bl;
    }

    public void setForceShowTrace(boolean bl) {
        this.m_forceShowTrace = bl;
    }

    public void destroy() {
    }

    protected TestletContext getContextFor(String string) {
        TestletContext testletContext = (TestletContext)this.m_contexts.get(string);
        if (null != testletContext) {
            return testletContext;
        }
        DefaultTestletContext defaultTestletContext = new DefaultTestletContext(this, string);
        defaultTestletContext.setInitParameter("code", string);
        defaultTestletContext.setListener(this.getListener());
        this.m_contexts.put(string, defaultTestletContext);
        return defaultTestletContext;
    }

    protected TestResultListener getListener() {
        return this;
    }

    public Testlet getTestletNamed(String string) {
        Testlet testlet = null;
        TestletContext testletContext = this.getContextFor(string);
        String string2 = testletContext.getInitParameter("code", string);
        try {
            Class<?> clazz = Class.forName(string2);
            testlet = (Testlet)clazz.newInstance();
        }
        catch (Throwable throwable) {
            this.output("Error: Failed to create testlet " + string + " due to " + throwable + "\n");
            this.m_isOk = false;
            testlet = null;
        }
        return testlet;
    }

    protected void initialize() {
    }

    public boolean isOk() {
        return this.m_isOk;
    }

    protected void loadConfigurations(String string) {
        if (null == string) {
            return;
        }
        this.loadConfigurationsViaProperties(string);
    }

    protected void loadConfigurationsViaProperties(String string) {
        if (null == string) {
            return;
        }
        try {
            URL uRL = new URL("file:" + new File("./").getAbsolutePath());
            URL uRL2 = new URL(uRL, string);
            InputStream inputStream = uRL2.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.endsWith(".code")) continue;
                String string3 = string2.substring(0, string2.length() - 5);
                String string4 = properties.getProperty(string2);
                DefaultTestletContext defaultTestletContext = new DefaultTestletContext(this, string3);
                defaultTestletContext.setInitParameter("code", string4);
                defaultTestletContext.setListener(this.getListener());
                this.m_contexts.put(string3, defaultTestletContext);
                this.m_testlets.addElement(string3);
                String string5 = string3 + ".parameter.";
                int n = string5.length();
                Enumeration<?> enumeration2 = properties.propertyNames();
                while (enumeration2.hasMoreElements()) {
                    String string6 = (String)enumeration2.nextElement();
                    if (!string6.startsWith(string5)) continue;
                    String string7 = string6.substring(n);
                    String string8 = properties.getProperty(string6);
                    defaultTestletContext.setInitParameter(string7, string8);
                }
            }
        }
        catch (Throwable throwable) {
            this.output("Failed to load resources from '" + string + "' due to " + throwable);
            this.m_isOk = false;
        }
    }

    public abstract void output(String var1);

    protected void parseArguments(CLArgsParser cLArgsParser) {
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        Object var4_4 = null;
        int n2 = 0;
        while (n2 < n) {
            CLOption cLOption = (CLOption)vector.elementAt(n2);
            switch (cLOption.getId()) {
                case 0: {
                    this.m_testlets.addElement(cLOption.getArgument());
                    break;
                }
                case 104: {
                    this.usage(this.m_options);
                    this.m_isOk = false;
                    return;
                }
                case 99: {
                    this.m_config = cLOption.getArgument();
                    break;
                }
                case 98: {
                    this.m_showBanner = cLOption.getArgument().equalsIgnoreCase("true");
                    break;
                }
                case 102: {
                    this.m_forceShowTrace = cLOption.getArgument().equalsIgnoreCase("true");
                    break;
                }
                case 116: {
                    this.m_showTrace = cLOption.getArgument().equalsIgnoreCase("true");
                    break;
                }
                case 115: {
                    this.m_showSuccess = cLOption.getArgument().equalsIgnoreCase("true");
                }
            }
            ++n2;
        }
    }

    protected void processTestlet(String string) {
        Testlet testlet = this.getTestletNamed(string);
        if (null == testlet) {
            this.output("Warning: Failed to aquire testlet named " + string + "\n");
            this.m_isOk = false;
            return;
        }
        testlet.setName(string);
        this.processTestlet(testlet);
    }

    protected void testletPreamble(Testlet testlet, TestletContext testletContext) {
        if (this.m_showBanner) {
            this.output("Testing Testlet " + testlet.getName() + " (" + this.m_currentTestSuiteSize + " tests)\n\n");
        }
    }

    public void processTestlet(Testlet testlet, TestletContext testletContext) {
        TestSuite testSuite = testlet.getTestSuite();
        this.m_currentTestSuiteSize = testSuite.getTestCaseCount();
        this.testletPreamble(testlet, testletContext);
        TestResultListener testResultListener = testletContext.getListener();
        this.m_currentTestIndex = 0;
        while (this.m_currentTestIndex < this.m_currentTestSuiteSize) {
            block9: {
                TestResultEvent testResultEvent;
                TestResultEvent testResultEvent2;
                try {
                    testResultEvent2 = new TestResultEvent(testlet, testlet.getName(), 0);
                    testResultListener.testEvent(testResultEvent2);
                    testlet.initialize(testletContext);
                }
                catch (Throwable throwable) {
                    testResultEvent = new TestResultEvent(testlet, testlet.getName(), 3, "Test failed during initialization - " + throwable, throwable);
                    testResultListener.testEvent(testResultEvent);
                    break block9;
                }
                try {
                    testSuite.runTestCase(this.m_currentTestIndex);
                    testResultEvent2 = new TestResultEvent(testlet, testlet.getName(), 1);
                    testResultListener.testEvent(testResultEvent2);
                }
                catch (TestFailedException testFailedException) {
                    testResultEvent = new TestResultEvent(testlet, testlet.getName(), 2, "Test Failed: " + testFailedException.getMessage(), testFailedException);
                    testResultListener.testEvent(testResultEvent);
                }
                catch (Throwable throwable) {
                    TestResultEvent testResultEvent3 = new TestResultEvent(testlet, testlet.getName(), 3, "Test Failed: " + throwable, throwable);
                    testResultListener.testEvent(testResultEvent3);
                    break block9;
                }
                try {
                    testlet.destroy();
                }
                catch (Throwable throwable) {
                    testResultEvent = new TestResultEvent(testlet, testlet.getName(), 3, "Test failed during destroy - " + throwable, throwable);
                    testResultListener.testEvent(testResultEvent);
                }
            }
            ++this.m_currentTestIndex;
        }
        if (this.m_showBanner) {
            this.output("\n\n");
        }
    }

    public void processTestlet(Testlet testlet) {
        TestletContext testletContext = this.getContextFor(testlet.getName());
        this.processTestlet(testlet, testletContext);
    }

    protected void processTestlets(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            this.processTestlet(string);
            ++n2;
        }
    }

    public void runEngine(String[] stringArray) {
        try {
            this.m_isOk = true;
            this.m_options = this.setupLongOptions();
            CLArgsParser cLArgsParser = new CLArgsParser(stringArray, this.m_options);
            if (cLArgsParser.getErrorString() != null) {
                this.output("Error: " + cLArgsParser.getErrorString() + "\n");
                return;
            }
            this.parseArguments(cLArgsParser);
            if (!this.isOk()) {
                return;
            }
            this.loadConfigurations(this.m_config);
            if (!this.isOk()) {
                return;
            }
            this.initialize();
            if (!this.isOk()) {
                return;
            }
            this.processTestlets(this.m_testlets);
            this.destroy();
        }
        catch (Throwable throwable) {
            System.out.println("Error: " + throwable.toString());
            this.m_isOk = false;
        }
    }

    protected CLOptionDescriptor[] setupLongOptions() {
        CLOptionDescriptor[] cLOptionDescriptorArray = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "display this help"), new CLOptionDescriptor("config", 2, 99, "indicate a name of a configuration file to read test properties from."), new CLOptionDescriptor("show-success", 2, 115, "a boolean (true|false) indicating whether success should be displayed."), new CLOptionDescriptor("show-trace", 2, 116, "a boolean (true|false) indicating whether stack traces should be displayed on errors."), new CLOptionDescriptor("force-show-trace", 2, 102, "a boolean (true|false) indicating whether stack traces should be displayed on fails."), new CLOptionDescriptor("show-banner", 2, 98, "a boolean (true|false) indicating whether banners should be displayed at startup and as each testlet is executed.")};
        return cLOptionDescriptorArray;
    }

    public void testEvent(TestResultEvent testResultEvent) {
        int n = testResultEvent.getResultCode();
        if (n == 0) {
            this.m_startTime = System.currentTimeMillis();
            return;
        }
        if (testResultEvent.getResultCode() != 1) {
            this.m_isOk = false;
        } else if (!this.m_showSuccess) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Test ");
        stringBuffer.append(this.m_currentTestIndex + 1);
        stringBuffer.append('/');
        stringBuffer.append(this.m_currentTestSuiteSize);
        stringBuffer.append(" ( ");
        stringBuffer.append(testResultEvent.getName());
        stringBuffer.append(" ): ");
        stringBuffer.append(TestResultEvent.getDescriptionFor(n));
        stringBuffer.append(" (Duration = ");
        stringBuffer.append(System.currentTimeMillis() - this.m_startTime);
        stringBuffer.append(")");
        if (null != testResultEvent.getMessage()) {
            stringBuffer.append("\n\tReason: ");
            stringBuffer.append(testResultEvent.getMessage());
        }
        Throwable throwable = testResultEvent.getThrowable();
        if (this.m_showTrace && null != throwable && (!(throwable instanceof TestFailedException) || this.m_forceShowTrace)) {
            stringBuffer.append("\n\t");
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(stringWriter);
        }
        stringBuffer.append("\n");
        this.output(stringBuffer.toString());
    }

    protected void usage(CLOptionDescriptor[] cLOptionDescriptorArray) {
        System.out.println("java " + this.getClass().getName() + " [" + "option" + "] " + " files ");
        System.out.println("\tAvailable options:");
        System.out.print(CLUtil.describeOptions(cLOptionDescriptorArray));
    }
}

