/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.turbine.torque.engine.database.model.AppData;
import org.apache.turbine.torque.engine.database.model.Database;
import org.apache.turbine.torque.engine.database.transform.XmlToAppData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.ant.TexenTask;

public class TorqueDataDumpTask
extends TexenTask {
    private AppData app;
    private String databaseName;
    private String xmlFile;
    private String databaseUrl;
    private String databaseDriver;
    private String databaseUser;
    private String databasePassword;

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String v) {
        this.xmlFile = v;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String v) {
        this.databaseName = v;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String v) {
        this.databaseUrl = v;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String v) {
        this.databaseDriver = v;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String v) {
        this.databaseUser = v;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String v) {
        this.databasePassword = v;
    }

    public Context initControlContext() {
        VelocityContext context = new VelocityContext();
        XmlToAppData xmlParser = new XmlToAppData();
        this.app = xmlParser.parseFile(this.xmlFile);
        Database dbm = this.app.getDatabase(this.databaseName);
        if (dbm == null) {
            dbm = this.app.getDatabases()[0];
        }
        context.put("databaseModel", (Object)dbm);
        context.put("dataset", (Object)"all");
        System.err.println("Your DB settings are:");
        System.err.println("driver : " + this.databaseDriver);
        System.err.println("URL : " + this.databaseUrl);
        System.err.println("user : " + this.databaseUser);
        System.err.println("password : " + this.databasePassword);
        try {
            Class.forName(this.databaseDriver);
            System.err.println("DB driver sucessfuly instantiated");
            Connection conn = DriverManager.getConnection(this.databaseUrl, this.databaseUser, this.databasePassword);
            System.err.println("DB connection established");
            context.put("tableTool", (Object)new TableTool(conn));
        }
        catch (SQLException se) {
            System.err.println("SQLException while connecting to DB:");
            se.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("cannot load driver:");
            cnfe.printStackTrace();
        }
        return context;
    }

    public class TableTool
    implements Iterator {
        private Connection conn;
        private ResultSet rs;
        private boolean isEmpty;

        public TableTool fetch(String tableName) throws SQLException {
            System.err.println();
            System.err.print("fetching table " + tableName);
            TorqueDataDumpTask torqueDataDumpTask = TorqueDataDumpTask.this;
            if (torqueDataDumpTask == null) {
                throw null;
            }
            return torqueDataDumpTask.new TableTool(this.conn.createStatement().executeQuery("SELECT * FROM " + tableName));
        }

        public boolean hasNext() {
            try {
                return !(this.rs.isLast() || this.isEmpty);
            }
            catch (SQLException se) {
                System.err.println("SQLException :");
                se.printStackTrace();
                return false;
            }
        }

        public Object next() throws NoSuchElementException {
            try {
                System.err.print(".");
                this.rs.next();
            }
            catch (SQLException se) {
                System.err.println("SQLException while iterating:");
                se.printStackTrace();
                throw new NoSuchElementException(se.getMessage());
            }
            return this;
        }

        public String get(String columnName) {
            try {
                return this.rs.getString(columnName);
            }
            catch (SQLException se) {
                System.err.println("SQLException fetching value " + columnName + ":" + se.getMessage());
                return null;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public TableTool(Connection conn) {
            this.conn = conn;
        }

        public TableTool(ResultSet rs) throws SQLException {
            this.rs = rs;
            this.isEmpty = !rs.isBeforeFirst();
        }
    }
}

