/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql.jdbc2;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.jdbc2.Blob;
import org.gjt.mm.mysql.jdbc2.NotImplemented;
import org.gjt.mm.mysql.jdbc2.PreparedStatement;
import org.gjt.mm.mysql.jdbc2.ResultSetMetaData;

public class ResultSet
extends org.gjt.mm.mysql.ResultSet
implements java.sql.ResultSet {
    private static final String UPDATEABLE_MESSAGE = "Result Set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details.";
    protected String _UpdateSQL = null;
    protected String _DeleteSQL = null;
    protected String _InsertSQL = null;
    protected String _RefreshSQL = null;
    protected PreparedStatement _Refresher;
    protected PreparedStatement _Updater = null;
    protected PreparedStatement _Inserter = null;
    protected PreparedStatement _Deleter = null;
    protected Vector _PrimaryKeyIndicies = null;
    protected boolean _updatable = false;
    protected boolean _doing_updates = false;
    protected boolean _on_insert_row = false;
    protected int _fetch_direction = 1000;
    protected int _fetch_size = 0;
    private static String quotedIdChar = null;

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this._rows, this._fields);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new NotImplemented();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new NotImplemented();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            if (string.length() == 0) {
                BigDecimal bigDecimal = new BigDecimal(0.0);
                return bigDecimal;
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(string);
                return bigDecimal;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this._fields[n - 1] + ").", "S1009");
            }
        }
        return null;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        String string2 = this.getString(string);
        if (string2 != null) {
            if (string2.length() == 0) {
                BigDecimal bigDecimal = new BigDecimal(0.0);
                return bigDecimal;
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(string2);
                return bigDecimal;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for BigDecimal '" + string2 + "' in column " + string + ".", "S1009");
            }
        }
        return null;
    }

    public boolean next() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        return super.next();
    }

    public boolean isBeforeFirst() throws SQLException {
        boolean bl = false;
        bl = this._rows.size() == 0 ? false : this._currentRow == -1;
        return bl;
    }

    public boolean isAfterLast() throws SQLException {
        boolean bl = false;
        bl = this._rows.size() == 0 ? false : this._currentRow >= this._rows.size();
        return bl;
    }

    public boolean isFirst() throws SQLException {
        boolean bl = false;
        bl = this._rows.size() == 0 ? false : this._currentRow == 0;
        return bl;
    }

    public boolean isLast() throws SQLException {
        boolean bl = false;
        bl = this._rows.size() == 0 ? false : this._currentRow == this._rows.size() - 1;
        return bl;
    }

    public void beforeFirst() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (this._rows.size() == 0) {
            return;
        }
        this._currentRow = -1;
        this._thisRow = null;
    }

    public void afterLast() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (this._rows.size() != 0) {
            this._currentRow = this._rows.size();
            this._thisRow = null;
        }
    }

    public boolean first() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._rows.size() == 0) {
            return false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        this._currentRow = 0;
        this._thisRow = (byte[][])this._rows.elementAt(this._currentRow);
        return true;
    }

    public boolean last() throws SQLException {
        if (this._rows.size() == 0) {
            return false;
        }
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        this._currentRow = this._rows.size() - 1;
        this._thisRow = (byte[][])this._rows.elementAt(this._currentRow);
        return true;
    }

    public int getRow() throws SQLException {
        int n = 0;
        n = this._currentRow < 0 || this._currentRow >= this._rows.size() || this._rows.size() == 0 ? 0 : this._currentRow + 1;
        return n;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl;
        if (this._rows.size() == 0) {
            bl = false;
        } else {
            if (n == 0) {
                throw new SQLException("Cannot absolute position to row 0", "S1009");
            }
            if (this._on_insert_row) {
                this._on_insert_row = false;
            }
            if (this._doing_updates) {
                this._doing_updates = false;
            }
            if (n == 1) {
                bl = this.first();
            } else if (n == -1) {
                bl = this.last();
            } else if (n > this._rows.size()) {
                this.afterLast();
                bl = false;
            } else if (n < 0) {
                int n2 = this._rows.size() + n + 1;
                if (n2 <= 0) {
                    this.beforeFirst();
                    bl = false;
                } else {
                    bl = this.absolute(n2);
                }
            } else {
                this._currentRow = --n;
                this._thisRow = (byte[][])this._rows.elementAt(this._currentRow);
                bl = true;
            }
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        if (this._rows.size() == 0) {
            return false;
        }
        int n2 = this._currentRow + n + 1;
        boolean bl = this.absolute(n2);
        return bl;
    }

    public boolean previous() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        return this.prev();
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001) {
            throw new SQLException("Illegal value for fetch direction", "S1009");
        }
        this._fetch_direction = n;
    }

    public int getFetchDirection() throws SQLException {
        return this._fetch_direction;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Value must be between 0 and getMaxRows()", "S1009");
        }
        this._fetch_size = n;
    }

    public int getFetchSize() throws SQLException {
        return this._fetch_size;
    }

    public int getType() throws SQLException {
        return this._resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this._updatable ? 1008 : 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public void updateNull(int n) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setNull(n, 0);
        } else {
            this._Inserter.setNull(n, 0);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBoolean(n, bl);
        } else {
            this._Inserter.setBoolean(n, bl);
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setByte(n, by);
        } else {
            this._Inserter.setByte(n, by);
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setShort(n, s);
        } else {
            this._Inserter.setShort(n, s);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setInt(n, n2);
        } else {
            this._Inserter.setInt(n, n2);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setLong(n, l);
        } else {
            this._Inserter.setLong(n, l);
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setFloat(n, f);
        } else {
            this._Inserter.setFloat(n, f);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setDouble(n, d);
        } else {
            this._Inserter.setDouble(n, d);
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBigDecimal(n, bigDecimal);
        } else {
            this._Inserter.setBigDecimal(n, bigDecimal);
        }
    }

    public void updateString(int n, String string) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setString(n, string);
        } else {
            this._Inserter.setString(n, string);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBytes(n, byArray);
        } else {
            this._Inserter.setBytes(n, byArray);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setDate(n, date);
        } else {
            this._Inserter.setDate(n, date);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setTime(n, time);
        } else {
            this._Inserter.setTime(n, time);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setTimestamp(n, timestamp);
        } else {
            this._Inserter.setTimestamp(n, timestamp);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setAsciiStream(n, inputStream, n2);
        } else {
            this._Inserter.setAsciiStream(n, inputStream, n2);
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBinaryStream(n, inputStream, n2);
        } else {
            this._Inserter.setBinaryStream(n, inputStream, n2);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setCharacterStream(n, reader, n2);
        } else {
            this._Inserter.setCharacterStream(n, reader, n2);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setObject(n, object);
        } else {
            this._Inserter.setObject(n, object);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setObject(n, object);
        } else {
            this._Inserter.setObject(n, object);
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        if (!this._on_insert_row) {
            throw new SQLException("Not on insert row");
        }
        this._Inserter.executeUpdate();
        int n = 0;
        if (this._PrimaryKeyIndicies != null) {
            n = this._PrimaryKeyIndicies.size();
        }
        long l = this._Inserter.getLastInsertID();
        int n2 = this._fields.length;
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        while (n3 < n2) {
            byArrayArray[n3] = (byte[])(this._Inserter.isNull(n3) ? null : this._Inserter.getBytes(n3));
            if (n == 1 && this._fields[n3].isPrimaryKey() && l > 0L) {
                byArrayArray[n3] = String.valueOf(l).getBytes();
            }
            ++n3;
        }
        this._rows.addElement(byArrayArray);
        this.resetInserter();
    }

    public void updateRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException(UPDATEABLE_MESSAGE, "S1000");
        }
        if (this._doing_updates) {
            this._Updater.executeUpdate();
            this.refreshRow();
            this._doing_updates = false;
        }
        this.syncUpdate();
    }

    public void deleteRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException(UPDATEABLE_MESSAGE, "S1000");
        }
        if (this._on_insert_row) {
            throw new SQLException("Can not call deleteRow() when on insert row");
        }
        if (this._rows.size() == 0) {
            throw new SQLException("Can't deleteRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call deleteRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call deleteRow().");
        }
        if (this._Deleter == null) {
            if (this._DeleteSQL == null) {
                this.generateStatements();
            }
            this._Deleter = (PreparedStatement)this._connection.prepareStatement(this._DeleteSQL);
        }
        this._Deleter.clearParameters();
        String string = null;
        if (this._connection.useUnicode()) {
            string = this._connection.getEncoding();
        }
        try {
            int n = this._PrimaryKeyIndicies.size();
            if (n == 1) {
                int n2 = (Integer)this._PrimaryKeyIndicies.elementAt(0);
                String string2 = string == null ? new String(this._thisRow[n2]) : new String(this._thisRow[n2], string);
                this._Deleter.setString(1, string2);
            } else {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = (Integer)this._PrimaryKeyIndicies.elementAt(n3);
                    String string3 = string == null ? new String(this._thisRow[n4]) : new String(this._thisRow[n4], string);
                    this._Deleter.setString(n3 + 1, string3);
                    ++n3;
                }
            }
            this._Deleter.executeUpdate();
            this._rows.removeElementAt(this._currentRow);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + this._connection.getEncoding() + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException(UPDATEABLE_MESSAGE, "S1000");
        }
        if (this._on_insert_row) {
            throw new SQLException("Can not call refreshRow() when on insert row");
        }
        if (this._rows.size() == 0) {
            throw new SQLException("Can't refreshRow() on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new SQLException("Before start of result set. Can not call refreshRow().");
        }
        if (this.isAfterLast()) {
            throw new SQLException("After end of result set. Can not call refreshRow().");
        }
        if (this._Refresher == null) {
            if (this._RefreshSQL == null) {
                this.generateStatements();
            }
            this._Refresher = (PreparedStatement)this._connection.prepareStatement(this._RefreshSQL);
        }
        this._Refresher.clearParameters();
        String string = null;
        if (this._connection.useUnicode()) {
            string = this._connection.getEncoding();
        }
        try {
            int n;
            int n2 = this._PrimaryKeyIndicies.size();
            if (n2 == 1) {
                n = (Integer)this._PrimaryKeyIndicies.elementAt(0);
                String string2 = string == null ? new String(this._thisRow[n]) : new String(this._thisRow[n], string);
                this._Refresher.setString(1, string2);
            } else {
                n = 0;
                while (n < n2) {
                    int n3 = (Integer)this._PrimaryKeyIndicies.elementAt(n);
                    String string3 = string == null ? new String(this._thisRow[n3]) : new String(this._thisRow[n3], string);
                    this._Refresher.setString(n + 1, string3);
                    ++n;
                }
            }
            java.sql.ResultSet resultSet = null;
            try {
                resultSet = this._Refresher.executeQuery();
                int n4 = resultSet.getMetaData().getColumnCount();
                if (!resultSet.next()) throw new SQLException("refreshRow() called on row that has been deleted or had primary key changed", "S1000");
                int n5 = 0;
                while (n5 < n4) {
                    byte[] byArray = resultSet.getBytes(n5 + 1);
                    this._thisRow[n5] = (byte[])(byArray == null || resultSet.wasNull() ? null : resultSet.getBytes(n5 + 1));
                    ++n5;
                }
                Object var8_12 = null;
                if (resultSet == null) return;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (resultSet == null) throw throwable;
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                resultSet.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + this._connection.getEncoding() + "'");
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this._doing_updates) {
            this._doing_updates = false;
            this._Updater.clearParameters();
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException(UPDATEABLE_MESSAGE, "S1000");
        }
        if (this._Inserter == null) {
            this.generateStatements();
            this._Inserter = (PreparedStatement)this._connection.prepareStatement(this._InsertSQL);
            this.resetInserter();
        } else {
            this.resetInserter();
        }
        this._on_insert_row = true;
        this._doing_updates = false;
    }

    public void moveToCurrentRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException(UPDATEABLE_MESSAGE, "S1000");
        }
        this._on_insert_row = false;
    }

    public Statement getStatement() throws SQLException {
        return (Statement)((Object)this._owningStatement);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(int n) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.Blob getBlob(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this._fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this._fields.length + ").", "S1002");
        }
        try {
            this._wasNullFlag = this._thisRow[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this._wasNullFlag = true;
        }
        if (this._wasNullFlag) {
            return null;
        }
        return new Blob(this._thisRow[n - 1]);
    }

    public Clob getClob(int n) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(int n) throws SQLException {
        throw new NotImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(String string) throws SQLException {
        throw new NotImplemented();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new NotImplemented();
    }

    public ResultSet(Field[] fieldArray, Vector vector, Connection connection) {
        super(fieldArray, vector, connection);
        this._updatable = this.isUpdateable();
    }

    public ResultSet(Field[] fieldArray, Vector vector) {
        super(fieldArray, vector);
    }

    public ResultSet(long l, long l2) {
        super(l, l2);
    }

    protected void generateStatements() throws SQLException {
        if (!this._updatable) {
            throw new SQLException("ResultSet not updatable");
        }
        boolean bl = this._connection.supportsQuotedIdentifiers();
        String string = this.getQuotedIdChar();
        String string2 = this._fields[0].getTableName();
        this._PrimaryKeyIndicies = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 0;
        while (n < this._fields.length) {
            if (this._fields[n].isPrimaryKey()) {
                this._PrimaryKeyIndicies.addElement(new Integer(n));
                if (!bl3) {
                    stringBuffer2.append(" AND ");
                } else {
                    bl3 = false;
                }
                if (bl) {
                    stringBuffer2.append(string);
                }
                stringBuffer2.append(this._fields[n].getName());
                if (bl) {
                    stringBuffer2.append(string);
                }
                stringBuffer2.append("=?");
            }
            if (bl2) {
                bl2 = false;
                stringBuffer.append("SET ");
            } else {
                stringBuffer.append(",");
                stringBuffer3.append(",");
                stringBuffer4.append(",");
            }
            stringBuffer4.append("?");
            if (bl) {
                stringBuffer3.append(string);
            }
            stringBuffer3.append(this._fields[n].getName());
            if (bl) {
                stringBuffer3.append(string);
            }
            if (bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this._fields[n].getName());
            if (bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append("=?");
            ++n;
        }
        String string3 = bl ? string : "";
        this._UpdateSQL = "UPDATE " + string3 + string2 + string3 + " " + stringBuffer.toString() + " WHERE " + stringBuffer2.toString();
        this._InsertSQL = "INSERT INTO " + string3 + string2 + string3 + " (" + stringBuffer3.toString() + ") VALUES (" + stringBuffer4.toString() + ")";
        this._RefreshSQL = "SELECT " + stringBuffer3.toString() + " FROM " + string3 + string2 + string3 + " WHERE " + stringBuffer2.toString();
        this._DeleteSQL = "DELETE FROM " + string3 + string2 + string3 + " WHERE " + stringBuffer2.toString();
    }

    private synchronized String getQuotedIdChar() throws SQLException {
        if (quotedIdChar == null) {
            DatabaseMetaData databaseMetaData = this._connection.getMetaData();
            quotedIdChar = databaseMetaData.getIdentifierQuoteString();
        }
        return quotedIdChar;
    }

    void syncUpdate() throws SQLException {
        if (this._Updater == null) {
            if (this._UpdateSQL == null) {
                this.generateStatements();
            }
            this._Updater = (PreparedStatement)this._connection.prepareStatement(this._UpdateSQL);
        }
        int n = this._fields.length;
        this._Updater.clearParameters();
        int n2 = 0;
        while (n2 < n) {
            if (this._thisRow[n2] != null) {
                this._Updater.setBytes(n2 + 1, this._thisRow[n2]);
            } else {
                this._Updater.setNull(n2 + 1, 0);
            }
            ++n2;
        }
        int n3 = this._PrimaryKeyIndicies.size();
        if (n3 == 1) {
            int n4 = (Integer)this._PrimaryKeyIndicies.elementAt(0);
            this._Updater.setBytes(n + 1, this._thisRow[(Integer)this._PrimaryKeyIndicies.elementAt(0)]);
        } else {
            int n5 = 0;
            while (n5 < n3) {
                byte[] byArray = this._thisRow[(Integer)this._PrimaryKeyIndicies.elementAt(n5)];
                if (byArray != null) {
                    this._Updater.setBytes(n + n5 + 1, byArray);
                } else {
                    this._Updater.setNull(n + n5 + 1, 0);
                }
                ++n5;
            }
        }
    }

    boolean isUpdateable() {
        int n;
        if (this._fields.length > 0) {
            String string = this._fields[0].getTableName();
            n = 1;
            while (n < this._fields.length) {
                if (string == null || !this._fields[n].getTableName().equals(string)) {
                    return false;
                }
                ++n;
            }
            if (string == null || string.length() == 0) {
                return false;
            }
        } else {
            return false;
        }
        boolean bl = false;
        n = 0;
        while (n < this._fields.length) {
            if (this._fields[n].isPrimaryKey()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    int getResultSetType() {
        return 0;
    }

    private void resetUpdater() throws SQLException {
        this._Updater.clearParameters();
        int n = 0;
        while (n < this._fields.length) {
            this._Updater.setNull(n + 1, 0);
            ++n;
        }
    }

    private void resetInserter() throws SQLException {
        this._Inserter.clearParameters();
        int n = 0;
        while (n < this._fields.length) {
            this._Inserter.setNull(n + 1, 0);
            ++n;
        }
    }

    protected void setResultSetConcurrency(int n) {
        super.setResultSetConcurrency(n);
        if (n == 1008 && !this.isUpdateable()) {
            SQLWarning sQLWarning = new SQLWarning(UPDATEABLE_MESSAGE);
        }
    }
}

