/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.container.helper;

import java.util.Vector;
import tyrex.security.container.RoleCredentials;

public class RolesRealm {
    private String _realmName;
    private String[] _defaultRoles;
    private Role[] _roles;

    protected RolesRealm(String string, String[] stringArray) {
        if (string == null) {
            throw new IllegalArgumentException("Argument 'realmName' is null");
        }
        this._realmName = string;
        this._defaultRoles = stringArray;
    }

    protected void addRole(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Argument 'roleName' or 'members' is null");
        }
        if (this._roles == null) {
            this._roles = new Role[1];
            this._roles[0] = new Role(string, stringArray);
            return;
        }
        int n = 0;
        while (n < this._roles.length) {
            if (this._roles[n].getRoleName().equals(string)) {
                this._roles[n].addMembers(stringArray);
                return;
            }
            ++n;
        }
        Role[] roleArray = new Role[this._roles.length + 1];
        int n2 = 0;
        while (n2 < this._roles.length) {
            roleArray[n2] = this._roles[n2];
            ++n2;
        }
        roleArray[this._roles.length] = new Role(string, stringArray);
        this._roles = roleArray;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public RoleCredentials getRoleCredentials(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        if (this._roles != null) {
            n = 0;
            while (n < this._roles.length) {
                Role role = this._roles[n];
                if (this._roles[n].isInRole(string)) {
                    vector.add(this._roles[n].getRoleName());
                }
                ++n;
            }
        }
        if (this._defaultRoles != null) {
            n = 0;
            while (n < this._defaultRoles.length) {
                vector.add(this._defaultRoles[n]);
                ++n;
            }
        }
        return new RoleCredentials(vector.toArray(new String[vector.size()]));
    }

    public String[] listMembers(String string) {
        int n = 0;
        while (n < this._roles.length) {
            if (this._roles[n].getRoleName().equals(string)) {
                return this._roles[n].listMembers();
            }
            ++n;
        }
        return new String[0];
    }

    public String[] listRoles() {
        String[] stringArray = new String[this._roles.length];
        int n = 0;
        while (n < this._roles.length) {
            stringArray[n] = this._roles[n].getRoleName();
            ++n;
        }
        return stringArray;
    }

    static class Role {
        private String _roleName;
        private MemberEntry[] _members;
        private static final int MemberTableSize = 29;

        Role(String string, String[] stringArray) {
            this._roleName = string;
            this._members = new MemberEntry[29];
            this.addMembers(stringArray);
        }

        void addMembers(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = (stringArray[n].hashCode() & Integer.MAX_VALUE) % this._members.length;
                MemberEntry memberEntry = this._members[n2];
                while (memberEntry != null && !memberEntry.member.equals(stringArray[n])) {
                    memberEntry = memberEntry.next;
                }
                if (memberEntry == null) {
                    this._members[n2] = memberEntry = new MemberEntry(stringArray[n], this._members[n2]);
                }
                ++n;
            }
        }

        String getRoleName() {
            return this._roleName;
        }

        boolean isInRole(String string) {
            int n = (string.hashCode() & Integer.MAX_VALUE) % this._members.length;
            MemberEntry memberEntry = this._members[n];
            while (memberEntry != null && !memberEntry.member.equals(string)) {
                memberEntry = memberEntry.next;
            }
            return memberEntry != null;
        }

        String[] listMembers() {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this._members.length) {
                MemberEntry memberEntry = this._members[n];
                while (memberEntry != null) {
                    vector.add(memberEntry.member);
                    memberEntry = memberEntry.next;
                }
                ++n;
            }
            return vector.toArray(new String[vector.size()]);
        }

        static class MemberEntry {
            String member;
            MemberEntry next;

            MemberEntry(String string, MemberEntry memberEntry) {
                this.member = string;
                this.next = memberEntry;
            }
        }
    }
}

