/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.BidirectionalPipeService;
import net.jxta.impl.util.IncomingMessageQueue;
import net.jxta.impl.util.OutgoingMessageQueue;
import net.jxta.impl.util.SchedulerService;
import net.jxta.impl.util.Timer;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;

public class ReliablePipeService {
    BidirectionalPipeService bidirPipeService;
    SchedulerService schedulerService;
    static final String RELIABLE_HEADER = "RELIABLE_HEADER";
    static final int SYN = 1;
    static final int SYN_ACK = 2;
    static final int MSG = 3;
    static final int ACK = 4;
    static final int FIN1 = 5;
    static final int FIN2 = 6;
    static final int ESTABLISHING = 1;
    static final int CONNECTED = 2;
    static final int TIMED_OUT = 3;
    static final int CLOSE_WAIT = 4;
    static final int CLOSED = 5;
    static final int MAX_RETRANSMITS = 5;
    static final int MSG_TIMEOUT = 30000;
    static final int RETRANSMIT_TIMEOUT = 1000;
    static final int WINDOW_FLUSH_TIMEOUT = 500;

    public ReliablePipeService(BidirectionalPipeService bidirPipeService) {
        this.bidirPipeService = bidirPipeService;
        this.schedulerService = new SchedulerService();
        new Thread(this.schedulerService).start();
    }

    public Pipe connect(PipeAdvertisement adv, int maxTimeout) throws IOException {
        long start = System.currentTimeMillis();
        BidirectionalPipeService.Pipe bidirPipe = this.bidirPipeService.connect(adv, maxTimeout);
        if ((maxTimeout = (int)((long)maxTimeout - (System.currentTimeMillis() - (long)maxTimeout))) > 0) {
            return new Pipe(bidirPipe, maxTimeout);
        }
        throw new IOException("Connect timed out.");
    }

    public AcceptPipe bind(String pipeName) throws IOException {
        return new AcceptPipe(this.bidirPipeService.bind(pipeName));
    }

    public class Pipe
    implements InputPipe,
    OutputPipe {
        IncomingMessageQueue incomingQueue;
        IncomingMessageQueue incomingQueue2;
        OutgoingMessageQueue outgoingQueue;
        HashMap pendingRetransmits;
        long outgoingSeq;
        long highestInSeq;
        long lastAckedSeq;
        InputPipe inputPipe;
        OutputPipe outputPipe;
        Receiver receiver;
        Sender sender;
        int outgoingWindow;
        int state;
        boolean running;

        Pipe(BidirectionalPipeService.Pipe bidirPipe, long maxTimeout) throws IOException {
            this.inputPipe = bidirPipe.getInputPipe();
            this.outputPipe = bidirPipe.getOutputPipe();
            this.incomingQueue = new IncomingMessageQueue(512);
            this.incomingQueue2 = new IncomingMessageQueue(512);
            this.outgoingQueue = new OutgoingMessageQueue(512);
            this.pendingRetransmits = new HashMap();
            this.state = 1;
            this.establish(maxTimeout);
            this.receiver = new Receiver();
            new Thread(this.receiver).start();
        }

        public InputPipe getInputPipe() {
            return this;
        }

        public OutputPipe getOutputPipe() {
            return this;
        }

        void establish(long maxTimeout) throws IOException {
            this.sendMsg(1, 0L, 0);
            try {
                while (this.state == 1) {
                    this.wait(maxTimeout);
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while establishing connection.");
            }
            if (this.state != 2) {
                throw new IOException("Connect timed out.");
            }
            this.sender = new Sender();
            new Thread(this.sender).start();
        }

        public void close() {
            if (this.state != 4) {
                this.state = 4;
                try {
                    this.sendMsg(5, -1L, 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public synchronized void send(Message msg) throws IOException {
            switch (this.state) {
                case 1: {
                    throw new Error("Should never be here.  Theis state is only while the contructor is running.");
                }
                case 2: {
                    try {
                        this.outgoingQueue.enqueue(msg);
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Thread was interrupted while in send(): " + e.getMessage());
                    }
                }
                case 3: {
                    throw new IOException("The peer at the other end has dropped the connection.");
                }
                case 4: {
                    throw new IOException("Shutdown in progress.");
                }
                case 5: {
                    throw new IOException("Connection has closed.");
                }
            }
        }

        public synchronized Message waitForMessage() throws InterruptedException {
            return this.poll(-1);
        }

        public synchronized Message poll(int msgTimeout) throws InterruptedException {
            return this.incomingQueue.pop(msgTimeout);
        }

        synchronized void process(Message msg) throws IOException {
            DataInputStream header = new DataInputStream(msg.getElement(ReliablePipeService.RELIABLE_HEADER).getStream());
            long seq = header.readLong();
            int type = header.readInt();
            int window = header.readInt();
            if (type != 1 && type != 2 && type != 4) {
                this.incomingQueue2.put(msg, seq);
                this.highestInSeq = this.incomingQueue2.popUntilBreakInSequence(this.highestInSeq);
                this.sendMsg(4, this.highestInSeq, this.incomingQueue.getFreeSlots());
            }
            switch (this.state) {
                case 1: {
                    switch (type) {
                        case 1: {
                            this.outgoingSeq = new Random().nextLong();
                            this.sendMsg(2, this.outgoingSeq, 0);
                            break;
                        }
                        case 2: {
                            this.lastAckedSeq = this.highestInSeq = seq;
                            this.state = 2;
                            this.notifyAll();
                        }
                    }
                    break;
                }
                case 2: {
                    switch (type) {
                        case 3: {
                            this.incomingQueue.put(msg, seq);
                            break;
                        }
                        case 4: {
                            Object pendingRetransmit = this.pendingRetransmits.get(new Long(seq));
                            if (pendingRetransmit == null) break;
                            ReliablePipeService.this.schedulerService.cancelAction(pendingRetransmit);
                            this.pendingRetransmits.remove(new Long(seq));
                            this.outgoingQueue.slide(seq - this.lastAckedSeq);
                            this.lastAckedSeq = seq;
                            this.outgoingWindow = window;
                            break;
                        }
                        case 5: {
                            this.state = 4;
                        }
                    }
                }
                case 4: {
                    switch (type) {
                        case 6: {
                            this.state = 5;
                        }
                    }
                }
            }
        }

        void sendMsg(int type, long seq, int window) throws IOException {
            Message msg = ReliablePipeService.this.bidirPipeService.pipeService.createMessage();
            this.setHeader(msg, type, seq, window);
            this.outputPipe.send(msg);
            if (type != 4) {
                Object pendingRetransmit = ReliablePipeService.this.schedulerService.scheduleAction(new RetransmitAction(msg), 1000L);
                this.pendingRetransmits.put(msg, pendingRetransmit);
            }
        }

        void sendMsg(Message msg, long seq) throws IOException {
            this.setHeader(msg, 3, seq, 0);
            this.outputPipe.send(msg);
            Object pendingRetransmit = ReliablePipeService.this.schedulerService.scheduleAction(new RetransmitAction(msg), 1000L);
            this.pendingRetransmits.put(msg, pendingRetransmit);
        }

        void setHeader(Message msg, int type, long seq, int window) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(12);
            DataOutputStream dout = new DataOutputStream(out);
            dout.writeLong(seq);
            dout.writeInt(type);
            dout.writeInt(window);
            msg.newMessageElement(ReliablePipeService.RELIABLE_HEADER, null, out.toByteArray());
        }

        class RetransmitAction
        implements SchedulerService.Action {
            Message msg;
            int retransmits;

            RetransmitAction(Message msg) {
                this.msg = msg;
            }

            public void perform(SchedulerService ss) {
                try {
                    Pipe.this.outputPipe.send(this.msg);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this.retransmits < 5) {
                    Object pendingRetransmit = ss.scheduleAction(this, 1000L);
                    Pipe.this.pendingRetransmits.put(this.msg, pendingRetransmit);
                } else {
                    Pipe.this.state = 3;
                    this.notifyAll();
                }
            }
        }

        class Sender
        implements Runnable {
            Sender() {
            }

            public void run() {
                Timer t = new Timer();
                block6: while (Pipe.this.state != 4 || !Pipe.this.outgoingQueue.isEmpty()) {
                    t.start();
                    int i = 0;
                    while (i < Pipe.this.outgoingWindow) {
                        try {
                            Message m = Pipe.this.outgoingQueue.get(i, 500L - t.elapsed());
                            if (m == null) continue block6;
                            try {
                                Pipe.this.sendMsg(m, Pipe.this.outgoingSeq++);
                            }
                            catch (IOException e) {}
                        }
                        catch (InterruptedException e) {
                            continue block6;
                        }
                        ++i;
                    }
                }
                if (Pipe.this.state == 4) {
                    try {
                        Pipe.this.sendMsg(6, Pipe.this.outgoingSeq++, 0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        class Receiver
        implements Runnable {
            Receiver() {
            }

            public void run() {
                while (Pipe.this.state != 5) {
                    try {
                        Message msg = Pipe.this.inputPipe.poll(30000);
                        if (!Pipe.this.running) break;
                        if (msg == null) continue;
                        Pipe.this.process(msg);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public class AcceptPipe {
        BidirectionalPipeService.AcceptPipe acceptPipe;

        AcceptPipe(BidirectionalPipeService.AcceptPipe acceptPipe) {
            this.acceptPipe = acceptPipe;
        }

        public PipeAdvertisement getAdvertisement() {
            return this.acceptPipe.getAdvertisement();
        }

        public Pipe accept(int maxTimeout) throws IOException, InterruptedException {
            long start = System.currentTimeMillis();
            BidirectionalPipeService.Pipe bidirPipe = this.acceptPipe.accept(maxTimeout);
            if ((maxTimeout = (int)((long)maxTimeout - (System.currentTimeMillis() - (long)maxTimeout))) > 0) {
                return new Pipe(bidirPipe, maxTimeout);
            }
            throw new IOException("Connect timed out.");
        }
    }
}

