/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

public abstract class PriorityQueue {
    private Object[] heap;
    private int size;
    private int growthFactor;

    protected abstract boolean lessThan(Object var1, Object var2);

    protected final void initialize(int startSize) {
        this.size = 0;
        int heapSize = startSize * 2 + 1;
        this.heap = new Object[heapSize];
        this.growthFactor = 2;
    }

    protected final void initialize(int startSize, int growthFactor) {
        this.size = 0;
        this.heap = new Object[startSize];
        this.growthFactor = growthFactor;
    }

    public final void put(Object element) {
        this.ensure(1);
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
    }

    public final Object top() {
        if (this.size > 0) {
            return this.heap[1];
        }
        return null;
    }

    public final Object pop() {
        if (this.size > 0) {
            Object result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return result;
        }
        return null;
    }

    public final void adjustTop() {
        this.downHeap();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        int i = 0;
        while (i < this.size) {
            this.heap[i] = null;
            ++i;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int i = this.size;
        Object node = this.heap[i];
        int j = i >>> 1;
        while (j > 0 && this.lessThan(node, this.heap[j])) {
            this.heap[i] = this.heap[j];
            i = j;
            j >>>= 1;
        }
        this.heap[i] = node;
    }

    private final void downHeap() {
        int i = 1;
        Object node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    private void ensure(int more) {
        if (this.size + more >= this.heap.length) {
            int newLen = this.heap.length * this.growthFactor;
            Object[] newHeap = new Object[newLen];
            System.arraycopy(this.heap, 0, newHeap, 0, this.heap.length);
            this.heap = newHeap;
        }
    }
}

