/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.id.ID;
import net.jxta.peer.PeerID;
import net.jxta.protocol.PeerAdvertisement;

public class AdvertisementCache {
    private static final int INITIAL_ENTRY = 1024;
    private int maxSize = 5120;
    private int entry = 0;
    private Hashtable cache = new Hashtable(1024);

    private synchronized void storeAdvertisement(PeerAdvertisement adv) throws IOException {
        PeerID id = adv.getPeerID();
        if (this.entry <= this.maxSize) {
            if (this.cache.containsKey(id.toString())) {
                this.cache.put(id.toString(), adv);
                ++this.entry;
            }
        } else {
            throw new IOException("Reached maxSize " + this.maxSize);
        }
    }

    public synchronized void remove(String key) {
        this.cache.remove(key);
    }

    public synchronized Enumeration iterate() {
        return this.cache.keys();
    }

    public ID get(String id) {
        return (ID)this.cache.get(id);
    }

    public synchronized void flush() {
        this.cache.clear();
    }

    public synchronized void checkPoint(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeObject(this.cache);
        stream.flush();
        out.close();
    }

    public synchronized void initialize(String filename) throws ClassNotFoundException, IOException {
        FileInputStream in = new FileInputStream(filename);
        ObjectInputStream stream = new ObjectInputStream(in);
        try {
            this.cache = (Hashtable)stream.readObject();
            in.close();
            this.cache.clear();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Advertisement readAdvertisement(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        try {
            void everything;
            Advertisement adv = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), in);
            return everything;
        }
        catch (Exception everything) {
            throw new IOException(everything.toString());
        }
    }
}

