/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.ID;
import net.jxta.impl.relay.RelayLease;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.impl.util.Base64;
import net.jxta.impl.util.BoundedQueue;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RelayServer {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$RelayServer == null ? (class$net$jxta$impl$relay$RelayServer = RelayServer.class$("net.jxta.impl.relay.RelayServer")) : class$net$jxta$impl$relay$RelayServer).getName());
    private static Timer timer = new Timer();
    private static final String LEASE_LEN_KEY = "RelayServer.LeaseLength";
    private int leaseLength = 1800000;
    private SecureRandom random = null;
    private EndpointService endpoint = null;
    private HashMap leaseMap = new HashMap();
    private HashMap queueMap = new HashMap();
    private HashMap expirationTaskMap = new HashMap();
    private HashMap peerIdToLeaseIdMap = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$relay$RelayServer;

    public ID getPeerID() {
        return this.endpoint.getGroup().getPeerID();
    }

    public RelayServer(EndpointService endpoint, Properties prop) {
        this.endpoint = endpoint;
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"RelayServer does not have SHA1PRNG crypto algorithm");
            }
            throw new RuntimeException("RelayServer does not have SHA1PRNG crypto algorithm");
        }
        if (prop != null) {
            String leaseLenStr = prop.getProperty(LEASE_LEN_KEY);
            if (leaseLenStr != null) {
                try {
                    this.leaseLength = Integer.parseInt(leaseLenStr);
                }
                catch (NumberFormatException e) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Illegal value specified for RelayServer.LeaseLength");
                    }
                }
            } else if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Using default value for lease length");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("lease length = " + this.leaseLength));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Generating initial lease key");
        }
        this.generateLeaseId();
    }

    public synchronized RelayLease issueNewLease(String clientPeerId) {
        Object lease = null;
        String leaseId = (String)this.peerIdToLeaseIdMap.get(clientPeerId);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("issuing new lease for " + clientPeerId));
        }
        if (leaseId != null && LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Peer " + clientPeerId + " already has a lease"));
        }
        return this.newLease(clientPeerId, leaseId);
    }

    public synchronized RelayLease renewLease(String leaseId) throws RelayLeaseException {
        RelayLease oldLease;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("attempting to renew lease " + leaseId));
        }
        if ((oldLease = (RelayLease)this.leaseMap.get(leaseId)) == null || !oldLease.isValid()) {
            throw new RelayLeaseException("Existing lease is not valid");
        }
        String clientPeerId = oldLease.getPeerId();
        return this.newLease(clientPeerId, leaseId);
    }

    private RelayLease newLease(String clientPeerId, String leaseId) {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("making lease for peer " + clientPeerId + " with lease " + (leaseId == null ? "(none)" : leaseId)));
        }
        BoundedQueue queue = null;
        this.peerIdToLeaseIdMap.remove(clientPeerId);
        if (leaseId != null) {
            this.leaseMap.remove(leaseId);
            queue = (BoundedQueue)this.queueMap.remove(leaseId);
            TimerTask oldTask = (TimerTask)this.expirationTaskMap.get(leaseId);
            if (oldTask != null) {
                oldTask.cancel();
            }
            this.expirationTaskMap.remove(leaseId);
        } else {
            queue = new BoundedQueue(32);
        }
        String newLeaseId = this.generateLeaseId();
        RelayLease newLease = new RelayLease(clientPeerId, newLeaseId, this.leaseLength);
        this.leaseMap.put(newLeaseId, newLease);
        this.peerIdToLeaseIdMap.put(clientPeerId, newLeaseId);
        this.queueMap.put(newLeaseId, queue);
        LeaseExpirationTask task = new LeaseExpirationTask(newLeaseId, this);
        this.expirationTaskMap.put(newLeaseId, task);
        timer.schedule((TimerTask)task, this.leaseLength);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("peer " + clientPeerId + " new lease id = " + newLeaseId));
        }
        return newLease;
    }

    public synchronized boolean hasLease(String clientPeerId) {
        String leaseId = (String)this.peerIdToLeaseIdMap.get(clientPeerId);
        if (leaseId != null) {
            RelayLease lease = null;
            lease = (RelayLease)this.leaseMap.get(leaseId);
            if (lease != null && lease.isValid()) {
                return true;
            }
        }
        return false;
    }

    public synchronized String getLeaseId(String clientPeerId) {
        return (String)this.peerIdToLeaseIdMap.get(clientPeerId);
    }

    public synchronized BoundedQueue getOutboundMessageQueueByPeerId(String clientPeerId) {
        String leaseId = (String)this.peerIdToLeaseIdMap.get(clientPeerId);
        if (leaseId != null) {
            return (BoundedQueue)this.queueMap.get(leaseId);
        }
        return null;
    }

    public synchronized BoundedQueue getOutboundMessageQueueByLeaseId(String leaseId) {
        return (BoundedQueue)this.queueMap.get(leaseId);
    }

    private String generateLeaseId() {
        byte[] buf = new byte[16];
        this.random.nextBytes(buf);
        return new String(Base64.encodeBase64(buf)).trim();
    }

    public void removeLease(String leaseId) {
        BoundedQueue queue = null;
        RelayServer relayServer = this;
        synchronized (relayServer) {
            RelayLease oldLease = null;
            oldLease = (RelayLease)this.leaseMap.get(leaseId);
            this.leaseMap.remove(leaseId);
            this.peerIdToLeaseIdMap.remove(oldLease.getPeerId());
            this.expirationTaskMap.remove(leaseId);
            queue = (BoundedQueue)this.queueMap.get(leaseId);
            this.queueMap.remove(leaseId);
        }
        if (queue != null) {
            queue.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LeaseExpirationTask
    extends TimerTask {
        String leaseId = null;
        RelayServer relayServer = null;

        LeaseExpirationTask(String leaseId, RelayServer relayServer) {
            this.leaseId = leaseId;
            this.relayServer = relayServer;
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("expiring lease: " + this.leaseId));
            }
            this.relayServer.removeLease(this.leaseId);
        }
    }
}

