/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.ResolverResponseMsg;

public class ResolverResponse
extends ResolverResponseMsg {
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "jxta:Cred";
    private static final String queryIdTag = "QueryID";
    private static final String responseTag = "Response";

    public ResolverResponse(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), stream);
        this.readIt(doc);
    }

    public ResolverResponse(TextElement doc) {
        if (!ResolverResponseMsg.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.readIt(doc);
    }

    public void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                this.setCredential(StructuredDocumentUtils.copyAsDocument(elem));
                continue;
            }
            if (elem.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(responseTag)) continue;
            this.setResponse(elem.getTextValue());
        }
    }

    public ResolverResponse(String HandlerName, StructuredDocument Credential2, int QueryId, String Response) {
        this.setHandlerName(HandlerName);
        this.setCredential(Credential2);
        this.queryid = QueryId;
        this.setResponse(Response);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, ResolverResponseMsg.getAdvertisementType());
        TextElement e = adv.createElement(handlernameTag, this.getHandlerName());
        adv.appendChild((Element)e);
        if (this.getCredential() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCredential());
        }
        e = adv.createElement(queryIdTag, Integer.toString(this.queryid));
        adv.appendChild((Element)e);
        e = adv.createElement(responseTag, this.getResponse());
        adv.appendChild((Element)e);
        return adv;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            doc.sendToWriter(out);
            return out.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        handlernameTag = handlernameTag;
        credentialTag = credentialTag;
        queryIdTag = queryIdTag;
        responseTag = responseTag;
    }
}

