/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class StdPeerGroup
extends GenericPeerGroup {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$StdPeerGroup == null ? (class$net$jxta$impl$peergroup$StdPeerGroup = StdPeerGroup.class$("net.jxta.impl.peergroup.StdPeerGroup")) : class$net$jxta$impl$peergroup$StdPeerGroup).getName());
    private boolean initialized = false;
    private boolean started = false;
    private Hashtable applications = new Hashtable();
    private Hashtable protocols = new Hashtable();
    public static final StructuredTextDocument stdCompatStatement;
    public static final String stdUri = "http://www.jxta.org/download/jxta.jar";
    public static final String stdProvider = "sun.com";
    private ModuleImplAdvertisement allPurposeImplAdv = null;
    Vector disabledModules = new Vector();
    static /* synthetic */ Class class$net$jxta$impl$peergroup$StdPeerGroup;

    private static StructuredTextDocument mkCS() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Comp");
            TextElement e = doc.createElement("Efmt", "JDK1.4");
            doc.appendChild((Element)e);
            e = doc.createElement("Bind", "V1.0 Ref Impl");
            doc.appendChild((Element)e);
            return doc;
        }
        catch (Exception trbl) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Cannot create essential StructuredTextDocument.", (Throwable)trbl);
            }
            throw new RuntimeException("Cannot create essential StructuredTextDocument.");
        }
    }

    protected ModuleImplAdvertisement mkImplAdvBuiltin(ModuleSpecID specID, String code, String descr) {
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        implAdv.setModuleSpecID(specID);
        implAdv.setCompat(stdCompatStatement);
        implAdv.setCode(code);
        implAdv.setUri(stdUri);
        implAdv.setProvider(stdProvider);
        implAdv.setDescription(descr);
        return implAdv;
    }

    public boolean compatible(Element compat) {
        StringWriter mine = new StringWriter();
        StringWriter his = new StringWriter();
        try {
            ((StructuredTextDocument)compat).sendToWriter(his);
            stdCompatStatement.sendToWriter(mine);
        }
        catch (Exception any) {
            return false;
        }
        return his.toString().equals(mine.toString());
    }

    protected void loadAllModules(Hashtable modules, ModuleClassID thisClassOnly, boolean privileged) {
        Enumeration allKeys = modules.keys();
        while (allKeys.hasMoreElements()) {
            ModuleClassID classID = (ModuleClassID)allKeys.nextElement();
            Object value = modules.get(classID);
            if (thisClassOnly != null && !thisClassOnly.equals(classID)) continue;
            if (this.disabledModules.contains(classID)) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("disabled by configuration: " + classID.toString() + "."));
                }
                modules.remove(classID);
                if (thisClassOnly == null) continue;
                break;
            }
            if (value instanceof Module) {
                if (thisClassOnly == null) continue;
                break;
            }
            try {
                Module theModule = null;
                if (value instanceof ModuleImplAdvertisement) {
                    theModule = this.loadModule((ID)classID, (ModuleImplAdvertisement)value, privileged);
                } else if (value instanceof ModuleSpecID) {
                    theModule = this.loadModule(classID, (ModuleSpecID)value, 1, privileged);
                } else {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("skipping: " + classID.toString() + " (Unsupported descriptor)."));
                    }
                    modules.remove(classID);
                    if (thisClassOnly == null) continue;
                    break;
                }
                modules.put(classID, theModule);
                if (value instanceof ModuleClassID) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("loaded: " + theModule.getClass().getName()));
                    }
                } else if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("loaded: " + ((ModuleImplAdvertisement)value).getDescription()));
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Exception " + e.getClass().getName() + " loading module for class ID " + classID + ": " + e.getMessage() + "; this module will be removed from the peer group"));
                }
                if (value instanceof ModuleClassID) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("skipped: " + classID.toString() + " (" + e.getMessage() + ")."));
                    }
                } else if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("skipped: " + ((ModuleImplAdvertisement)value).getDescription() + " (" + e.getMessage() + ")."));
                }
                modules.remove(classID);
            }
            if (thisClassOnly != null) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] arg) {
        StdPeerGroup stdPeerGroup = this;
        synchronized (stdPeerGroup) {
            block7: {
                if (!this.started) break block7;
                int n = 0;
                return n;
            }
            this.started = true;
        }
        super.startApp(arg);
        this.loadAllModules(this.applications, null, false);
        int res = 0;
        Enumeration appKeys = this.applications.keys();
        while (appKeys.hasMoreElements()) {
            Object appKey = appKeys.nextElement();
            Module app = (Module)this.applications.get(appKey);
            int tmp = app.startApp(arg);
            if (tmp != 0) {
                this.applications.remove(appKey);
            } else {
                this.applications.put(appKey, app);
            }
            res += tmp;
        }
        return res;
    }

    public void stopApp() {
        Module module;
        Enumeration modules = this.applications.elements();
        if (modules != null) {
            while (modules.hasMoreElements()) {
                module = null;
                try {
                    module = (Module)modules.nextElement();
                    module.stopApp();
                }
                catch (Exception any) {
                    if (module == null || !LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)("Failed to stop application: " + module.getClass().getName()));
                }
            }
        }
        this.applications = null;
        modules = this.protocols.elements();
        if (modules != null) {
            while (modules.hasMoreElements()) {
                module = null;
                try {
                    module = (Module)modules.nextElement();
                    module.stopApp();
                }
                catch (Exception any) {
                    if (module == null || !LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)("Failed to stop application: " + module.getClass().getName()));
                }
            }
        }
        this.protocols = null;
        super.stopApp();
    }

    public void init(PeerGroup parent, ID assignedID, Advertisement impl) throws PeerGroupException {
        block18: {
            Module m;
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            if (this.initialized) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"You cannot initialize a PeerGroup more than once !");
                }
                return;
            }
            this.initialized = true;
            super.init(parent, assignedID, implAdv);
            PeerAdvertisement conf = (PeerAdvertisement)this.getConfigAdvertisement();
            if (conf != null) {
                Hashtable serviceParams = conf.getServiceParams();
                Enumeration keys = serviceParams.keys();
                while (keys.hasMoreElements()) {
                    ID key = (ID)keys.nextElement();
                    TextElement e = (TextElement)serviceParams.get(key);
                    if (!e.getChildren("isOff").hasMoreElements()) continue;
                    this.disabledModules.addElement(key);
                }
                conf = null;
                serviceParams = null;
            }
            StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(implAdv.getParam());
            this.applications = paramAdv.getApps();
            Hashtable services = paramAdv.getServices();
            this.protocols = paramAdv.getProtos();
            this.loadAllModules(services, PeerGroup.endpointClassID, true);
            Module endp = (Module)services.get(PeerGroup.endpointClassID);
            if (endp != null) {
                this.addService(PeerGroup.endpointClassID, (Service)endp);
                endp.startApp(null);
                services.remove(PeerGroup.endpointClassID);
                this.loadAllModules(this.protocols, null, true);
                Enumeration allProtos = this.protocols.elements();
                while (allProtos.hasMoreElements()) {
                    Module proto = (Module)allProtos.nextElement();
                }
            } else {
                if (parent != null) {
                    this.addService(PeerGroup.endpointClassID, parent.getEndpointService());
                    PeerAdvertisement peerAdv = this.getPeerAdvertisement();
                    PeerAdvertisement pPeerAdv = parent.getPeerAdvertisement();
                    peerAdv.putServiceParam(PeerGroup.endpointClassID, pPeerAdv.getServiceParam(PeerGroup.endpointClassID));
                }
                this.protocols.clear();
            }
            this.loadAllModules(services, null, true);
            Enumeration allKeys = services.keys();
            while (allKeys.hasMoreElements()) {
                ModuleClassID classID = (ModuleClassID)allKeys.nextElement();
                m = (Module)services.get(classID);
                if (m instanceof Service) {
                    this.addService(classID, (Service)m);
                    continue;
                }
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)("Suspicious service: " + classID.toString()));
                LOG.warn((Object)"is not an instance of Service.");
                LOG.warn((Object)"It will not be registered as a service.");
            }
            try {
                this.checkServices();
            }
            catch (ServiceNotFoundException e) {
                throw new PeerGroupException("Missing peer group service : " + e.getMessage());
            }
            catch (Exception e) {
                throw new PeerGroupException(e.getMessage());
            }
            Enumeration allModules = services.elements();
            while (allModules.hasMoreElements()) {
                m = (Module)allModules.nextElement();
                m.startApp(null);
            }
            allModules = this.protocols.elements();
            while (allModules.hasMoreElements()) {
                m = (Module)allModules.nextElement();
                m.startApp(null);
            }
            DiscoveryService disco = this.getDiscoveryService();
            if (disco != null) {
                try {
                    disco.publish(disco.getImplAdvertisement(), 2, 1471228928L, 1209600000L);
                    disco.publish(implAdv, 2, 1471228928L, 1209600000L);
                }
                catch (Exception nevermind) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block18;
                    LOG.warn((Object)"Failed to publish Impl adv within group.", (Throwable)nevermind);
                }
            }
        }
    }

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception {
        if (this.allPurposeImplAdv != null) {
            return (ModuleImplAdvertisement)this.allPurposeImplAdv.clone();
        }
        RefPeerGroup platf = this;
        while (platf.getParentGroup() != null) {
            platf = platf.getParentGroup();
        }
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)platf.getImplAdvertisement();
        implAdv.setModuleSpecID(PeerGroup.allPurposePeerGroupSpecID);
        implAdv.setDescription("General Purpose Peer Group Implementation");
        implAdv.setCode((class$net$jxta$impl$peergroup$StdPeerGroup == null ? (class$net$jxta$impl$peergroup$StdPeerGroup = StdPeerGroup.class$("net.jxta.impl.peergroup.StdPeerGroup")) : class$net$jxta$impl$peergroup$StdPeerGroup).getName());
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(paramElement);
        paramAdv.setProtos(null);
        Hashtable services = paramAdv.getServices();
        services.remove(PeerGroup.endpointClassID);
        paramAdv.setServices(services);
        ModuleImplAdvertisement newAppAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        newAppAdv.setModuleSpecID(PeerGroup.refShellSpecID);
        newAppAdv.setCompat(implAdv.getCompat());
        newAppAdv.setUri(implAdv.getUri());
        newAppAdv.setProvider(implAdv.getProvider());
        newAppAdv.setDescription("JXTA Shell reference implementation");
        newAppAdv.setCode("net.jxta.impl.shell.bin.Shell.Shell");
        Hashtable<ModuleClassID, ModuleImplAdvertisement> newApps = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        newApps.put(PeerGroup.applicationClassID, newAppAdv);
        paramAdv.setApps(newApps);
        paramElement = (TextElement)((Object)paramAdv.getDocument(new MimeMediaType("text", "xml")));
        implAdv.setParam(paramElement);
        this.allPurposeImplAdv = implAdv;
        return implAdv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            PeerGroupFactory.setStdPeerGroupClass(Class.forName("net.jxta.impl.peergroup.StdPeerGroup"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        stdCompatStatement = StdPeerGroup.mkCS();
        stdUri = stdUri;
        stdProvider = stdProvider;
    }
}

