/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index.xpath;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jxta.impl.index.xpath.Expression;

public class XPath {
    public static final int NONE = 0;
    public static final int AXIS = 1;
    public static final int RELATIVE_AXIS = 2;
    public static final int PREDICATE = 3;
    public static final int PREDICATE_LITERAL = 4;
    public static final String TERMINALS = " \t\r\n,.:;";
    int state = 0;
    int tokenStart = 0;
    char[] chars;
    Token first;
    Token last;

    public XPath(String path) {
        this.chars = path.toCharArray();
        this.parse();
    }

    XPath(Token first, Token last) {
        this.first = new Token(first.type, first.value);
        this.last = first == last ? this.first : new Token(last.type, last.value);
        Token curCopy = this.first;
        Token cur = first.next;
        curCopy = this.first;
        while (cur != last) {
            curCopy.next = new Token(cur.type, cur.value);
            cur = cur.next;
            curCopy = curCopy.next;
        }
        curCopy.next = this.last;
    }

    public static void main(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            XPath path = new XPath(argv[i]);
            System.out.println("Path " + path);
            Expression.LogicalExpression allPathCNF = path.unroll();
            if (allPathCNF instanceof Expression.Clause) {
                Expression.Clause clause = Expression.toCNF((Expression.Clause)allPathCNF);
            }
            ++i;
        }
    }

    public Token getFirstToken() {
        return this.first;
    }

    String getStart(String val) {
        int equals = val.indexOf(61);
        return val.substring(0, equals);
    }

    StringTokenizer tokenize(String val) {
        int firstQuote = val.indexOf(39);
        int lastQuote = val.lastIndexOf(39);
        val = val.substring(firstQuote + 1, lastQuote);
        return new StringTokenizer(val, TERMINALS);
    }

    public Expression.LogicalExpression unroll() {
        Vector set = new Vector();
        Token prev = null;
        boolean flat = true;
        Token t = this.first;
        while (t != null) {
            if (t.type == 3) {
                Expression expr = new Expression(t.value);
                Expression.LogicalExpression cnf = expr.getRootClause();
                Expression.Clause conjPathClause = new Expression.Clause("and");
                if (cnf instanceof Expression.Clause) {
                    Expression.Clause clause = (Expression.Clause)cnf;
                    Enumeration disjunctions = clause.getSubexpressions();
                    String oldValue = t.value;
                    while (disjunctions.hasMoreElements()) {
                        Expression.LogicalExpression term = (Expression.LogicalExpression)disjunctions.nextElement();
                        if (term instanceof Expression.Clause) {
                            Expression.Clause disjunction = (Expression.Clause)term;
                            Enumeration literals = disjunction.getSubexpressions();
                            Expression.Clause disjPathClause = new Expression.Clause("or");
                            while (literals.hasMoreElements()) {
                                Expression.Literal l = (Expression.Literal)literals.nextElement();
                                disjPathClause.addSubexpression(this.splitAndAdd(l, t));
                            }
                            t.value = oldValue;
                            t.type = 4;
                            conjPathClause.addSubexpression(disjPathClause);
                            continue;
                        }
                        Expression.Literal l = (Expression.Literal)term;
                        conjPathClause.addSubexpression(this.splitAndAdd(l, t));
                    }
                    return Expression.toCNF(conjPathClause);
                }
                t.type = 4;
                return this.splitAndAdd((Expression.Literal)cnf, t);
            }
            prev = t;
            t = t.next;
        }
        return new Expression.Literal(this);
    }

    Expression.LogicalExpression splitAndAdd(Expression.Literal literal, Token t) {
        String litValue = (String)literal.getName();
        StringTokenizer st = this.tokenize(litValue);
        Expression.Clause clause = new Expression.Clause("and");
        String start = this.getStart(litValue);
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            t.value = start + "='" + s + '\'';
            t.type = 4;
            Expression.Clause or = new Expression.Clause("or");
            or.addSubexpression(new XPath(this.first, this.last).unroll());
            clause.addSubexpression(or);
        }
        return clause;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Token t = this.first;
        while (t != null) {
            sb.append(t);
            t = t.next;
        }
        return sb.toString();
    }

    void startToken(int state, int pos) {
        this.state = state;
        this.tokenStart = pos + 1;
    }

    void endToken(int state, int pos) {
        if (this.tokenStart != -1) {
            Token t = new Token(this.state, new String(this.chars, this.tokenStart, pos - this.tokenStart));
            if (this.first == null) {
                this.first = this.last = t;
            } else {
                this.last.next = t;
                this.last = t;
            }
            this.state = state;
            this.tokenStart = -1;
        }
    }

    void parse() {
        int i = 0;
        while (i < this.chars.length) {
            switch (this.state) {
                case 0: {
                    if (this.chars[i] == '/') {
                        this.startToken(1, i);
                        break;
                    }
                    throw new IllegalArgumentException("XPath expression must start with a /");
                }
                case 1: {
                    if (this.chars[i] == '/') {
                        if (this.chars[i - 1] == '/') {
                            this.startToken(2, i);
                            break;
                        }
                        this.endToken(1, i);
                        this.startToken(1, i);
                        break;
                    }
                    if (this.chars[i] != '[') break;
                    this.endToken(3, i);
                    this.startToken(3, i);
                    break;
                }
                case 2: {
                    if (this.chars[i] == '/') {
                        this.endToken(1, i);
                        this.startToken(1, i);
                        break;
                    }
                    if (this.chars[i] != '[') break;
                    this.endToken(3, i);
                    this.startToken(3, i);
                    break;
                }
                case 3: {
                    if (this.chars[i] != ']') break;
                    this.endToken(0, i);
                }
            }
            ++i;
        }
        this.endToken(0, this.chars.length);
    }

    public class Token {
        int type;
        String value;
        Token next;

        Token(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public Token getNext() {
            return this.next;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return this.value;
                }
                case 1: {
                    return "/" + this.value;
                }
                case 2: {
                    return "//" + this.value;
                }
                case 3: 
                case 4: {
                    return "[" + this.value + "]";
                }
            }
            throw new IllegalStateException();
        }
    }
}

