/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.util.BitSet;
import net.jxta.impl.index.BloomFilter;
import net.jxta.impl.index.SummaryUpdate;
import net.jxta.impl.index.xpath.Expression;

public class RemoteSummary {
    BitSet summary;
    BloomFilter bf;
    String id;

    public RemoteSummary(SummaryUpdate su) {
        this.bf = new BloomFilter(su.getProperties());
        this.id = su.getId();
        this.summary = new BitSet();
        this.update(su);
    }

    public boolean query(Expression.Literal[] literals) {
        if (literals == null) {
            return false;
        }
        int i = 0;
        while (i < literals.length) {
            int[] bitPositions = this.bf.getBitPositions(literals[i].getName().toString());
            int j = 0;
            while (j < bitPositions.length) {
                if (!this.summary.get(bitPositions[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void update(SummaryUpdate su) {
        int[] changedBits;
        int mask = Integer.MAX_VALUE;
        if (!this.bf.getProperties().equals(su.getProperties())) {
            this.bf = new BloomFilter(su.getProperties());
            this.summary = new BitSet();
        }
        if ((changedBits = su.getBitPositions()) == null) {
            return;
        }
        int nChanges = changedBits.length;
        int i = 0;
        while (i < nChanges) {
            int bitToChange = changedBits[i];
            if (bitToChange < 0) {
                this.summary.clear(bitToChange &= mask);
            } else {
                this.summary.set(bitToChange);
            }
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }
}

